/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.codegen;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.catalog.OASISCatalogManager;
import org.apache.cxf.catalog.OASISCatalogManagerHelper;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.common.util.ReflectionInvokationHandler;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.jaxb.JAXBUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.service.model.SchemaInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceGenerator {
    public static final String CODE_TYPE_GRAMMAR = "grammar";
    public static final String CODE_TYPE_PROXY = "proxy";
    public static final String CODE_TYPE_WEB = "web";
    public static final String LINE_SEP_PROPERTY = "line.separator";
    public static final String FILE_SEP_PROPERTY = "file.separator";
    private static final Logger LOG = LogUtils.getL7dLogger(SourceGenerator.class);
    private static final String DEFAULT_PACKAGE_NAME = "application";
    private static final String DEFAULT_RESOURCE_NAME = "Resource";
    private static final String TAB = "    ";
    private static final Map<String, Class<?>> HTTP_METHOD_ANNOTATIONS = new HashMap();
    private static final Map<String, Class<?>> PARAM_ANNOTATIONS;
    private static final Set<String> RESOURCE_LEVEL_PARAMS;
    private static final Map<String, String> AUTOBOXED_PRIMITIVES_MAP;
    private Comparator<String> importsComparator;
    private boolean generateInterfaces = true;
    private boolean generateImpl;
    private String resourcePackageName;
    private String resourceName;
    private String wadlPath;
    private Map<String, String> properties;
    private List<String> generatedServiceClasses = new ArrayList<String>();
    private List<String> generatedTypeClasses = new ArrayList<String>();
    private List<InputSource> bindingFiles = Collections.emptyList();
    private List<InputSource> schemaPackageFiles = Collections.emptyList();
    private List<String> compilerArgs = new ArrayList<String>();
    private Map<String, String> schemaPackageMap = Collections.emptyMap();
    private Map<String, String> schemaTypesMap = Collections.emptyMap();
    private Bus bus;

    public SourceGenerator() {
        this(Collections.emptyMap());
    }

    public SourceGenerator(Map<String, String> properties) {
        this.properties = properties;
    }

    private String getClassPackageName(String wadlPackageName) {
        if (this.resourcePackageName != null) {
            return this.resourcePackageName;
        }
        if (wadlPackageName != null && wadlPackageName.length() > 0) {
            return wadlPackageName;
        }
        return DEFAULT_PACKAGE_NAME;
    }

    private String getLineSep() {
        String value = this.properties.get(LINE_SEP_PROPERTY);
        return value == null ? System.getProperty(LINE_SEP_PROPERTY) : value;
    }

    private String getFileSep() {
        String value = this.properties.get(FILE_SEP_PROPERTY);
        return value == null ? System.getProperty(FILE_SEP_PROPERTY) : value;
    }

    public void generateSource(String wadl, File srcDir, String codeType) {
        Application app = this.readWadl(wadl, this.wadlPath);
        HashSet<String> typeClassNames = new HashSet<String>();
        GrammarInfo gInfo = this.generateSchemaCodeAndInfo(app, typeClassNames, srcDir);
        if (!CODE_TYPE_GRAMMAR.equals(codeType)) {
            this.generateResourceClasses(app, gInfo, typeClassNames, srcDir);
        }
    }

    private GrammarInfo generateSchemaCodeAndInfo(Application app, Set<String> typeClassNames, File srcDir) {
        JAXBUtils.JCodeModel codeModel;
        List<SchemaInfo> schemaElements = this.getSchemaElements(app);
        if (schemaElements != null && !schemaElements.isEmpty() && (codeModel = this.createCodeModel(schemaElements, typeClassNames)) != null) {
            this.generateClassesFromSchema(codeModel, srcDir);
        }
        return this.getGrammarInfo(app, schemaElements);
    }

    private void generateResourceClasses(Application app, GrammarInfo gInfo, Set<String> typeClassNames, File src) {
        Element appElement = app.getAppElement();
        List<Element> resourcesEls = DOMUtils.getChildrenWithName(appElement, "http://wadl.dev.java.net/2009/02", "resources");
        if (resourcesEls.size() != 1) {
            throw new IllegalStateException("WADL resources element is missing");
        }
        List<Element> resourceEls = DOMUtils.getChildrenWithName(resourcesEls.get(0), "http://wadl.dev.java.net/2009/02", "resource");
        if (resourceEls.size() == 0) {
            throw new IllegalStateException("WADL has no resource elements");
        }
        for (int i = 0; i < resourceEls.size(); ++i) {
            Element resource = this.getResourceElement(app, resourceEls.get(i), gInfo, typeClassNames, resourceEls.get(i).getAttribute("type"), src);
            this.writeResourceClass(app, resource, new ContextInfo(typeClassNames, gInfo, this.generateInterfaces), src, true);
            if (this.generateInterfaces && this.generateImpl) {
                this.writeResourceClass(app, resource, new ContextInfo(typeClassNames, gInfo, false), src, true);
            }
            if (this.resourceName != null) break;
        }
        this.generateMainClass(resourcesEls.get(0), src);
    }

    private Element getResourceElement(Application app, Element resElement, GrammarInfo gInfo, Set<String> typeClassNames, String type, File srcDir) {
        if (type.length() > 0) {
            if (type.startsWith("#")) {
                String refId = type.substring(1);
                List<Element> resourceTypes = DOMUtils.getChildrenWithName(app.getAppElement(), "http://wadl.dev.java.net/2009/02", "resource_type");
                for (Element resourceType : resourceTypes) {
                    if (!refId.equals(resourceType.getAttribute("id"))) continue;
                    Element realElement = (Element)resourceType.cloneNode(true);
                    DOMUtils.setAttribute(realElement, "id", resElement.getAttribute("id"));
                    DOMUtils.setAttribute(realElement, "path", resElement.getAttribute("path"));
                    return realElement;
                }
            } else {
                URI wadlRef = URI.create(type);
                String wadlRefPath = app.getWadlPath() != null ? SourceGenerator.getBaseWadlPath(app.getWadlPath()) + wadlRef.getPath() : wadlRef.getPath();
                Application refApp = new Application(this.readIncludedDocument(wadlRefPath), wadlRefPath);
                GrammarInfo gInfoBase = this.generateSchemaCodeAndInfo(refApp, typeClassNames, srcDir);
                if (gInfoBase != null) {
                    gInfo.getElementTypeMap().putAll(gInfoBase.getElementTypeMap());
                    gInfo.getNsMap().putAll(gInfoBase.getNsMap());
                }
                return this.getResourceElement(refApp, resElement, gInfo, typeClassNames, "#" + wadlRef.getFragment(), srcDir);
            }
        }
        return resElement;
    }

    private GrammarInfo getGrammarInfo(Application app, List<SchemaInfo> schemaElements) {
        if (schemaElements == null || schemaElements.isEmpty()) {
            return new GrammarInfo();
        }
        HashMap<String, String> nsMap = new HashMap<String, String>();
        NamedNodeMap attrMap = app.getAppElement().getAttributes();
        for (int i = 0; i < attrMap.getLength(); ++i) {
            Node node = attrMap.item(i);
            String nodeName = node.getNodeName();
            if (!nodeName.startsWith("xmlns:")) continue;
            String nsValue = node.getNodeValue();
            nsMap.put(nodeName.substring(6), nsValue);
        }
        HashMap<String, String> elementTypeMap = new HashMap<String, String>();
        for (SchemaInfo schemaEl : schemaElements) {
            this.populateElementTypeMap(app, schemaEl.getElement(), schemaEl.getSystemId(), elementTypeMap);
        }
        return new GrammarInfo(nsMap, elementTypeMap);
    }

    private void populateElementTypeMap(Application app, Element schemaEl, String systemId, Map<String, String> elementTypeMap) {
        int ind;
        List<Element> elementEls = DOMUtils.getChildrenWithName(schemaEl, "http://www.w3.org/2001/XMLSchema", "element");
        for (Element el : elementEls) {
            String type = el.getAttribute("type");
            if (type.length() <= 0) continue;
            String[] pair = type.split(":");
            elementTypeMap.put(el.getAttribute("name"), pair.length == 1 ? pair[0] : pair[1]);
        }
        Element includeEl = DOMUtils.getFirstChildWithName(schemaEl, "http://www.w3.org/2001/XMLSchema", "include");
        if (includeEl != null && (ind = systemId.lastIndexOf("/")) != -1) {
            String schemaURI = systemId.substring(0, ind + 1) + includeEl.getAttribute("schemaLocation");
            this.populateElementTypeMap(app, this.readIncludedDocument(schemaURI), schemaURI, elementTypeMap);
        }
    }

    public void generateMainClass(Element resourcesEl, File src) {
    }

    private void writeResourceClass(Application app, Element rElement, ContextInfo info, File src, boolean isRoot) {
        boolean expandedQName;
        QName qname;
        String namespaceURI;
        String resourceId;
        String string = resourceId = this.resourceName != null ? this.resourceName : rElement.getAttribute("id");
        if (resourceId.length() == 0) {
            resourceId = DEFAULT_RESOURCE_NAME;
        }
        if (this.getSchemaClassName(namespaceURI = this.possiblyConvertNamespaceURI((qname = this.convertToQName(resourceId, expandedQName = resourceId.startsWith("{"))).getNamespaceURI(), expandedQName), info.getGrammarInfo(), qname.getLocalPart(), info.getTypeClassNames()) != null) {
            return;
        }
        String className = this.getClassName(qname.getLocalPart(), info.isInterfaceGenerated(), info.getTypeClassNames());
        if (info.getResourceClassNames().contains(className)) {
            return;
        }
        info.getResourceClassNames().add(className);
        String classPackage = this.getClassPackageName(namespaceURI);
        StringBuilder sbImports = new StringBuilder();
        StringBuilder sbCode = new StringBuilder();
        Set<String> imports = this.createImports();
        sbImports.append(this.getClassComment()).append(this.getLineSep());
        sbImports.append("package " + classPackage).append(";").append(this.getLineSep()).append(this.getLineSep());
        if (isRoot && this.writeAnnotations(info.isInterfaceGenerated())) {
            String path = rElement.getAttribute("path");
            this.writeAnnotation(sbCode, imports, Path.class, path, true, false);
        }
        sbCode.append("public " + this.getClassType(info.interfaceIsGenerated) + " " + className);
        this.writeImplementsInterface(sbCode, qname.getLocalPart(), info.isInterfaceGenerated());
        sbCode.append(" {" + this.getLineSep() + this.getLineSep());
        this.writeMethods(rElement, imports, sbCode, info, resourceId, isRoot, "");
        sbCode.append("}");
        this.writeImports(sbImports, imports, classPackage);
        this.createJavaSourceFile(src, new QName(classPackage, className), sbCode, sbImports);
        this.writeSubresourceClasses(app, rElement, info, src, isRoot, resourceId);
    }

    private void writeSubresourceClasses(Application app, Element rElement, ContextInfo info, File src, boolean isRoot, String resourceId) {
        List<Element> childEls = DOMUtils.getChildrenWithName(rElement, "http://wadl.dev.java.net/2009/02", "resource");
        for (Element subEl : childEls) {
            String id = subEl.getAttribute("id");
            if (!(id.length() <= 0 || resourceId.equals(id) || id.startsWith("{java") || id.startsWith("java"))) {
                Element subElement = this.getResourceElement(app, subEl, info.getGrammarInfo(), info.getTypeClassNames(), subEl.getAttribute("type"), src);
                this.writeResourceClass(app, subElement, info, src, false);
            }
            this.writeSubresourceClasses(app, subEl, info, src, false, id);
        }
    }

    private QName convertToQName(String resourceId, boolean expandedQName) {
        int lastIndex;
        QName qname = null;
        qname = expandedQName ? JAXRSUtils.convertStringToQName(resourceId) : ((lastIndex = resourceId.lastIndexOf(".")) == -1 ? new QName(resourceId) : new QName(resourceId.substring(0, lastIndex), resourceId.substring(lastIndex + 1)));
        return qname;
    }

    private String getClassType(boolean interfaceIsGenerated) {
        return interfaceIsGenerated ? "interface" : "class";
    }

    private String getClassName(String clsName, boolean interfaceIsGenerated, Set<String> typeClassNames) {
        String name = null;
        name = interfaceIsGenerated ? clsName : (this.generateInterfaces ? clsName + "Impl" : clsName);
        StringBuilder sb = new StringBuilder();
        sb.append(Character.toUpperCase(name.charAt(0)));
        name = name.length() > 1 ? sb.append(name.substring(1)).toString() : sb.toString();
        for (String typeName : typeClassNames) {
            String localName = typeName.contains(".") ? typeName.substring(typeName.lastIndexOf(46) + 1) : typeName;
            if (!name.equalsIgnoreCase(localName)) continue;
            name = name + DEFAULT_RESOURCE_NAME;
        }
        return name;
    }

    private boolean writeAnnotations(boolean interfaceIsGenerated) {
        if (interfaceIsGenerated) {
            return true;
        }
        return !this.generateInterfaces && this.generateImpl;
    }

    private void writeImplementsInterface(StringBuilder sb, String clsName, boolean interfaceIsGenerated) {
        if (this.generateInterfaces && !interfaceIsGenerated) {
            sb.append(" implements " + clsName);
        }
    }

    private String getClassComment() {
        return "/**" + this.getLineSep() + " * Created by Apache CXF WadlToJava code generator" + this.getLineSep() + "**/";
    }

    private void writeMethods(Element rElement, Set<String> imports, StringBuilder sbCode, ContextInfo info, String resourceId, boolean isRoot, String currentPath) {
        List<Element> methodEls = DOMUtils.getChildrenWithName(rElement, "http://wadl.dev.java.net/2009/02", "method");
        for (Element methodEl : methodEls) {
            this.writeResourceMethod(methodEl, imports, sbCode, info, isRoot, currentPath);
        }
        List<Element> childEls = DOMUtils.getChildrenWithName(rElement, "http://wadl.dev.java.net/2009/02", "resource");
        for (Element childEl : childEls) {
            String path = childEl.getAttribute("path");
            String newPath = (currentPath + path).replace("//", "/");
            String id = childEl.getAttribute("id");
            if (id.length() == 0) {
                this.writeMethods(childEl, imports, sbCode, info, id, false, newPath);
                continue;
            }
            this.writeResourceMethod(childEl, imports, sbCode, info, false, newPath);
        }
    }

    private void writeAnnotation(StringBuilder sbCode, Set<String> imports, Class<?> cls, String value, boolean nextLine, boolean addTab) {
        if (value != null && value.length() == 0) {
            return;
        }
        this.addImport(imports, cls.getName());
        sbCode.append("@").append(cls.getSimpleName());
        if (value != null) {
            sbCode.append("(\"" + value + "\")");
        }
        if (nextLine) {
            sbCode.append(this.getLineSep());
            if (addTab) {
                sbCode.append(TAB);
            }
        }
    }

    private void addImport(Set<String> imports, String clsName) {
        if (imports == null || clsName.startsWith("java.lang")) {
            return;
        }
        if (!imports.contains(clsName)) {
            imports.add(clsName);
        }
    }

    private void writeImports(StringBuilder sbImports, Set<String> imports, String classPackage) {
        for (String clsName : imports) {
            int index = clsName.lastIndexOf(".");
            if (index != -1 && clsName.substring(0, index).equals(classPackage)) continue;
            sbImports.append("import " + clsName).append(";").append(this.getLineSep());
        }
    }

    private void writeResourceMethod(Element methodEl, Set<String> imports, StringBuilder sbCode, ContextInfo info, boolean isRoot, String currentPath) {
        Element firstRequestEl;
        boolean isResourceElement = "resource".equals(methodEl.getLocalName());
        Element resourceEl = isResourceElement ? methodEl : (Element)methodEl.getParentNode();
        String methodName = methodEl.getAttribute("name");
        String methodNameLowerCase = methodName.toLowerCase();
        String id = methodEl.getAttribute("id");
        if (id.length() == 0) {
            id = methodNameLowerCase;
        }
        List<Element> responseEls = DOMUtils.getChildrenWithName(methodEl, "http://wadl.dev.java.net/2009/02", "response");
        List<Element> requestEls = DOMUtils.getChildrenWithName(methodEl, "http://wadl.dev.java.net/2009/02", "request");
        Element element = firstRequestEl = requestEls.size() >= 1 ? requestEls.get(0) : null;
        if (this.writeAnnotations(info.isInterfaceGenerated())) {
            sbCode.append(TAB);
            if (methodNameLowerCase.length() > 0) {
                if (HTTP_METHOD_ANNOTATIONS.containsKey(methodNameLowerCase)) {
                    this.writeAnnotation(sbCode, imports, HTTP_METHOD_ANNOTATIONS.get(methodNameLowerCase), null, true, true);
                }
                this.writeFormatAnnotations(firstRequestEl, sbCode, imports, true);
                this.writeFormatAnnotations(this.getOKResponse(responseEls), sbCode, imports, false);
            }
            if (!isRoot && !"/".equals(currentPath)) {
                this.writeAnnotation(sbCode, imports, Path.class, currentPath, true, true);
            }
        } else {
            sbCode.append(this.getLineSep()).append(TAB);
        }
        if (!info.isInterfaceGenerated()) {
            sbCode.append("public ");
        }
        boolean responseTypeAvailable = true;
        if (methodNameLowerCase.length() > 0) {
            responseTypeAvailable = this.writeResponseType(responseEls, sbCode, imports, info.getTypeClassNames(), info.getGrammarInfo());
            sbCode.append(id);
        } else {
            boolean expandedQName = id.startsWith("{");
            QName qname = this.convertToQName(id, expandedQName);
            String packageName = this.possiblyConvertNamespaceURI(qname.getNamespaceURI(), expandedQName);
            String clsSimpleName = this.getSchemaClassName(packageName, info.getGrammarInfo(), qname.getLocalPart(), info.getTypeClassNames());
            String localName = clsSimpleName == null ? this.getClassName(qname.getLocalPart(), true, info.getTypeClassNames()) : clsSimpleName.substring(packageName.length() + 1);
            String subResponseNs = clsSimpleName == null ? this.getClassPackageName(packageName) : clsSimpleName.substring(0, packageName.length());
            String parentId = ((Element)resourceEl.getParentNode()).getAttribute("id");
            this.writeSubResponseType(id.equals(parentId), subResponseNs, localName, sbCode, imports);
            sbCode.append("get" + localName);
        }
        sbCode.append("(");
        List<Element> inParamElements = this.getParameters(resourceEl, !isRoot && !isResourceElement && resourceEl.getAttribute("id").length() > 0);
        this.writeRequestTypes(firstRequestEl, inParamElements, sbCode, imports, info);
        sbCode.append(")");
        if (info.isInterfaceGenerated()) {
            sbCode.append(";");
        } else {
            this.generateEmptyMethodBody(sbCode, responseTypeAvailable);
        }
        sbCode.append(this.getLineSep()).append(this.getLineSep());
    }

    private List<Element> getParameters(Element resourceEl, boolean isSubresourceMethod) {
        LinkedList<Element> inParamElements = new LinkedList<Element>();
        List<Element> allParamElements = DOMUtils.getChildrenWithName(resourceEl, "http://wadl.dev.java.net/2009/02", "param");
        for (Element el : allParamElements) {
            if (isSubresourceMethod && RESOURCE_LEVEL_PARAMS.contains(el.getAttribute("style"))) continue;
            inParamElements.add(el);
        }
        return inParamElements;
    }

    private String possiblyConvertNamespaceURI(String nsURI, boolean expandedQName) {
        return expandedQName ? this.getPackageFromNamespace(nsURI) : nsURI;
    }

    private String getPackageFromNamespace(String nsURI) {
        return this.schemaPackageMap.containsKey(nsURI) ? this.schemaPackageMap.get(nsURI) : PackageUtils.getPackageNameByNameSpaceURI(nsURI);
    }

    private void generateEmptyMethodBody(StringBuilder sbCode, boolean responseTypeAvailable) {
        sbCode.append(" {");
        sbCode.append(this.getLineSep()).append(TAB).append(TAB);
        sbCode.append("//TODO: implement").append(this.getLineSep()).append(TAB);
        if (responseTypeAvailable) {
            sbCode.append(TAB).append("return null;").append(this.getLineSep()).append(TAB);
        }
        sbCode.append("}");
    }

    private boolean addFormParameters(List<Element> inParamElements, Element requestEl) {
        String mediaType;
        List<Element> repElements = DOMUtils.getChildrenWithName(requestEl, "http://wadl.dev.java.net/2009/02", "representation");
        if (repElements.size() == 1 && "application/x-www-form-urlencoded".equals(mediaType = repElements.get(0).getAttribute("mediaType"))) {
            inParamElements.addAll(DOMUtils.getChildrenWithName(repElements.get(0), "http://wadl.dev.java.net/2009/02", "param"));
            return true;
        }
        return false;
    }

    private boolean writeResponseType(List<Element> responseEls, StringBuilder sbCode, Set<String> imports, Set<String> typeClassNames, GrammarInfo gInfo) {
        Element okResponse = this.getOKResponse(responseEls);
        List<Element> repElements = null;
        repElements = okResponse != null ? DOMUtils.getChildrenWithName(okResponse, "http://wadl.dev.java.net/2009/02", "representation") : CastUtils.cast(Collections.emptyList(), Element.class);
        if (repElements.size() == 0) {
            sbCode.append("void ");
            return false;
        }
        String elementName = this.getElementRefName(repElements, typeClassNames, gInfo, imports);
        if (elementName != null) {
            sbCode.append(elementName + " ");
        } else {
            this.addImport(imports, Response.class.getName());
            sbCode.append("Response ");
        }
        return true;
    }

    private Element getOKResponse(List<Element> responseEls) {
        for (int i = 0; i < responseEls.size(); ++i) {
            String statusValue = responseEls.get(i).getAttribute("status");
            if (statusValue.length() != 0 && !Arrays.asList(statusValue.split("\\s")).contains("200")) continue;
            return responseEls.get(i);
        }
        return null;
    }

    private void writeSubResponseType(boolean recursive, String ns, String localName, StringBuilder sbCode, Set<String> imports) {
        if (!recursive && ns.length() > 0) {
            this.addImport(imports, ns + "." + localName);
        }
        sbCode.append(localName).append(" ");
    }

    private void writeRequestTypes(Element requestEl, List<Element> inParamEls, StringBuilder sbCode, Set<String> imports, ContextInfo info) {
        boolean form = false;
        boolean formParamsAvailable = false;
        if (requestEl != null) {
            inParamEls.addAll(DOMUtils.getChildrenWithName(requestEl, "http://wadl.dev.java.net/2009/02", "param"));
            int currentSize = inParamEls.size();
            form = this.addFormParameters(inParamEls, requestEl);
            formParamsAvailable = currentSize < inParamEls.size();
        }
        for (int i = 0; i < inParamEls.size(); ++i) {
            Element paramEl = inParamEls.get(i);
            Class<Object> paramAnn = PARAM_ANNOTATIONS.get(paramEl.getAttribute("style"));
            if (paramAnn == QueryParam.class && form) {
                paramAnn = FormParam.class;
            }
            String name = paramEl.getAttribute("name");
            if (this.writeAnnotations(info.isInterfaceGenerated())) {
                this.writeAnnotation(sbCode, imports, paramAnn, name, false, false);
                sbCode.append(" ");
            }
            boolean isRepeating = Boolean.valueOf(paramEl.getAttribute("repeating"));
            String type = this.getPrimitiveType(paramEl);
            if (paramAnn == QueryParam.class && (isRepeating || !Boolean.valueOf(paramEl.getAttribute("required")).booleanValue()) && AUTOBOXED_PRIMITIVES_MAP.containsKey(type)) {
                type = AUTOBOXED_PRIMITIVES_MAP.get(type);
            }
            if (isRepeating) {
                this.addImport(imports, List.class.getName());
                type = "List<" + type + ">";
            }
            sbCode.append(type).append(" ").append(name.replaceAll("[\\.\\-]", "_"));
            if (i + 1 >= inParamEls.size()) continue;
            sbCode.append(", ");
            if (i + 1 < 4 || (i + 1) % 4 != 0) continue;
            sbCode.append(this.getLineSep()).append(TAB).append(TAB).append(TAB).append(TAB);
        }
        String elementParamType = null;
        String elementParamName = null;
        if (!form) {
            List<Element> repElements;
            List<Element> list = repElements = requestEl != null ? DOMUtils.getChildrenWithName(requestEl, "http://wadl.dev.java.net/2009/02", "representation") : CastUtils.cast(Collections.emptyList(), Element.class);
            if (repElements.size() > 0 && (elementParamType = this.getElementRefName(repElements, info.getTypeClassNames(), info.getGrammarInfo(), imports)) != null) {
                elementParamName = elementParamType.toLowerCase();
            }
        } else if (!formParamsAvailable) {
            this.addImport(imports, MultivaluedMap.class.getName());
            elementParamType = MultivaluedMap.class.getSimpleName();
            elementParamName = "map";
        }
        if (elementParamType != null) {
            if (inParamEls.size() > 0) {
                sbCode.append(", ");
            }
            sbCode.append(elementParamType).append(" ").append(elementParamName);
        }
    }

    private String getPrimitiveType(Element paramEl) {
        String type = paramEl.getAttribute("type");
        if (type == null) {
            return "String";
        }
        String[] pair = type.split(":");
        String value = pair.length == 2 ? pair[1] : type;
        return "string".equals(value) ? "String" : value;
    }

    private String getElementRefName(List<Element> repElements, Set<String> typeClassNames, GrammarInfo gInfo, Set<String> imports) {
        String elementRef = null;
        for (Element el : repElements) {
            String value = el.getAttribute("element");
            if (value.length() <= 0) continue;
            elementRef = value;
            break;
        }
        if (elementRef != null) {
            String[] pair = elementRef.split(":");
            if (pair.length == 2) {
                String namespace;
                String string = namespace = gInfo != null ? gInfo.getNsMap().get(pair[0]) : null;
                if (namespace == null) {
                    return null;
                }
                String packageName = this.getPackageFromNamespace(namespace);
                String clsName = this.getSchemaClassName(packageName, gInfo, pair[1], typeClassNames);
                if (clsName != null) {
                    this.addImport(imports, clsName);
                    int index = clsName.lastIndexOf(".");
                    if (index != -1) {
                        return clsName.substring(index + 1);
                    }
                    return clsName;
                }
            }
        } else {
            for (Element el : repElements) {
                Element param = DOMUtils.getFirstChildWithName(el, "http://wadl.dev.java.net/2009/02", "param");
                if (param == null) continue;
                return this.getPrimitiveType(param);
            }
        }
        return null;
    }

    private String getSchemaClassName(String packageName, GrammarInfo gInfo, String localName, Set<String> typeClassNames) {
        String clsName = this.matchClassName(typeClassNames, packageName, localName);
        if (clsName == null && gInfo != null) {
            clsName = this.matchClassName(typeClassNames, packageName, gInfo.getElementTypeMap().get(localName));
        }
        if (clsName == null && this.schemaTypesMap != null) {
            clsName = this.schemaTypesMap.get(packageName + "." + localName);
        }
        return clsName;
    }

    private String matchClassName(Set<String> typeClassNames, String packageName, String localName) {
        if (localName == null) {
            return null;
        }
        String clsName = packageName + "." + localName.toLowerCase();
        for (String type : typeClassNames) {
            if (!type.toLowerCase().equals(clsName)) continue;
            return type;
        }
        return null;
    }

    private void writeFormatAnnotations(Element parentEl, StringBuilder sbCode, Set<String> imports, boolean inRep) {
        List<Element> repElements;
        List<Element> list = repElements = parentEl != null ? DOMUtils.getChildrenWithName(parentEl, "http://wadl.dev.java.net/2009/02", "representation") : CastUtils.cast(Collections.emptyList(), Element.class);
        if (repElements.size() == 0) {
            return;
        }
        Class cls = inRep ? Consumes.class : Produces.class;
        this.addImport(imports, cls.getName());
        sbCode.append("@").append(cls.getSimpleName()).append("(");
        if (repElements.size() > 1) {
            sbCode.append("{");
        }
        for (int i = 0; i < repElements.size(); ++i) {
            String mediaType = repElements.get(i).getAttribute("mediaType");
            if (mediaType == null) continue;
            sbCode.append("\"" + mediaType + "\"");
            if (i + 1 >= repElements.size()) continue;
            sbCode.append(", ");
        }
        if (repElements.size() > 1) {
            sbCode.append(" }");
        }
        sbCode.append(")");
        sbCode.append(this.getLineSep()).append(TAB);
    }

    private void createJavaSourceFile(File src, QName qname, StringBuilder sbCode, StringBuilder sbImports) {
        String content = sbImports.toString() + this.getLineSep() + sbCode.toString();
        String namespace = qname.getNamespaceURI();
        this.generatedServiceClasses.add(namespace + "." + qname.getLocalPart());
        namespace = namespace.replace(".", this.getFileSep());
        File currentDir = new File(src.getAbsolutePath(), namespace);
        currentDir.mkdirs();
        File file = new File(currentDir.getAbsolutePath(), qname.getLocalPart() + ".java");
        try {
            file.createNewFile();
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(content.getBytes());
            fos.close();
        }
        catch (FileNotFoundException ex) {
            LOG.warning(file.getAbsolutePath() + " is not found");
        }
        catch (IOException ex) {
            LOG.warning("Problem writing into " + file.getAbsolutePath());
        }
    }

    private Application readWadl(String wadl, String docPath) {
        return new Application(this.readXmlDocument(new StringReader(wadl)), docPath);
    }

    private Element readXmlDocument(Reader reader) {
        try {
            return StaxUtils.read(new InputSource(reader)).getDocumentElement();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to read wadl", ex);
        }
    }

    private void generateClassesFromSchema(JAXBUtils.JCodeModel codeModel, File src) {
        try {
            Object writer = JAXBUtils.createFileCodeWriter(src);
            codeModel.build(writer);
            this.generatedTypeClasses = JAXBUtils.getGeneratedClassNames(codeModel);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to write generated Java files for schemas: " + e.getMessage(), e);
        }
    }

    private List<SchemaInfo> getSchemaElements(Application app) {
        List<Element> grammarEls = DOMUtils.getChildrenWithName(app.getAppElement(), "http://wadl.dev.java.net/2009/02", "grammars");
        if (grammarEls.size() != 1) {
            return null;
        }
        ArrayList<SchemaInfo> schemas = new ArrayList<SchemaInfo>();
        List<Element> schemasEls = DOMUtils.getChildrenWithName(grammarEls.get(0), "http://www.w3.org/2001/XMLSchema", "schema");
        for (int i = 0; i < schemasEls.size(); ++i) {
            String systemId = app.getWadlPath();
            if (schemasEls.size() > 1) {
                systemId = systemId + "#grammar" + (i + 1);
            }
            schemas.add(this.createSchemaInfo(schemasEls.get(i), systemId));
        }
        List<Element> includeEls = DOMUtils.getChildrenWithName(grammarEls.get(0), "http://wadl.dev.java.net/2009/02", "include");
        for (Element includeEl : includeEls) {
            String href = includeEl.getAttribute("href");
            String schemaURI = this.resolveLocationWithCatalog(href);
            if (schemaURI == null) {
                schemaURI = app.getWadlPath() != null ? SourceGenerator.getBaseWadlPath(app.getWadlPath()) + href : href;
            }
            schemas.add(this.createSchemaInfo(this.readIncludedDocument(schemaURI), schemaURI));
        }
        return schemas;
    }

    private static String getBaseWadlPath(String docPath) {
        int lastSep = docPath.lastIndexOf("/");
        return lastSep != -1 ? docPath.substring(0, lastSep + 1) : docPath;
    }

    private SchemaInfo createSchemaInfo(Element schemaEl, String systemId) {
        SchemaInfo info = new SchemaInfo(schemaEl.getAttribute("targetNamespace"));
        info.setElement(schemaEl);
        info.setSystemId(systemId);
        return info;
    }

    private String resolveLocationWithCatalog(String href) {
        if (this.bus != null) {
            OASISCatalogManager catalogResolver = OASISCatalogManager.getCatalogManager(this.bus);
            try {
                return new OASISCatalogManagerHelper().resolve(catalogResolver, href, null);
            }
            catch (Exception e) {
                throw new RuntimeException("Catalog resolution failed", e);
            }
        }
        return null;
    }

    private Element readIncludedDocument(String href) {
        try {
            InputStream is = null;
            if (!href.startsWith("http")) {
                is = ResourceUtils.getResourceStream(href, this.bus);
            }
            if (is == null) {
                is = URI.create(href).toURL().openStream();
            }
            return this.readXmlDocument(new InputStreamReader(is, "UTF-8"));
        }
        catch (Exception ex) {
            throw new RuntimeException("Resource " + href + " can not be read");
        }
    }

    private JAXBUtils.JCodeModel createCodeModel(List<SchemaInfo> schemaElements, Set<String> type) {
        JAXBUtils.SchemaCompiler compiler = this.createCompiler(type);
        if (this.compilerArgs.size() > 0) {
            compiler.getOptions().addGrammar(new InputSource("null"));
            compiler.getOptions().parseArguments(this.compilerArgs.toArray(new String[0]));
        }
        this.addSchemas(schemaElements, compiler);
        for (InputSource is : this.bindingFiles) {
            compiler.getOptions().addBindFile(is);
        }
        Object elForRun = ReflectionInvokationHandler.createProxyWrapper(new InnerErrorListener(), JAXBUtils.getParamClass(compiler, "setErrorListener"));
        compiler.setErrorListener(elForRun);
        JAXBUtils.S2JJAXBModel intermediateModel = compiler.bind();
        JAXBUtils.JCodeModel codeModel = intermediateModel.generateCode(null, elForRun);
        JAXBUtils.logGeneratedClassNames(LOG, codeModel);
        return codeModel;
    }

    private JAXBUtils.SchemaCompiler createCompiler(Set<String> typeClassNames) {
        return JAXBUtils.createSchemaCompilerWithDefaultAllocator(typeClassNames);
    }

    private void addSchemas(List<SchemaInfo> schemas, JAXBUtils.SchemaCompiler compiler) {
        int i;
        for (i = 0; i < this.schemaPackageFiles.size(); ++i) {
            compiler.parseSchema(this.schemaPackageFiles.get(i));
        }
        for (i = 0; i < schemas.size(); ++i) {
            SchemaInfo schema = schemas.get(i);
            String key = schema.getSystemId();
            if (key != null) {
                if (key.startsWith("classpath:")) {
                    String resource = key.substring(10);
                    URL url = this.getClass().getResource(resource);
                    if (url != null) {
                        try {
                            key = url.toURI().toString();
                        }
                        catch (Exception ex) {}
                    }
                }
            } else {
                key = Integer.toString(i);
            }
            InputSource is = new InputSource((InputStream)null);
            is.setSystemId(key);
            is.setPublicId(key);
            compiler.getOptions().addGrammar(is);
            compiler.parseSchema(key, schema.getElement());
        }
    }

    public void setImportsComparator(Comparator<String> importsComparator) {
        this.importsComparator = importsComparator;
    }

    private Set<String> createImports() {
        return this.importsComparator == null ? new TreeSet<String>(new DefaultImportsComparator()) : new TreeSet<String>(this.importsComparator);
    }

    public void setGenerateInterfaces(boolean generateInterfaces) {
        this.generateInterfaces = generateInterfaces;
    }

    public void setGenerateImplementation(boolean generate) {
        this.generateImpl = generate;
    }

    public void setPackageName(String name) {
        this.resourcePackageName = name;
    }

    public void setResourceName(String name) {
        this.resourceName = name;
    }

    public void setWadlPath(String name) {
        this.wadlPath = name;
    }

    public void setBindingFiles(List<InputSource> files) {
        this.bindingFiles = files;
    }

    public void setSchemaPackageFiles(List<InputSource> files) {
        this.schemaPackageFiles = files;
    }

    public void setCompilerArgs(List<String> args) {
        this.compilerArgs = args;
    }

    public void setSchemaPackageMap(Map<String, String> map) {
        this.schemaPackageMap = map;
    }

    public void setSchemaTypesMap(Map<String, String> map) {
        this.schemaTypesMap = map;
    }

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    public List<String> getGeneratedServiceClasses() {
        return this.generatedServiceClasses;
    }

    public List<String> getGeneratedTypeClasses() {
        return this.generatedTypeClasses;
    }

    static {
        HTTP_METHOD_ANNOTATIONS.put("get", GET.class);
        HTTP_METHOD_ANNOTATIONS.put("put", PUT.class);
        HTTP_METHOD_ANNOTATIONS.put("post", POST.class);
        HTTP_METHOD_ANNOTATIONS.put("delete", DELETE.class);
        HTTP_METHOD_ANNOTATIONS.put("head", HEAD.class);
        HTTP_METHOD_ANNOTATIONS.put("options", OPTIONS.class);
        PARAM_ANNOTATIONS = new HashMap();
        PARAM_ANNOTATIONS.put("template", PathParam.class);
        PARAM_ANNOTATIONS.put("header", HeaderParam.class);
        PARAM_ANNOTATIONS.put("query", QueryParam.class);
        PARAM_ANNOTATIONS.put("matrix", MatrixParam.class);
        RESOURCE_LEVEL_PARAMS = new HashSet<String>();
        RESOURCE_LEVEL_PARAMS.add("template");
        RESOURCE_LEVEL_PARAMS.add("matrix");
        AUTOBOXED_PRIMITIVES_MAP = new HashMap<String, String>();
        AUTOBOXED_PRIMITIVES_MAP.put(Byte.TYPE.getSimpleName(), Byte.class.getSimpleName());
        AUTOBOXED_PRIMITIVES_MAP.put(Short.TYPE.getSimpleName(), Short.class.getSimpleName());
        AUTOBOXED_PRIMITIVES_MAP.put(Integer.TYPE.getSimpleName(), Integer.class.getSimpleName());
        AUTOBOXED_PRIMITIVES_MAP.put(Long.TYPE.getSimpleName(), Long.class.getSimpleName());
        AUTOBOXED_PRIMITIVES_MAP.put(Float.TYPE.getSimpleName(), Float.class.getSimpleName());
        AUTOBOXED_PRIMITIVES_MAP.put(Double.TYPE.getSimpleName(), Double.class.getSimpleName());
        AUTOBOXED_PRIMITIVES_MAP.put(Boolean.TYPE.getSimpleName(), Boolean.class.getSimpleName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ContextInfo {
        private boolean interfaceIsGenerated;
        private Set<String> typeClassNames;
        private GrammarInfo gInfo;
        private Set<String> resourceClassNames = new HashSet<String>();

        public ContextInfo(Set<String> typeClassNames, GrammarInfo gInfo, boolean interfaceIsGenerated) {
            this.interfaceIsGenerated = interfaceIsGenerated;
            this.typeClassNames = typeClassNames;
            this.gInfo = gInfo;
        }

        public boolean isInterfaceGenerated() {
            return this.interfaceIsGenerated;
        }

        public Set<String> getTypeClassNames() {
            return this.typeClassNames;
        }

        public GrammarInfo getGrammarInfo() {
            return this.gInfo;
        }

        public Set<String> getResourceClassNames() {
            return this.resourceClassNames;
        }
    }

    private class Application {
        private Element appElement;
        private String wadlPath;

        public Application(Element appElement, String wadlPath) {
            this.appElement = appElement;
            this.wadlPath = wadlPath;
        }

        public Element getAppElement() {
            return this.appElement;
        }

        public String getWadlPath() {
            return this.wadlPath;
        }
    }

    static class InnerErrorListener {
        InnerErrorListener() {
        }

        public void error(SAXParseException ex) {
            throw new RuntimeException("Error compiling schema from WADL : " + ex.getMessage(), ex);
        }

        public void fatalError(SAXParseException ex) {
            throw new RuntimeException("Fatal error compiling schema from WADL : " + ex.getMessage(), ex);
        }

        public void info(SAXParseException ex) {
        }

        public void warning(SAXParseException ex) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultImportsComparator
    implements Comparator<String> {
        private static final String JAVAX_PREFIX = "javax";

        private DefaultImportsComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            boolean javax1 = s1.startsWith(JAVAX_PREFIX);
            boolean javax2 = s2.startsWith(JAVAX_PREFIX);
            if (javax1 && !javax2) {
                return -1;
            }
            if (!javax1 && javax2) {
                return 1;
            }
            return s1.compareTo(s2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GrammarInfo {
        private Map<String, String> nsMap = new HashMap<String, String>();
        private Map<String, String> elementTypeMap = new HashMap<String, String>();

        public GrammarInfo() {
        }

        public GrammarInfo(Map<String, String> nsMap, Map<String, String> elementTypeMap) {
            this.nsMap = nsMap;
            this.elementTypeMap = elementTypeMap;
        }

        public Map<String, String> getNsMap() {
            return this.nsMap;
        }

        public Map<String, String> getElementTypeMap() {
            return this.elementTypeMap;
        }
    }
}

