/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.corba.runtime;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.corba.CorbaBindingException;
import org.apache.cxf.binding.corba.types.CorbaAnyHandler;
import org.apache.cxf.binding.corba.types.CorbaArrayHandler;
import org.apache.cxf.binding.corba.types.CorbaEnumHandler;
import org.apache.cxf.binding.corba.types.CorbaExceptionHandler;
import org.apache.cxf.binding.corba.types.CorbaFixedHandler;
import org.apache.cxf.binding.corba.types.CorbaObjectHandler;
import org.apache.cxf.binding.corba.types.CorbaObjectReferenceHandler;
import org.apache.cxf.binding.corba.types.CorbaOctetSequenceHandler;
import org.apache.cxf.binding.corba.types.CorbaPrimitiveHandler;
import org.apache.cxf.binding.corba.types.CorbaSequenceHandler;
import org.apache.cxf.binding.corba.types.CorbaStructHandler;
import org.apache.cxf.binding.corba.types.CorbaUnionHandler;
import org.apache.cxf.binding.corba.wsdl.CaseType;
import org.apache.cxf.binding.corba.wsdl.Enum;
import org.apache.cxf.binding.corba.wsdl.Enumerator;
import org.apache.cxf.binding.corba.wsdl.Union;
import org.apache.cxf.binding.corba.wsdl.Unionbranch;
import org.apache.cxf.common.logging.LogUtils;
import org.omg.CORBA.Any;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Object;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.InputStream;

public class CorbaObjectReader {
    private static final Logger LOG = LogUtils.getL7dLogger(CorbaObjectReader.class);
    private InputStream stream;

    public CorbaObjectReader(InputStream inStream) {
        this.stream = inStream;
    }

    public void read(CorbaObjectHandler obj) throws CorbaBindingException {
        switch (obj.getTypeCode().kind().value()) {
            case 8: {
                ((CorbaPrimitiveHandler)obj).setValue(this.readBoolean());
                break;
            }
            case 9: {
                Character charValue = this.readChar();
                ((CorbaPrimitiveHandler)obj).setValue(charValue);
                break;
            }
            case 26: {
                ((CorbaPrimitiveHandler)obj).setValue(this.readWChar());
                break;
            }
            case 10: {
                Byte octetValue = this.readOctet();
                ((CorbaPrimitiveHandler)obj).setValue(octetValue);
                break;
            }
            case 2: {
                ((CorbaPrimitiveHandler)obj).setValue(this.readShort());
                break;
            }
            case 4: {
                ((CorbaPrimitiveHandler)obj).setValue(this.readUShort());
                break;
            }
            case 3: {
                ((CorbaPrimitiveHandler)obj).setValue(this.readLong());
                break;
            }
            case 5: {
                ((CorbaPrimitiveHandler)obj).setValue(this.readULong());
                break;
            }
            case 23: {
                ((CorbaPrimitiveHandler)obj).setValue(this.readLongLong());
                break;
            }
            case 24: {
                ((CorbaPrimitiveHandler)obj).setValue(this.readULongLong());
                break;
            }
            case 6: {
                ((CorbaPrimitiveHandler)obj).setValue(this.readFloat());
                break;
            }
            case 7: {
                ((CorbaPrimitiveHandler)obj).setValue(this.readDouble());
                break;
            }
            case 18: {
                ((CorbaPrimitiveHandler)obj).setValue(this.readString());
                break;
            }
            case 27: {
                ((CorbaPrimitiveHandler)obj).setValue(this.readWString());
                break;
            }
            case 11: {
                ((CorbaAnyHandler)obj).setValue(this.readAny());
                break;
            }
            case 20: {
                this.readArray(obj);
                break;
            }
            case 19: {
                this.readSequence(obj);
                break;
            }
            case 15: {
                this.readStruct(obj);
                break;
            }
            case 17: {
                this.readEnum(obj);
                break;
            }
            case 22: {
                this.readException(obj);
                break;
            }
            case 28: {
                this.readFixed(obj);
                break;
            }
            case 16: {
                this.readUnion(obj);
                break;
            }
            case 14: {
                this.readObjectReference(obj);
                break;
            }
        }
    }

    public Boolean readBoolean() throws CorbaBindingException {
        try {
            return this.stream.read_boolean();
        }
        catch (MARSHAL ex) {
            LOG.log(Level.SEVERE, "CorbaObjectReader: could not read boolean");
            throw new CorbaBindingException("CorbaObjectReader: readBoolean MARSHAL exception", ex);
        }
    }

    public Character readChar() throws CorbaBindingException {
        try {
            return new Character(this.stream.read_char());
        }
        catch (MARSHAL ex) {
            LOG.log(Level.SEVERE, "CorbaObjectReader: could not read character");
            throw new CorbaBindingException("CorbaObjectReader: readChar MARSHAL exception", ex);
        }
    }

    public Character readWChar() throws CorbaBindingException {
        try {
            return new Character(this.stream.read_wchar());
        }
        catch (MARSHAL ex) {
            LOG.log(Level.SEVERE, "CorbaObjectReader: could not read wide character");
            throw new CorbaBindingException("CorbaObjectReader: readWChar MARSHAL exception", ex);
        }
    }

    public Byte readOctet() throws CorbaBindingException {
        try {
            return new Byte(this.stream.read_octet());
        }
        catch (MARSHAL ex) {
            LOG.log(Level.SEVERE, "CorbaObjectReader: could not read octet");
            throw new CorbaBindingException("CorbaObjectReader: readOctet MARSHAL exception", ex);
        }
    }

    public Short readShort() throws CorbaBindingException {
        try {
            return new Short(this.stream.read_short());
        }
        catch (MARSHAL ex) {
            LOG.log(Level.SEVERE, "CorbaObjectReader: could not read short");
            throw new CorbaBindingException("CorbaObjectReader: readShort MARSHAL exception", ex);
        }
    }

    public Integer readUShort() throws CorbaBindingException {
        try {
            int result = this.stream.read_ushort();
            if (result < 0) {
                result = result - Short.MIN_VALUE - Short.MIN_VALUE;
            }
            return result;
        }
        catch (MARSHAL ex) {
            LOG.log(Level.SEVERE, "CorbaObjectReader: could not read unsigned short");
            throw new CorbaBindingException("CorbaObjectReader: readUShort MARSHAL exception", ex);
        }
    }

    public Integer readLong() throws CorbaBindingException {
        Integer result = new Integer(this.stream.read_long());
        try {
            return result;
        }
        catch (MARSHAL ex) {
            LOG.log(Level.SEVERE, "CorbaObjectReader: could not read long");
            throw new CorbaBindingException("CorbaObjectReader: readLong MARSHAL exception", ex);
        }
    }

    public long readULong() throws CorbaBindingException {
        try {
            long l = this.stream.read_ulong();
            return l &= 0xFFFFFFFFL;
        }
        catch (MARSHAL ex) {
            LOG.log(Level.SEVERE, "CorbaObjectReader: could not read unsigned long");
            throw new CorbaBindingException("CorbaObjectReader: readULong MARSHAL exception", ex);
        }
    }

    public Long readLongLong() throws CorbaBindingException {
        try {
            return new Long(this.stream.read_longlong());
        }
        catch (MARSHAL ex) {
            LOG.log(Level.SEVERE, "CorbaObjectReader: could not read long long");
            throw new CorbaBindingException("CorbaObjectReader: readLongLong MARSHAL exception", ex);
        }
    }

    private BigInteger convertLongToULong(long l) {
        if (l < 0L) {
            long l2 = l & 0x7FFFFFFFFFFFFFL;
            BigInteger i = BigInteger.valueOf(l2);
            BigInteger i2 = BigInteger.valueOf(0L);
            i2.setBit(63);
            i = i.or(i2);
            return i;
        }
        return BigInteger.valueOf(l);
    }

    public BigInteger readULongLong() throws CorbaBindingException {
        try {
            return this.convertLongToULong(this.stream.read_ulonglong());
        }
        catch (MARSHAL ex) {
            LOG.log(Level.SEVERE, "CorbaObjectReader: could not read unsigned long long");
            throw new CorbaBindingException("CorbaObjectReader: readULongLong MARSHAL exception", ex);
        }
    }

    public Float readFloat() throws CorbaBindingException {
        try {
            return new Float(this.stream.read_float());
        }
        catch (MARSHAL ex) {
            LOG.log(Level.SEVERE, "CorbaObjectReader: could not read float");
            throw new CorbaBindingException("CorbaObjectReader: readFloat MARSHAL exception", ex);
        }
    }

    public Double readDouble() throws CorbaBindingException {
        try {
            return new Double(this.stream.read_double());
        }
        catch (MARSHAL ex) {
            LOG.log(Level.SEVERE, "CorbaObjectReader: could not read double");
            throw new CorbaBindingException("CorbaObjectReader: readDouble MARSHAL exception", ex);
        }
    }

    public String readString() throws CorbaBindingException {
        try {
            return this.stream.read_string();
        }
        catch (MARSHAL ex) {
            LOG.log(Level.SEVERE, "CorbaObjectReader: could not read string");
            throw new CorbaBindingException("CorbaObjectReader: readString MARSHAL exception", ex);
        }
    }

    public String readWString() throws CorbaBindingException {
        try {
            return this.stream.read_wstring();
        }
        catch (MARSHAL ex) {
            LOG.log(Level.SEVERE, "CorbaObjectReader: could not read wide string");
            throw new CorbaBindingException("CorbaObjectReader: readWString MARSHAL exception", ex);
        }
    }

    public Any readAny() throws CorbaBindingException {
        try {
            return this.stream.read_any();
        }
        catch (MARSHAL ex) {
            LOG.log(Level.SEVERE, "CorbaObjectReader: could not read any");
            throw new CorbaBindingException("CorbaObjectReader: readAny MARSHAL exception", ex);
        }
    }

    public void readEnum(CorbaObjectHandler obj) throws CorbaBindingException {
        int enumIndex = this.stream.read_long();
        Enum enumType = (Enum)obj.getType();
        List<Enumerator> enumerators = enumType.getEnumerator();
        CorbaEnumHandler enumObj = (CorbaEnumHandler)obj;
        enumObj.setValue(enumerators.get(enumIndex).getValue());
    }

    public void readStruct(CorbaObjectHandler obj) throws CorbaBindingException {
        CorbaStructHandler structObj = (CorbaStructHandler)obj;
        List<CorbaObjectHandler> structMembers = structObj.getMembers();
        for (int i = 0; i < structMembers.size(); ++i) {
            this.read(structMembers.get(i));
        }
    }

    public void readException(CorbaObjectHandler obj) throws CorbaBindingException {
        CorbaExceptionHandler exceptObj = (CorbaExceptionHandler)obj;
        List<CorbaObjectHandler> exceptElements = exceptObj.getMembers();
        String exceptId = this.stream.read_string();
        exceptObj.setId(exceptId);
        for (int i = 0; i < exceptElements.size(); ++i) {
            this.read(exceptElements.get(i));
        }
    }

    public void readFixed(CorbaObjectHandler obj) throws CorbaBindingException {
        CorbaFixedHandler fixedHandler = (CorbaFixedHandler)obj;
        long scale = fixedHandler.getScale();
        try {
            BigDecimal fixedValue = this.stream.read_fixed().movePointLeft((int)scale);
            fixedHandler.setValue(fixedValue);
        }
        catch (NO_IMPLEMENT ex) {
            Method m = null;
            try {
                m = this.stream.getClass().getMethod("read_fixed", TypeCode.class);
                BigDecimal fixedValue = (BigDecimal)m.invoke((java.lang.Object)this.stream, obj.getTypeCode());
                fixedHandler.setValue(fixedValue);
            }
            catch (Throwable e1) {
                throw ex;
            }
        }
    }

    public void readEnumDiscriminator(CorbaUnionHandler unionHandler, CorbaEnumHandler disc) throws CorbaBindingException {
        int enumIndex = this.stream.read_long();
        Enum enumType = (Enum)disc.getType();
        List<Enumerator> enumerators = enumType.getEnumerator();
        if (enumIndex == Integer.MAX_VALUE) {
            enumIndex = unionHandler.getDefaultIndex();
        }
        disc.setValue(enumerators.get(enumIndex).getValue());
    }

    public void readUnion(CorbaObjectHandler obj) throws CorbaBindingException {
        CorbaUnionHandler unionHandler = (CorbaUnionHandler)obj;
        Union unionType = (Union)unionHandler.getType();
        List<Unionbranch> branches = unionType.getUnionbranch();
        CorbaObjectHandler discriminator = unionHandler.getDiscriminator();
        if (branches.size() > 0) {
            String discLabel = null;
            if (discriminator.getTypeCodeKind().value() == 17) {
                CorbaEnumHandler disc = (CorbaEnumHandler)discriminator;
                this.readEnumDiscriminator(unionHandler, disc);
                discLabel = disc.getValue();
            } else {
                this.read(discriminator);
                discLabel = ((CorbaPrimitiveHandler)discriminator).getDataFromValue();
            }
            Unionbranch defaultBranch = null;
            boolean caseFound = false;
            for (Unionbranch branch : branches) {
                if (branch.isSetDefault() && branch.isDefault()) {
                    defaultBranch = branch;
                }
                List<CaseType> cases = branch.getCase();
                for (CaseType c : cases) {
                    if (!c.getLabel().equalsIgnoreCase(discLabel)) continue;
                    CorbaObjectHandler branchObj = unionHandler.getBranchByName(branch.getName());
                    this.read(branchObj);
                    unionHandler.setValue(branch.getName(), branchObj);
                    caseFound = true;
                    break;
                }
                if (!caseFound) continue;
                break;
            }
            if (!caseFound && defaultBranch != null) {
                CorbaObjectHandler branchObj = unionHandler.getBranchByName(defaultBranch.getName());
                this.read(branchObj);
                unionHandler.setValue(defaultBranch.getName(), branchObj);
            }
        }
    }

    public void readArray(CorbaObjectHandler obj) throws CorbaBindingException {
        CorbaArrayHandler arrayObj = (CorbaArrayHandler)obj;
        List<CorbaObjectHandler> arrayElements = arrayObj.getElements();
        java.lang.Object[] val = null;
        int arraySize = arrayElements.size();
        if (arraySize > 0) {
            switch (arrayElements.get(0).getTypeCodeKind().value()) {
                case 8: {
                    boolean[] values = new boolean[arraySize];
                    this.stream.read_boolean_array(values, 0, arraySize);
                    val = values;
                    break;
                }
                case 9: {
                    char[] values = new char[arraySize];
                    this.stream.read_char_array(values, 0, arraySize);
                    val = values;
                    break;
                }
                case 26: {
                    char[] values = new char[arraySize];
                    this.stream.read_wchar_array(values, 0, arraySize);
                    val = values;
                    break;
                }
                case 10: {
                    byte[] values = new byte[arraySize];
                    this.stream.read_octet_array(values, 0, arraySize);
                    val = values;
                    break;
                }
                case 2: {
                    short[] values = new short[arraySize];
                    this.stream.read_short_array(values, 0, arraySize);
                    val = values;
                    break;
                }
                case 4: {
                    short[] values = new short[arraySize];
                    this.stream.read_ushort_array(values, 0, arraySize);
                    val = values;
                    break;
                }
                case 3: {
                    int[] values = new int[arraySize];
                    this.stream.read_long_array(values, 0, arraySize);
                    val = values;
                    break;
                }
                case 5: {
                    int[] values = new int[arraySize];
                    this.stream.read_ulong_array(values, 0, arraySize);
                    java.lang.Object[] v2 = new long[arraySize];
                    int x = 0;
                    while (x < arraySize) {
                        v2[x] = values[x];
                        int n = x++;
                        v2[n] = v2[n] & 0xFFFFFFFFL;
                    }
                    val = v2;
                    break;
                }
                case 23: {
                    long[] values = new long[arraySize];
                    this.stream.read_longlong_array(values, 0, arraySize);
                    val = values;
                    break;
                }
                case 24: {
                    int x;
                    long[] values = new long[arraySize];
                    this.stream.read_ulonglong_array(values, 0, arraySize);
                    java.lang.Object[] v2 = new BigInteger[arraySize];
                    for (x = 0; x < arraySize; ++x) {
                        v2[x] = (long)this.convertLongToULong(values[x]);
                    }
                    val = v2;
                    break;
                }
                case 6: {
                    float[] values = new float[arraySize];
                    this.stream.read_float_array(values, 0, arraySize);
                    val = values;
                    break;
                }
                case 7: {
                    double[] values = new double[arraySize];
                    this.stream.read_double_array(values, 0, arraySize);
                    val = values;
                    break;
                }
                default: {
                    for (int i = 0; i < arrayElements.size(); ++i) {
                        this.read(arrayElements.get(i));
                    }
                }
            }
            if (val != null) {
                int sz = Array.getLength(val);
                for (int i = 0; i < sz; ++i) {
                    ((CorbaPrimitiveHandler)arrayElements.get(i)).setValue(Array.get(val, i));
                }
            }
        }
    }

    public void readSequence(CorbaObjectHandler obj) throws CorbaBindingException {
        if (obj instanceof CorbaOctetSequenceHandler) {
            int length = this.stream.read_ulong();
            byte[] value = new byte[length];
            this.stream.read_octet_array(value, 0, length);
            ((CorbaOctetSequenceHandler)obj).setValue(value);
        } else {
            CorbaSequenceHandler sequenceObj = (CorbaSequenceHandler)obj;
            List<CorbaObjectHandler> seqElements = sequenceObj.getElements();
            int length = this.stream.read_ulong();
            ArrayList<CorbaObjectHandler> elements = new ArrayList<CorbaObjectHandler>(length);
            if (sequenceObj.getTemplateElement() != null) {
                sequenceObj.clear();
                CorbaObjectHandler template = sequenceObj.getTemplateElement();
                for (int i = 0; i < length; ++i) {
                    CorbaObjectHandler seqElement = i < seqElements.size() ? seqElements.get(i) : this.initializeCorbaObjectHandler(template);
                    this.read(seqElement);
                    elements.add(seqElement);
                }
                sequenceObj.setElements(elements);
            } else {
                for (int i = 0; i < length; ++i) {
                    this.read(seqElements.get(i));
                }
                sequenceObj.setElements(seqElements.subList(0, length));
            }
        }
    }

    public void readObjectReference(CorbaObjectHandler obj) throws CorbaBindingException {
        CorbaObjectReferenceHandler objRefObj = (CorbaObjectReferenceHandler)obj;
        Object objRef = this.stream.read_Object();
        objRefObj.setReference(objRef);
    }

    private CorbaObjectHandler initializeCorbaObjectHandler(CorbaObjectHandler template) {
        CorbaObjectHandler handler;
        block7: {
            block9: {
                block8: {
                    block6: {
                        Constructor<?> templateConstructor = template.getClass().getDeclaredConstructors()[0];
                        java.lang.Object[] params = new java.lang.Object[]{template.isRecursive() ? new QName("item") : template.getName(), template.getIdlType(), template.getTypeCode(), template.getType()};
                        handler = null;
                        try {
                            handler = (CorbaObjectHandler)templateConstructor.newInstance(params);
                            if (template instanceof CorbaAnyHandler) {
                                ((CorbaAnyHandler)handler).setTypeMap(((CorbaAnyHandler)template).getTypeMap());
                            }
                        }
                        catch (Exception ex) {
                            throw new CorbaBindingException("Unable to instantiate sequence element", ex);
                        }
                        if (!(template instanceof CorbaSequenceHandler)) break block6;
                        CorbaSequenceHandler templateSeq = (CorbaSequenceHandler)template;
                        ((CorbaSequenceHandler)handler).setTemplateElement(templateSeq.getTemplateElement());
                        break block7;
                    }
                    if (!(template instanceof CorbaStructHandler)) break block8;
                    CorbaStructHandler templateStruct = (CorbaStructHandler)template;
                    CorbaStructHandler struct = (CorbaStructHandler)handler;
                    struct.setRecursive(template.isRecursive());
                    List<CorbaObjectHandler> members = templateStruct.getMembers();
                    for (int i = 0; i < members.size(); ++i) {
                        CorbaObjectHandler member = this.initializeCorbaObjectHandler(members.get(i));
                        struct.addMember(member);
                    }
                    break block7;
                }
                if (!(template instanceof CorbaArrayHandler)) break block9;
                CorbaArrayHandler templateArray = (CorbaArrayHandler)template;
                CorbaArrayHandler array = (CorbaArrayHandler)handler;
                List<CorbaObjectHandler> elements = templateArray.getElements();
                for (int i = 0; i < elements.size(); ++i) {
                    CorbaObjectHandler element = this.initializeCorbaObjectHandler(elements.get(i));
                    array.addElement(element);
                }
                break block7;
            }
            if (!(template instanceof CorbaUnionHandler)) break block7;
            CorbaUnionHandler templateUnion = (CorbaUnionHandler)template;
            CorbaUnionHandler union = (CorbaUnionHandler)handler;
            union.setRecursive(template.isRecursive());
            union.setDiscriminator(this.initializeCorbaObjectHandler(templateUnion.getDiscriminator()));
            List<CorbaObjectHandler> cases = templateUnion.getCases();
            for (int i = 0; i < cases.size(); ++i) {
                union.addCase(this.initializeCorbaObjectHandler(cases.get(i)));
            }
        }
        return handler;
    }
}

