/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyvalidators;

import java.security.cert.Certificate;
import java.util.Collection;
import java.util.List;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.security.transport.TLSSessionInfo;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.security.policy.model.IssuedToken;
import org.apache.cxf.ws.security.wss4j.policyvalidators.AbstractSamlPolicyValidator;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.message.token.BinarySecurity;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.opensaml.common.SAMLVersion;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IssuedTokenPolicyValidator
extends AbstractSamlPolicyValidator {
    private List<WSSecurityEngineResult> signedResults;
    private Message message;

    public IssuedTokenPolicyValidator(List<WSSecurityEngineResult> signedResults, Message message) {
        this.signedResults = signedResults;
        this.message = message;
    }

    public boolean validatePolicy(Collection<AssertionInfo> issuedAis, AssertionWrapper assertionWrapper) {
        if (issuedAis != null) {
            for (AssertionInfo ai : issuedAis) {
                IssuedToken issuedToken = (IssuedToken)ai.getAssertion();
                ai.setAsserted(true);
                boolean tokenRequired = this.isTokenRequired(issuedToken, this.message);
                if (tokenRequired && assertionWrapper == null) {
                    ai.setNotAsserted("The received token does not match the token inclusion requirement");
                    return false;
                }
                if (!tokenRequired) continue;
                Element template = issuedToken.getRstTemplate();
                if (template != null && !this.checkIssuedTokenTemplate(template, assertionWrapper)) {
                    ai.setNotAsserted("Error in validating the IssuedToken policy");
                    return false;
                }
                TLSSessionInfo tlsInfo = this.message.get(TLSSessionInfo.class);
                Certificate[] tlsCerts = null;
                if (tlsInfo != null) {
                    tlsCerts = tlsInfo.getPeerCertificates();
                }
                if (this.checkHolderOfKey(assertionWrapper, this.signedResults, tlsCerts)) continue;
                ai.setNotAsserted("Assertion fails holder-of-key requirements");
                return false;
            }
        }
        return true;
    }

    public boolean validatePolicy(Collection<AssertionInfo> issuedAis, BinarySecurity binarySecurityToken) {
        if (issuedAis != null) {
            for (AssertionInfo ai : issuedAis) {
                Element template;
                IssuedToken issuedToken = (IssuedToken)ai.getAssertion();
                ai.setAsserted(true);
                boolean tokenRequired = this.isTokenRequired(issuedToken, this.message);
                if (tokenRequired && binarySecurityToken == null) {
                    ai.setNotAsserted("The received token does not match the token inclusion requirement");
                    return false;
                }
                if (!tokenRequired || (template = issuedToken.getRstTemplate()) == null || this.checkIssuedTokenTemplate(template, binarySecurityToken)) continue;
                ai.setNotAsserted("Error in validating the IssuedToken policy");
                return false;
            }
        }
        return true;
    }

    private boolean checkIssuedTokenTemplate(Element template, AssertionWrapper assertionWrapper) {
        Element child = DOMUtils.getFirstElement(template);
        while (child != null) {
            SAMLKeyInfo subjectKeyInfo;
            String content;
            if ("TokenType".equals(child.getLocalName())) {
                content = child.getTextContent();
                if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1".equals(content) && assertionWrapper.getSamlVersion() != SAMLVersion.VERSION_11) {
                    return false;
                }
                if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0".equals(content) && assertionWrapper.getSamlVersion() != SAMLVersion.VERSION_20) {
                    return false;
                }
            } else if ("KeyType".equals(child.getLocalName()) && ((content = child.getTextContent()).endsWith("SymmetricKey") ? (subjectKeyInfo = assertionWrapper.getSubjectKeyInfo()) == null || subjectKeyInfo.getSecret() == null : content.endsWith("PublicKey") && ((subjectKeyInfo = assertionWrapper.getSubjectKeyInfo()) == null || subjectKeyInfo.getPublicKey() == null && subjectKeyInfo.getCerts() == null))) {
                return false;
            }
            child = DOMUtils.getNextElement(child);
        }
        return true;
    }

    private boolean checkIssuedTokenTemplate(Element template, BinarySecurity binarySecurityToken) {
        Element child = DOMUtils.getFirstElement(template);
        while (child != null) {
            String valueType;
            String content;
            if ("TokenType".equals(child.getLocalName()) && !(content = child.getTextContent()).equals(valueType = binarySecurityToken.getValueType())) {
                return false;
            }
            child = DOMUtils.getNextElement(child);
        }
        return true;
    }
}

