/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.interceptors;

import java.util.Collection;
import java.util.Map;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.interceptors.NegotiationUtils;
import org.apache.cxf.ws.security.policy.interceptors.SecureConversationTokenInterceptorProvider;
import org.apache.cxf.ws.security.policy.model.SecureConversationToken;
import org.apache.cxf.ws.security.policy.model.Trust10;
import org.apache.cxf.ws.security.policy.model.Trust13;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.trust.STSClient;
import org.apache.cxf.ws.security.trust.STSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SecureConversationOutInterceptor
extends AbstractPhaseInterceptor<SoapMessage> {
    public SecureConversationOutInterceptor() {
        super("prepare-send");
    }

    @Override
    public void handleMessage(SoapMessage message) throws Fault {
        AssertionInfoMap aim = message.get(AssertionInfoMap.class);
        if (aim != null) {
            Collection ais = (Collection)aim.get(SP12Constants.SECURE_CONVERSATION_TOKEN);
            if (ais == null || ais.isEmpty()) {
                return;
            }
            if (this.isRequestor(message)) {
                String tokId;
                SecureConversationToken itok = (SecureConversationToken)((AssertionInfo)ais.iterator().next()).getAssertion();
                SecurityToken tok = (SecurityToken)message.getContextualProperty("ws-security.token");
                if (tok == null && (tokId = (String)message.getContextualProperty("ws-security.token.id")) != null) {
                    tok = NegotiationUtils.getTokenStore(message).getToken(tokId);
                }
                if (tok == null) {
                    tok = this.issueToken(message, aim, itok);
                } else {
                    this.renewToken(message, aim, tok, itok);
                }
                if (tok != null) {
                    for (AssertionInfo ai : ais) {
                        ai.setAsserted(true);
                    }
                    message.getExchange().get(Endpoint.class).put("ws-security.token.id", tok.getId());
                    message.getExchange().put("ws-security.token.id", tok.getId());
                    NegotiationUtils.getTokenStore(message).add(tok);
                }
            } else {
                for (AssertionInfo ai : ais) {
                    ai.setAsserted(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renewToken(SoapMessage message, AssertionInfoMap aim, SecurityToken tok, SecureConversationToken itok) {
        if (tok.getState() != SecurityToken.State.EXPIRED) {
            return;
        }
        message.getExchange().get(Endpoint.class).remove("ws-security.token");
        message.getExchange().get(Endpoint.class).remove("ws-security.token.id");
        message.getExchange().remove("ws-security.token.id");
        message.getExchange().remove("ws-security.token");
        NegotiationUtils.getTokenStore(message).remove(tok);
        STSClient client = STSUtils.getClient(message, "sct");
        AddressingProperties maps = (AddressingProperties)message.get("javax.xml.ws.addressing.context.outbound");
        if (maps == null) {
            maps = (AddressingProperties)message.get("javax.xml.ws.addressing.context");
        } else if (maps.getAction().getValue().endsWith("Renew")) {
            return;
        }
        STSClient sTSClient = client;
        synchronized (sTSClient) {
            try {
                SecureConversationTokenInterceptorProvider.setupClient(client, message, aim, itok, true);
                String s = message.getContextualProperty(Message.ENDPOINT_ADDRESS).toString();
                client.setLocation(s);
                Map<String, Object> ctx = client.getRequestContext();
                ctx.put("ws-security.token", tok);
                if (maps != null) {
                    client.setAddressingNamespace(maps.getNamespaceURI());
                }
                client.renewSecurityToken(tok);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new Fault(e);
            }
            finally {
                client.setTrust((Trust10)null);
                client.setTrust((Trust13)null);
                client.setTemplate(null);
                client.setLocation(null);
                client.setAddressingNamespace(null);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SecurityToken issueToken(SoapMessage message, AssertionInfoMap aim, SecureConversationToken itok) {
        STSClient client = STSUtils.getClient(message, "sct");
        AddressingProperties maps = (AddressingProperties)message.get("javax.xml.ws.addressing.context.outbound");
        if (maps == null) {
            maps = (AddressingProperties)message.get("javax.xml.ws.addressing.context");
        }
        STSClient sTSClient = client;
        synchronized (sTSClient) {
            try {
                String s = SecureConversationTokenInterceptorProvider.setupClient(client, message, aim, itok, false);
                SecurityToken tok = null;
                if (maps != null) {
                    client.setAddressingNamespace(maps.getNamespaceURI());
                }
                tok = client.requestSecurityToken(s);
                String tokenType = tok.getTokenType();
                tok.setTokenType(tokenType);
                if (tokenType == null || "".equals(tokenType)) {
                    tok.setTokenType("http://schemas.xmlsoap.org/ws/2005/02/sc/sct");
                }
                SecurityToken securityToken = tok;
                return securityToken;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new Fault(e);
            }
            finally {
                client.setTrust((Trust10)null);
                client.setTrust((Trust13)null);
                client.setTemplate(null);
                client.setLocation(null);
                client.setAddressingNamespace(null);
            }
        }
    }
}

