/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.cache;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.apache.cxf.ws.security.cache.EHCacheManagerHolder;
import org.apache.ws.security.cache.ReplayCache;

public class EHCacheReplayCache
implements ReplayCache,
Closeable {
    public static final long DEFAULT_TTL = 3600L;
    public static final long MAX_TTL = 43200L;
    private Ehcache cache;
    private CacheManager cacheManager;
    private long ttl = 3600L;

    public EHCacheReplayCache(String key, URL configFileURL) {
        this.cacheManager = EHCacheManagerHolder.getCacheManager(configFileURL);
        Cache newCache = new Cache(key, 50000, true, false, 3600L, 3600L);
        this.cache = this.cacheManager.addCacheIfAbsent((Ehcache)newCache);
    }

    public void setTTL(long newTtl) {
        this.ttl = newTtl;
    }

    public long getTTL() {
        return this.ttl;
    }

    public void add(String identifier) {
        this.add(identifier, this.ttl);
    }

    public void add(String identifier, long timeToLive) {
        if (identifier == null || "".equals(identifier)) {
            return;
        }
        int parsedTTL = (int)timeToLive;
        if ((timeToLive != (long)parsedTTL || parsedTTL < 0 || (long)parsedTTL > 43200L) && this.ttl != (long)(parsedTTL = (int)this.ttl)) {
            parsedTTL = 3600;
        }
        this.cache.put(new Element((Object)identifier, (Object)identifier, Boolean.valueOf(false), Integer.valueOf(parsedTTL), Integer.valueOf(parsedTTL)));
    }

    public boolean contains(String identifier) {
        Element element = this.cache.get((Serializable)((Object)identifier));
        if (element != null) {
            if (this.cache.isExpired(element)) {
                this.cache.remove((Serializable)((Object)identifier));
                return false;
            }
            return true;
        }
        return false;
    }

    public void close() throws IOException {
        if (this.cacheManager != null) {
            EHCacheManagerHolder.releaseCacheManger(this.cacheManager);
            this.cacheManager = null;
            this.cache = null;
        }
    }
}

