/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.attachment;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import org.apache.cxf.attachment.AttachmentUtil;
import org.apache.cxf.attachment.DelegatingInputStream;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;

public class AttachmentDataSource
implements DataSource {
    private final String ct;
    private CachedOutputStream cache;
    private InputStream ins;
    private DelegatingInputStream delegate;

    public AttachmentDataSource(String ctParam, InputStream inParam) throws IOException {
        this.ct = ctParam;
        this.ins = inParam;
    }

    public boolean isCached() {
        return this.cache != null;
    }

    public void cache(Message message) throws IOException {
        if (this.cache == null) {
            this.cache = new CachedOutputStream();
            AttachmentUtil.setStreamedAttachmentProperties(message, this.cache);
            IOUtils.copy(this.ins, this.cache);
            this.cache.lockOutputStream();
            this.ins.close();
            this.ins = null;
            if (this.delegate != null) {
                this.delegate.setInputStream(this.cache.getInputStream());
            }
        }
    }

    public void hold(Message message) throws IOException {
        this.cache(message);
        this.cache.holdTempFile();
    }

    public void release() {
        this.cache.releaseTempFileHold();
    }

    public String getContentType() {
        return this.ct;
    }

    public InputStream getInputStream() {
        try {
            if (this.cache != null) {
                return this.cache.getInputStream();
            }
            if (this.delegate == null) {
                this.delegate = new DelegatingInputStream(this.ins);
            }
            return this.delegate;
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getName() {
        return null;
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnsupportedOperationException();
    }
}

