/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import org.apache.cxf.common.jaxb.NamespaceMapper;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.ext.Nullable;
import org.apache.cxf.jaxrs.ext.xml.XMLInstruction;
import org.apache.cxf.jaxrs.ext.xml.XMLSource;
import org.apache.cxf.jaxrs.ext.xml.XSISchemaLocation;
import org.apache.cxf.jaxrs.provider.AbstractJAXBProvider;
import org.apache.cxf.jaxrs.provider.JAXBAttachmentMarshaller;
import org.apache.cxf.jaxrs.provider.JAXBAttachmentUnmarshaller;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXBUtils;
import org.apache.cxf.jaxrs.utils.schemas.SchemaHandler;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Message;
import org.apache.cxf.staxutils.DepthExceededStaxException;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.transform.TransformUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Produces(value={"application/xml", "application/*+xml", "text/xml"})
@Consumes(value={"application/xml", "application/*+xml", "text/xml"})
@Provider
public class JAXBElementProvider<T>
extends AbstractJAXBProvider<T> {
    private static final String XML_PI_START = "<?xml version=\"1.0\" encoding=\"";
    private static final String NS_MAPPER_PROPERTY = "com.sun.xml.bind.namespacePrefixMapper";
    private static final String NS_MAPPER_PROPERTY_INT = "com.sun.xml.internal.bind.namespacePrefixMapper";
    private static final String XML_PI_PROPERTY = "com.sun.xml.bind.xmlHeaders";
    private static final String XML_PI_PROPERTY_INT = "com.sun.xml.internal.bind.xmlHeaders";
    private static final List<String> MARSHALLER_PROPERTIES = Arrays.asList("jaxb.encoding", "jaxb.formatted.output", "jaxb.fragment", "jaxb.noNamespaceSchemaLocation", "jaxb.schemaLocation", "com.sun.xml.bind.namespacePrefixMapper", "com.sun.xml.internal.bind.namespacePrefixMapper", "com.sun.xml.bind.xmlHeaders", "com.sun.xml.internal.bind.xmlHeaders");
    private Map<String, Object> mProperties = Collections.emptyMap();
    private Map<String, String> nsPrefixes = Collections.emptyMap();
    private String xmlResourceOffset = "";

    public void setXmlResourceOffset(String value) {
        this.xmlResourceOffset = value;
    }

    public void setNamespacePrefixes(Map<String, String> prefixes) {
        this.nsPrefixes = prefixes;
    }

    @Override
    protected boolean canBeReadAsJaxbElement(Class<?> type) {
        return super.canBeReadAsJaxbElement(type) && type != XMLSource.class && !Source.class.isAssignableFrom(type);
    }

    @Context
    public void setMessageContext(MessageContext mc) {
        super.setContext(mc);
    }

    @Override
    public void setEnableBuffering(boolean enableBuf) {
        super.setEnableBuffering(enableBuf);
    }

    @Override
    public void setConsumeMediaTypes(List<String> types) {
        super.setConsumeMediaTypes(types);
    }

    @Override
    public void setProduceMediaTypes(List<String> types) {
        super.setProduceMediaTypes(types);
    }

    public void setSchemas(List<String> locations) {
        super.setSchemaLocations(locations);
    }

    public void setSchemaHandler(SchemaHandler handler) {
        super.setSchema(handler.getSchema());
    }

    public void setMarshallerProperties(Map<String, Object> marshallProperties) {
        this.mProperties = marshallProperties;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.mProperties.put("jaxb.schemaLocation", schemaLocation);
    }

    public T readFrom(Class<T> type, Type genericType, Annotation[] anns, MediaType mt, MultivaluedMap<String, String> headers, InputStream is) throws IOException {
        if (this.isPayloadEmpty()) {
            if (AnnotationUtils.getAnnotation(anns, Nullable.class) != null) {
                return null;
            }
            this.reportEmptyContentLength();
        }
        try {
            boolean isCollection = InjectionUtils.isSupportedCollectionOrArray(type);
            Class<Object> theGenericType = isCollection ? InjectionUtils.getActualType(genericType) : type;
            Class<T> theType = this.getActualType(theGenericType, genericType, anns);
            Unmarshaller unmarshaller = this.createUnmarshaller(theType, genericType, isCollection);
            this.addAttachmentUnmarshaller(unmarshaller);
            Object response = null;
            if (JAXBElement.class.isAssignableFrom(type) || !isCollection && (this.unmarshalAsJaxbElement || this.jaxbElementClassMap != null && this.jaxbElementClassMap.containsKey(theType.getName()))) {
                XMLStreamReader reader = this.getStreamReader(is, type, mt);
                response = unmarshaller.unmarshal(TransformUtils.createNewReaderIfNeeded(reader, is), theType);
            } else {
                response = this.doUnmarshal(unmarshaller, type, is, mt);
            }
            if (response instanceof JAXBElement && !JAXBElement.class.isAssignableFrom(type)) {
                response = ((JAXBElement)response).getValue();
            }
            response = isCollection ? ((AbstractJAXBProvider.CollectionWrapper)response).getCollectionOrArray(theType, type, JAXBUtils.getAdapter(theGenericType, anns)) : JAXBElementProvider.checkAdapter(response, type, anns, false);
            return type.cast(response);
        }
        catch (JAXBException e) {
            JAXBElementProvider.handleJAXBException(e, true);
        }
        catch (DepthExceededStaxException e) {
            throw new WebApplicationException(413);
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.warning(JAXBElementProvider.getStackTrace(e));
            throw new WebApplicationException((Throwable)e);
        }
        return null;
    }

    protected Object doUnmarshal(Unmarshaller unmarshaller, Class<?> type, InputStream is, MediaType mt) throws JAXBException {
        XMLStreamReader reader = this.getStreamReader(is, type, mt);
        if (reader != null) {
            return this.unmarshalFromReader(unmarshaller, reader, mt);
        }
        return this.unmarshalFromInputStream(unmarshaller, is, mt);
    }

    protected XMLStreamReader getStreamReader(InputStream is, Class<?> type, MediaType mt) {
        XMLInputFactory factory;
        XMLStreamReader reader;
        MessageContext mc = this.getContext();
        XMLStreamReader xMLStreamReader = reader = mc != null ? mc.getContent(XMLStreamReader.class) : null;
        if (reader == null && mc != null && (factory = (XMLInputFactory)mc.get(XMLInputFactory.class.getName())) != null) {
            try {
                reader = factory.createXMLStreamReader(is);
            }
            catch (XMLStreamException e) {
                throw new WebApplicationException((Throwable)new RuntimeException("Can not create XMLStreamReader", e));
            }
        }
        if (reader == null && is == null) {
            reader = this.getStreamHandlerFromCurrentMessage(XMLStreamReader.class);
        }
        reader = this.createTransformReaderIfNeeded(reader, is);
        reader = this.createDepthReaderIfNeeded(reader, is);
        if (InjectionUtils.isSupportedCollectionOrArray(type)) {
            return new AbstractJAXBProvider.JAXBCollectionWrapperReader(TransformUtils.createNewReaderIfNeeded(reader, is));
        }
        return reader;
    }

    protected Object unmarshalFromInputStream(Unmarshaller unmarshaller, InputStream is, MediaType mt) throws JAXBException {
        if (is == null) {
            Reader reader = this.getStreamHandlerFromCurrentMessage(Reader.class);
            if (reader == null) {
                LOG.severe("No InputStream, Reader, or XMStreamReader is available");
                throw new WebApplicationException(500);
            }
            return unmarshaller.unmarshal(StaxUtils.createXMLStreamReader(reader));
        }
        return unmarshaller.unmarshal(StaxUtils.createXMLStreamReader(is));
    }

    protected Object unmarshalFromReader(Unmarshaller unmarshaller, XMLStreamReader reader, MediaType mt) throws JAXBException {
        return unmarshaller.unmarshal(reader);
    }

    public void writeTo(T obj, Class<?> cls, Type genericType, Annotation[] anns, MediaType m, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException {
        try {
            String encoding = HttpUtils.getSetEncoding(m, headers, null);
            if (InjectionUtils.isSupportedCollectionOrArray(cls)) {
                this.marshalCollection(cls, obj, genericType, encoding, os, m, anns);
            } else {
                Object actualObject = JAXBElementProvider.checkAdapter(obj, cls, anns, true);
                Class<?> actualClass = obj != actualObject || cls.isInterface() ? actualObject.getClass() : cls;
                this.marshal(actualObject, actualClass, genericType, encoding, os, m, anns);
            }
        }
        catch (JAXBException e) {
            JAXBElementProvider.handleJAXBException(e, true);
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WebApplicationException((Throwable)e);
        }
    }

    protected void marshalCollection(Class<?> originalCls, Object collection, Type genericType, String enc, OutputStream os, MediaType m, Annotation[] anns) throws Exception {
        Class actualClass = InjectionUtils.getActualType(genericType);
        actualClass = this.getActualType(actualClass, genericType, anns);
        List<Object> c = originalCls.isArray() ? Arrays.asList((Object[])collection) : (List<Object>)collection;
        Iterator it = c.iterator();
        Object firstObj = it.hasNext() ? (Object)it.next() : null;
        QName qname = null;
        if (firstObj instanceof JAXBElement) {
            JAXBElement el = (JAXBElement)firstObj;
            qname = el.getName();
            actualClass = el.getDeclaredType();
        } else {
            qname = this.getCollectionWrapperQName(actualClass, genericType, firstObj, true);
        }
        if (qname == null) {
            String message = new org.apache.cxf.common.i18n.Message("NO_COLLECTION_ROOT", BUNDLE, new Object[0]).toString();
            throw new WebApplicationException(Response.serverError().entity((Object)message).build());
        }
        StringBuilder pi = new StringBuilder();
        pi.append(XML_PI_START + (enc == null ? "UTF-8" : enc) + "\"?>");
        os.write(pi.toString().getBytes());
        String startTag = null;
        String endTag = null;
        if (qname.getNamespaceURI().length() > 0) {
            String prefix = this.nsPrefixes.get(qname.getNamespaceURI());
            if (prefix == null) {
                prefix = "ns1";
            }
            startTag = "<" + prefix + ":" + qname.getLocalPart() + " xmlns:" + prefix + "=\"" + qname.getNamespaceURI() + "\">";
            endTag = "</" + prefix + ":" + qname.getLocalPart() + ">";
        } else {
            startTag = "<" + qname.getLocalPart() + ">";
            endTag = "</" + qname.getLocalPart() + ">";
        }
        os.write(startTag.getBytes());
        if (firstObj != null) {
            XmlJavaTypeAdapter adapter = JAXBUtils.getAdapter(firstObj.getClass(), anns);
            this.marshalCollectionMember(JAXBUtils.useAdapter(firstObj, adapter, true), actualClass, genericType, enc, os, m, qname.getNamespaceURI());
            while (it.hasNext()) {
                this.marshalCollectionMember(JAXBUtils.useAdapter(it.next(), adapter, true), actualClass, genericType, enc, os, m, qname.getNamespaceURI());
            }
        }
        os.write(endTag.getBytes());
    }

    protected void marshalCollectionMember(Object obj, Class<?> cls, Type genericType, String enc, OutputStream os, MediaType mt, String ns) throws Exception {
        if ((obj = obj instanceof JAXBElement ? ((JAXBElement)obj).getValue() : this.convertToJaxbElementIfNeeded(obj, cls, genericType)) instanceof JAXBElement && cls != JAXBElement.class) {
            cls = JAXBElement.class;
        }
        Marshaller ms = this.createMarshaller(obj, cls, genericType, enc);
        ms.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        if (ns.length() > 0) {
            HashMap<String, String> map = new HashMap<String, String>();
            if (!this.nsPrefixes.containsKey(ns)) {
                map.put(ns, "ns1");
            }
            map.putAll(this.nsPrefixes);
            JAXBElementProvider.setNamespaceMapper(ms, map);
        }
        this.marshal(obj, cls, genericType, enc, os, mt, ms);
    }

    protected static void setNamespaceMapper(Marshaller ms, Map<String, String> map) throws Exception {
        NamespaceMapper nsMapper = new NamespaceMapper(map);
        JAXBElementProvider.setMarshallerProp(ms, (Object)nsMapper, NS_MAPPER_PROPERTY, NS_MAPPER_PROPERTY_INT);
    }

    protected void marshal(Object obj, Class<?> cls, Type genericType, String enc, OutputStream os, MediaType mt) throws Exception {
        this.marshal(obj, cls, genericType, enc, os, mt, new Annotation[0]);
    }

    protected void marshal(Object obj, Class<?> cls, Type genericType, String enc, OutputStream os, MediaType mt, Annotation[] anns) throws Exception {
        if ((obj = this.convertToJaxbElementIfNeeded(obj, cls, genericType)) instanceof JAXBElement && cls != JAXBElement.class) {
            cls = JAXBElement.class;
        }
        Marshaller ms = this.createMarshaller(obj, cls, genericType, enc);
        if (!this.nsPrefixes.isEmpty()) {
            JAXBElementProvider.setNamespaceMapper(ms, this.nsPrefixes);
        }
        this.addAttachmentMarshaller(ms);
        this.addProcessingInstructions(ms, anns);
        this.addSchemaLocation(ms, anns);
        this.marshal(obj, cls, genericType, enc, os, mt, ms);
    }

    private void addProcessingInstructions(Marshaller ms, Annotation[] anns) throws Exception {
        XMLInstruction pi = AnnotationUtils.getAnnotation(anns, XMLInstruction.class);
        if (pi != null) {
            String value = pi.value();
            int ind = value.indexOf("href='");
            if (ind > 0) {
                String relRef = value.substring(ind + 6, value.length() - 3);
                String absRef = this.buildAbsoluteXMLResourceURI(relRef);
                value = value.substring(0, ind + 6) + absRef + "'?>";
            }
            JAXBElementProvider.setMarshallerProp(ms, value, XML_PI_PROPERTY, XML_PI_PROPERTY_INT);
        }
    }

    private void addSchemaLocation(Marshaller ms, Annotation[] anns) throws Exception {
        XSISchemaLocation sl = AnnotationUtils.getAnnotation(anns, XSISchemaLocation.class);
        if (sl != null) {
            String value = this.buildAbsoluteXMLResourceURI(sl.value());
            String propName = !sl.noNamespace() ? "jaxb.schemaLocation" : "jaxb.noNamespaceSchemaLocation";
            ms.setProperty(propName, (Object)value);
        }
    }

    private String buildAbsoluteXMLResourceURI(String path) {
        MessageContext mc = this.getContext();
        if (mc != null) {
            String httpBasePath = (String)mc.get("http.base.path");
            UriBuilder builder = null;
            builder = httpBasePath != null ? UriBuilder.fromPath((String)httpBasePath) : mc.getUriInfo().getBaseUriBuilder();
            return builder.path(path).path(this.xmlResourceOffset).build(new Object[0]).toString();
        }
        return path;
    }

    private static void setMarshallerProp(Marshaller ms, Object value, String name1, String name2) throws Exception {
        try {
            ms.setProperty(name1, value);
        }
        catch (PropertyException ex) {
            ms.setProperty(name2, value);
        }
    }

    protected void addAttachmentMarshaller(Marshaller ms) {
        Collection<Attachment> attachments = this.getAttachments(true);
        if (attachments != null) {
            Object value = this.getContext().getContextualProperty("mtom-threshold");
            Integer threshold = value != null ? Integer.valueOf(value.toString()) : 0;
            ms.setAttachmentMarshaller((AttachmentMarshaller)new JAXBAttachmentMarshaller(attachments, threshold));
        }
    }

    protected void addAttachmentUnmarshaller(Unmarshaller um) {
        Collection<Attachment> attachments = this.getAttachments(false);
        if (attachments != null) {
            um.setAttachmentUnmarshaller((AttachmentUnmarshaller)new JAXBAttachmentUnmarshaller(attachments));
        }
    }

    private Collection<Attachment> getAttachments(boolean write) {
        MessageContext mc = this.getContext();
        if (mc != null) {
            String propertyName = write ? "WRITE-" + Message.ATTACHMENTS : Message.ATTACHMENTS;
            return CastUtils.cast((Collection)mc.get(propertyName));
        }
        return null;
    }

    protected void marshal(Object obj, Class<?> cls, Type genericType, String enc, OutputStream os, MediaType mt, Marshaller ms) throws Exception {
        XMLStreamWriter writer;
        for (Map.Entry<String, Object> entry : this.mProperties.entrySet()) {
            ms.setProperty(entry.getKey(), entry.getValue());
        }
        MessageContext mc = this.getContext();
        if (mc != null) {
            for (String key : MARSHALLER_PROPERTIES) {
                Object value = mc.get(key);
                if (value == null) continue;
                ms.setProperty(key, value);
            }
        }
        if ((writer = this.getStreamWriter(obj, os, mt)) != null) {
            if (os == null) {
                ms.setProperty("jaxb.fragment", (Object)true);
            } else if (mc != null) {
                if (mc.getContent(XMLStreamWriter.class) != null) {
                    ms.setProperty("jaxb.fragment", (Object)true);
                }
                mc.put(XMLStreamWriter.class.getName(), writer);
            }
            this.marshalToWriter(ms, obj, writer, mt);
            writer.writeEndDocument();
        } else {
            this.marshalToOutputStream(ms, obj, os, mt);
        }
    }

    protected XMLStreamWriter getStreamWriter(Object obj, OutputStream os, MediaType mt) {
        XMLStreamWriter writer = null;
        MessageContext mc = this.getContext();
        if (mc != null) {
            XMLOutputFactory factory;
            writer = mc.getContent(XMLStreamWriter.class);
            if (writer == null && (factory = (XMLOutputFactory)mc.get(XMLOutputFactory.class.getName())) != null) {
                try {
                    writer = factory.createXMLStreamWriter(os);
                }
                catch (XMLStreamException e) {
                    throw new WebApplicationException((Throwable)new RuntimeException("Cant' create XMLStreamWriter", e));
                }
            }
            if (writer == null && this.getEnableStreaming()) {
                writer = StaxUtils.createXMLStreamWriter(os);
            }
        }
        if (writer == null && os == null) {
            writer = this.getStreamHandlerFromCurrentMessage(XMLStreamWriter.class);
        }
        return this.createTransformWriterIfNeeded(writer, os);
    }

    protected void marshalToOutputStream(Marshaller ms, Object obj, OutputStream os, MediaType mt) throws Exception {
        if (os == null) {
            Writer writer = this.getStreamHandlerFromCurrentMessage(Writer.class);
            if (writer == null) {
                LOG.severe("No OutputStream, Writer, or XMStreamWriter is available");
                throw new WebApplicationException(500);
            }
            ms.marshal(obj, writer);
            writer.flush();
        } else {
            ms.marshal(obj, os);
        }
    }

    protected void marshalToWriter(Marshaller ms, Object obj, XMLStreamWriter writer, MediaType mt) throws Exception {
        ms.marshal(obj, writer);
    }
}

