/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.jaxrs.client.ClientWebApplicationException;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.ext.form.Form;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenGrant;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.apache.cxf.rs.security.oauth2.common.OAuthError;
import org.apache.cxf.rs.security.oauth2.provider.OAuthJSONProvider;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;

public final class OAuthClientUtils {
    private OAuthClientUtils() {
    }

    public static URI getAuthorizationURI(String authorizationServiceURI, String clientId, String redirectUri, String state, String scope) {
        UriBuilder ub = OAuthClientUtils.getAuthorizationURIBuilder(authorizationServiceURI, clientId, scope);
        if (redirectUri != null) {
            ub.queryParam("redirect_uri", new Object[]{redirectUri});
        }
        if (state != null) {
            ub.queryParam("state", new Object[]{state});
        }
        return ub.build(new Object[0]);
    }

    public static UriBuilder getAuthorizationURIBuilder(String authorizationServiceURI, String clientId, String scope) {
        UriBuilder ub = UriBuilder.fromUri((String)authorizationServiceURI);
        if (clientId != null) {
            ub.queryParam("client_id", new Object[]{clientId});
        }
        if (scope != null) {
            ub.queryParam("scope", new Object[]{scope});
        }
        ub.queryParam("response_type", new Object[]{"code"});
        return ub;
    }

    public static ClientAccessToken getAccessToken(WebClient accessTokenService, Consumer consumer, AccessTokenGrant grant) throws OAuthServiceException {
        return OAuthClientUtils.getAccessToken(accessTokenService, consumer, grant, true);
    }

    public static ClientAccessToken getAccessToken(String accessTokenServiceUri, Consumer consumer, AccessTokenGrant grant, boolean setAuthorizationHeader) throws OAuthServiceException {
        OAuthJSONProvider provider = new OAuthJSONProvider();
        WebClient accessTokenService = WebClient.create(accessTokenServiceUri, Collections.singletonList(provider));
        accessTokenService.accept("application/json");
        return OAuthClientUtils.getAccessToken(accessTokenService, consumer, grant, true);
    }

    public static ClientAccessToken getAccessToken(WebClient accessTokenService, Consumer consumer, AccessTokenGrant grant, boolean setAuthorizationHeader) throws OAuthServiceException {
        Form form = new Form(grant.toMap());
        if (consumer != null) {
            if (setAuthorizationHeader) {
                StringBuilder sb = new StringBuilder();
                sb.append("Basic ");
                try {
                    String data = consumer.getKey() + ":" + consumer.getSecret();
                    sb.append(Base64Utility.encode(data.getBytes("UTF-8")));
                }
                catch (Exception ex) {
                    throw new ClientWebApplicationException(ex);
                }
                accessTokenService.header("Authorization", sb.toString());
            } else {
                form.set("client_id", consumer.getKey());
                form.set("client_secret", consumer.getSecret());
            }
        }
        Response response = accessTokenService.form(form);
        Map<String, String> map = null;
        try {
            map = new OAuthJSONProvider().readJSONResponse((InputStream)response.getEntity());
        }
        catch (IOException ex) {
            throw new ClientWebApplicationException(ex);
        }
        if (200 == response.getStatus()) {
            if (map.containsKey("access_token") && map.containsKey("token_type")) {
                String tokenType = map.get("token_type");
                ClientAccessToken token = new ClientAccessToken(tokenType, map.get("access_token"));
                return token;
            }
            throw new OAuthServiceException("server_error");
        }
        if (400 == response.getStatus() && map.containsValue("error")) {
            OAuthError error = new OAuthError(map.get("error"), map.get("error_description"));
            throw new OAuthServiceException(error);
        }
        throw new OAuthServiceException("server_error");
    }

    public static String createAuthorizationHeader(Consumer consumer, ClientAccessToken accessToken) throws OAuthServiceException {
        StringBuilder sb = new StringBuilder();
        OAuthClientUtils.appendTokenData(sb, accessToken);
        return sb.toString();
    }

    private static void appendTokenData(StringBuilder sb, ClientAccessToken token) throws OAuthServiceException {
        if (!"bearer".equals(token.getTokenType())) {
            throw new OAuthServiceException("Unsupported token type");
        }
        sb.append("Bearer");
        sb.append(" ");
        sb.append(token.getTokenKey());
    }

    public static class Consumer {
        private String key;
        private String secret;

        public Consumer(String key, String secret) {
            this.key = key;
            this.secret = secret;
        }

        public String getKey() {
            return this.key;
        }

        public String getSecret() {
            return this.secret;
        }
    }
}

