/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.filters;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.security.SimplePrincipal;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.ext.RequestHandler;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.oauth2.common.OAuthContext;
import org.apache.cxf.rs.security.oauth2.common.OAuthPermission;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.provider.AccessTokenValidator;
import org.apache.cxf.rs.security.oauth2.provider.OAuthDataProvider;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.utils.AuthorizationUtils;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;
import org.apache.cxf.security.SecurityContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
public class OAuthRequestFilter
implements RequestHandler {
    private static final Logger LOG = LogUtils.getL7dLogger(OAuthRequestFilter.class);
    private static final String DEFAULT_AUTH_SCHEME = "Bearer";
    private MessageContext mc;
    private List<AccessTokenValidator> tokenHandlers = Collections.emptyList();
    private Set<String> supportedSchemes = new HashSet<String>();
    private boolean useUserSubject;
    private OAuthDataProvider dataProvider;

    public void setGrantHandlers(List<AccessTokenValidator> handlers) {
        this.tokenHandlers = handlers;
        for (AccessTokenValidator handler : handlers) {
            this.supportedSchemes.addAll(handler.getSupportedAuthorizationSchemes());
        }
    }

    @Override
    public Response handleRequest(Message m, ClassResourceInfo resourceClass) {
        ServerAccessToken accessToken = this.getAccessToken();
        List<OAuthPermission> permissions = accessToken.getScopes();
        ArrayList<OAuthPermission> matchingPermissions = new ArrayList<OAuthPermission>();
        HttpServletRequest req = this.mc.getHttpServletRequest();
        for (OAuthPermission perm : permissions) {
            boolean uriOK = this.checkRequestURI(req, perm.getUris());
            boolean verbOK = this.checkHttpVerb(req, perm.getHttpVerbs());
            if (!uriOK || !verbOK) continue;
            matchingPermissions.add(perm);
        }
        if (permissions.size() > 0 && matchingPermissions.isEmpty()) {
            String message = "Client has no valid permissions";
            LOG.warning(message);
            throw new WebApplicationException(403);
        }
        SecurityContext sc = this.createSecurityContext(req, accessToken);
        m.put(SecurityContext.class, sc);
        m.setContent(OAuthContext.class, new OAuthContext(accessToken.getSubject(), matchingPermissions, accessToken.getGrantType()));
        return null;
    }

    protected boolean checkHttpVerb(HttpServletRequest req, List<String> verbs) {
        if (!verbs.isEmpty() && !verbs.contains(req.getMethod())) {
            String message = "Invalid http verb";
            LOG.fine(message);
            return false;
        }
        return true;
    }

    protected boolean checkRequestURI(HttpServletRequest request, List<String> uris) {
        if (uris.isEmpty()) {
            return true;
        }
        String servletPath = request.getPathInfo();
        boolean foundValidScope = false;
        for (String uri : uris) {
            if (!OAuthUtils.checkRequestURI(servletPath, uri)) continue;
            foundValidScope = true;
            break;
        }
        if (!foundValidScope) {
            String message = "Invalid request URI";
            LOG.fine(message);
        }
        return foundValidScope;
    }

    public void setDataProvider(OAuthDataProvider provider) {
        this.dataProvider = provider;
    }

    public void setUseUserSubject(boolean useUserSubject) {
        this.useUserSubject = useUserSubject;
    }

    @Context
    public void setMessageContext(MessageContext context) {
        this.mc = context;
    }

    protected AccessTokenValidator findTokenHandler(String authScheme) {
        for (AccessTokenValidator handler : this.tokenHandlers) {
            if (!handler.getSupportedAuthorizationSchemes().contains(authScheme)) continue;
            return handler;
        }
        return null;
    }

    protected ServerAccessToken getAccessToken() {
        ServerAccessToken accessToken = null;
        if (this.dataProvider == null && this.tokenHandlers.isEmpty()) {
            throw new WebApplicationException(500);
        }
        String[] authParts = AuthorizationUtils.getAuthorizationParts(this.mc, this.supportedSchemes);
        String authScheme = authParts[0];
        String authSchemeData = authParts[1];
        AccessTokenValidator handler = this.findTokenHandler(authScheme);
        if (handler != null) {
            try {
                accessToken = handler.getAccessToken(authSchemeData);
            }
            catch (OAuthServiceException ex) {
                AuthorizationUtils.throwAuthorizationFailure(Collections.singleton(authScheme));
            }
        }
        if (accessToken == null && authScheme.equals(DEFAULT_AUTH_SCHEME)) {
            try {
                accessToken = this.dataProvider.getAccessToken(authSchemeData);
            }
            catch (OAuthServiceException ex) {
                AuthorizationUtils.throwAuthorizationFailure(Collections.singleton(authScheme));
            }
        }
        if (accessToken == null) {
            AuthorizationUtils.throwAuthorizationFailure(this.supportedSchemes);
        }
        if (OAuthUtils.isExpired(accessToken.getIssuedAt(), accessToken.getLifetime())) {
            this.dataProvider.removeAccessToken(accessToken);
            AuthorizationUtils.throwAuthorizationFailure(this.supportedSchemes);
        }
        return accessToken;
    }

    protected SecurityContext createSecurityContext(HttpServletRequest request, ServerAccessToken token) {
        UserSubject endUserSubject = token.getSubject();
        UserSubject clientSubject = token.getClient().getSubject();
        final UserSubject theSubject = this.useUserSubject ? endUserSubject : clientSubject;
        return new SecurityContext(){

            public Principal getUserPrincipal() {
                return theSubject != null ? new SimplePrincipal(theSubject.getLogin()) : null;
            }

            public boolean isUserInRole(String role) {
                if (theSubject == null) {
                    return false;
                }
                return theSubject.getRoles().contains(role);
            }
        };
    }
}

