/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import javax.xml.namespace.QName;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.FileUtils;
import org.apache.cxf.tools.common.Tag;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.util.ToolsStaxUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.ComparisonFailure;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessorTestBase
extends Assert {
    public static final List<String> DEFAULT_IGNORE_ATTR = Arrays.asList("attributeFormDefault", "elementFormDefault", "form", "version", "part@name");
    public static final List<String> DEFAULT_IGNORE_TAG = Arrays.asList("sequence");
    @Rule
    public TemporaryFolder tmpDir = new TemporaryFolder(){

        protected void before() throws Throwable {
            super.before();
            ProcessorTestBase.this.output = ProcessorTestBase.this.tmpDir.getRoot();
            ProcessorTestBase.this.env.put("outputdir", ProcessorTestBase.this.output.getCanonicalPath());
        }
    };
    protected File output;
    protected ToolContext env = new ToolContext();

    @After
    public void tearDown() {
        this.env = null;
    }

    protected String getClassPath() throws URISyntaxException, IOException {
        ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
        StringBuilder classPath = new StringBuilder();
        if (loader instanceof URLClassLoader) {
            URLClassLoader urlLoader = (URLClassLoader)loader;
            for (URL url : urlLoader.getURLs()) {
                JarFile jar;
                Attributes attr;
                File file = new File(url.toURI());
                String filename = file.getAbsolutePath();
                if (filename.indexOf("junit") == -1) {
                    classPath.append(filename);
                    classPath.append(System.getProperty("path.separator"));
                }
                if (filename.indexOf("surefirebooter") == -1 || (attr = (jar = new JarFile(filename)).getManifest().getMainAttributes()) == null) continue;
                String cp = attr.getValue("Class-Path");
                while (cp != null) {
                    URI uri;
                    File f2;
                    String fileName = cp;
                    int idx = fileName.indexOf(32);
                    if (idx != -1) {
                        fileName = fileName.substring(0, idx);
                        cp = cp.substring(idx + 1).trim();
                    } else {
                        cp = null;
                    }
                    if (!(f2 = new File(uri = new URI(fileName))).exists()) continue;
                    classPath.append(f2.getAbsolutePath());
                    classPath.append(System.getProperty("path.separator"));
                }
            }
        }
        return classPath.toString();
    }

    protected String getLocation(String wsdlFile) throws URISyntaxException {
        return ((Object)((Object)this)).getClass().getResource(wsdlFile).toURI().toString();
    }

    protected File getResource(String wsdlFile) throws URISyntaxException {
        return new File(((Object)((Object)this)).getClass().getResource(wsdlFile).toURI());
    }

    protected void assertFileEquals(String f1, String f2) {
        this.assertFileEquals(new File(f1), new File(f2));
    }

    protected void assertFileEquals(File location1, File location2) {
        String str1 = FileUtils.getStringFromFile(location1);
        String str2 = FileUtils.getStringFromFile(location2);
        StringTokenizer st1 = new StringTokenizer(str1, " \t\n\r\f(),");
        StringTokenizer st2 = new StringTokenizer(str2, " \t\n\r\f(),");
        ArrayList<String> unmatched = new ArrayList<String>();
        while (st1.hasMoreTokens()) {
            String tok1 = st1.nextToken();
            String tok2 = null;
            if (unmatched.contains(tok1)) {
                unmatched.remove(tok1);
                continue;
            }
            while (st2.hasMoreTokens() && !tok1.equals(tok2 = st2.nextToken())) {
                unmatched.add(tok2);
            }
            ProcessorTestBase.assertEquals((String)("Compare failed " + location1.getAbsolutePath() + " != " + location2.getAbsolutePath()), (Object)tok1, (Object)tok2);
        }
        ProcessorTestBase.assertTrue((!st1.hasMoreTokens() ? 1 : 0) != 0);
        ProcessorTestBase.assertTrue((!st2.hasMoreTokens() ? 1 : 0) != 0);
        ProcessorTestBase.assertTrue((String)("Files did not match: " + unmatched), (boolean)unmatched.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStringFromFile(File location) {
        FileInputStream is = null;
        String result = null;
        try {
            is = new FileInputStream(location);
            result = FileUtils.normalizeCRLF(is);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception e) {}
            }
        }
        return result;
    }

    public boolean assertXmlEquals(File expected, File source) throws Exception {
        List<String> attr = Arrays.asList("attributeFormDefault", "elementFormDefault", "form");
        return this.assertXmlEquals(expected, source, attr);
    }

    public boolean assertXmlEquals(File expected, File source, List<String> ignoreAttr) throws Exception {
        List<Tag> expectedTags = ToolsStaxUtils.getTags(expected);
        List<Tag> sourceTags = ToolsStaxUtils.getTags(source);
        Iterator<Tag> iterator = sourceTags.iterator();
        for (Tag expectedTag : expectedTags) {
            Tag sourceTag = iterator.next();
            if (!expectedTag.getName().equals(sourceTag.getName())) {
                throw new ComparisonFailure("Tags not equal: ", expectedTag.getName().toString(), sourceTag.getName().toString());
            }
            for (Map.Entry<QName, String> attr : expectedTag.getAttributes().entrySet()) {
                if (ignoreAttr.contains(attr.getKey().getLocalPart())) continue;
                if (sourceTag.getAttributes().containsKey(attr.getKey())) {
                    if (sourceTag.getAttributes().get(attr.getKey()).equals(attr.getValue())) continue;
                    throw new ComparisonFailure("Attributes not equal: ", attr.getKey() + ":" + attr.getValue(), attr.getKey() + ":" + sourceTag.getAttributes().get(attr.getKey()));
                }
                throw new AssertionError((Object)("Attribute: " + attr + " is missing in the source file."));
            }
            if (StringUtils.isEmpty(expectedTag.getText()) || expectedTag.getText().equals(sourceTag.getText())) continue;
            throw new ComparisonFailure("Text not equal: ", expectedTag.getText(), sourceTag.getText());
        }
        return true;
    }

    protected void assertTagEquals(Tag expected, Tag source) {
        this.assertTagEquals(expected, source, DEFAULT_IGNORE_ATTR, DEFAULT_IGNORE_TAG);
    }

    protected void assertAttributesEquals(QName element, Map<QName, String> q1, Map<QName, String> q2, Collection<String> ignoreAttr) {
        for (Map.Entry<QName, String> attr : q1.entrySet()) {
            if (ignoreAttr.contains(attr.getKey().getLocalPart()) || ignoreAttr.contains(element.getLocalPart() + "@" + attr.getKey().getLocalPart())) continue;
            String found = q2.get(attr.getKey());
            if (found == null) {
                throw new AssertionError((Object)("Attribute: " + attr.getKey() + " is missing in " + element));
            }
            if (found.equals(attr.getValue())) continue;
            throw new ComparisonFailure("Attribute not equal: ", attr.getKey() + ":" + attr.getValue(), attr.getKey() + ":" + found);
        }
    }

    protected void assertTagEquals(Tag expected, Tag source, List<String> ignoreAttr, List<String> ignoreTag) {
        if (!expected.getName().equals(source.getName())) {
            throw new ComparisonFailure("Tags not equal: ", expected.getName().toString(), source.getName().toString());
        }
        this.assertAttributesEquals(expected.getName(), expected.getAttributes(), source.getAttributes(), ignoreAttr);
        this.assertAttributesEquals(expected.getName(), source.getAttributes(), expected.getAttributes(), ignoreAttr);
        if (!StringUtils.isEmpty(expected.getText()) && !expected.getText().equals(source.getText())) {
            throw new ComparisonFailure("Text not equal: ", expected.getText(), source.getText());
        }
        if (!expected.getTags().isEmpty()) {
            for (Tag expectedTag : expected.getTags()) {
                if (ignoreTag.contains(expectedTag.getName().getLocalPart()) && expectedTag.getTags().isEmpty()) continue;
                Tag sourceTag = this.getFromSource(source, expectedTag);
                if (sourceTag == null) {
                    throw new AssertionError((Object)("\n" + expected.toString() + " is missing in the source file:" + "\n" + source.toString()));
                }
                this.assertTagEquals(expectedTag, sourceTag, ignoreAttr, ignoreTag);
            }
        }
    }

    private Tag getFromSource(Tag sourceTag, Tag expectedTag) {
        for (Tag tag : sourceTag.getTags()) {
            if (!tag.equals(expectedTag)) continue;
            return tag;
        }
        return null;
    }

    public void assertWsdlEquals(File expected, File source, List<String> attr, List<String> tag) throws Exception {
        Tag expectedTag = ToolsStaxUtils.getTagTree(expected, attr);
        Tag sourceTag = ToolsStaxUtils.getTagTree(source, attr);
        this.assertTagEquals(expectedTag, sourceTag, attr, tag);
    }

    public void assertWsdlEquals(File expected, File source) throws Exception {
        this.assertWsdlEquals(expected, source, DEFAULT_IGNORE_ATTR, DEFAULT_IGNORE_TAG);
    }

    public void assertWsdlEquals(InputStream expected, InputStream source, List<String> attr, List<String> tag) throws Exception {
        Tag expectedTag = ToolsStaxUtils.getTagTree(expected, attr);
        Tag sourceTag = ToolsStaxUtils.getTagTree(source, attr);
        this.assertTagEquals(expectedTag, sourceTag, attr, tag);
    }

    public void assertWsdlEquals(InputStream expected, InputStream source) throws Exception {
        this.assertWsdlEquals(expected, source, DEFAULT_IGNORE_ATTR, DEFAULT_IGNORE_TAG);
    }
}

