/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.common.idltypes;

import java.io.PrintWriter;
import java.util.List;
import java.util.Vector;
import org.apache.cxf.tools.corba.common.idltypes.IdlAnonArray;
import org.apache.cxf.tools.corba.common.idltypes.IdlDefnImplBase;
import org.apache.cxf.tools.corba.common.idltypes.IdlScopeBase;
import org.apache.cxf.tools.corba.common.idltypes.IdlType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdlArrayBase
extends IdlDefnImplBase
implements IdlType {
    private IdlType elemType;
    private List<Integer> dims;
    private int size;

    protected IdlArrayBase(IdlScopeBase parent, String name, IdlType elem, int length) {
        super(parent, name);
        this.size = length;
        this.dims = new Vector<Integer>();
        if (elem instanceof IdlAnonArray) {
            IdlAnonArray arr = (IdlAnonArray)elem;
            this.elemType = arr.elemType();
            for (Integer i : arr.dimensions()) {
                this.dims.add(i);
            }
        } else {
            this.elemType = elem;
        }
        this.dims.add(0, new Integer(this.size));
    }

    @Override
    public void write(PrintWriter pw) {
        for (Integer i : this.dims) {
            pw.print("[" + i + "]");
        }
    }

    @Override
    public void write(PrintWriter pw, String name) {
        pw.print(name);
        for (Integer i : this.dims) {
            pw.print("[" + i + "]");
        }
    }

    @Override
    public boolean isEmptyDef() {
        return this.elemType.isEmptyDef();
    }

    @Override
    public IdlScopeBase getCircularScope(IdlScopeBase startScope, List<Object> doneDefn) {
        return this.elemType.getCircularScope(startScope, doneDefn);
    }

    IdlType elemType() {
        return this.elemType;
    }

    int size() {
        return this.size;
    }

    protected List<Integer> dimensions() {
        return this.dims;
    }
}

