/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringUtils {
    public static final Map<String, Pattern> PATTERN_MAP;

    private StringUtils() {
    }

    public static String[] split(String s, String regex) {
        Pattern p = PATTERN_MAP.get(regex);
        if (p != null) {
            return p.split(s);
        }
        return s.split(regex);
    }

    public static String[] split(String s, String regex, int limit) {
        Pattern p = PATTERN_MAP.get(regex);
        if (p != null) {
            return p.split(s, limit);
        }
        return s.split(regex, limit);
    }

    public static String extract(String string, String startToken, String endToken) {
        int start = string.indexOf(startToken) + startToken.length();
        int end = string.lastIndexOf(endToken);
        if (start == -1 || end == -1) {
            return null;
        }
        return string.substring(start, end);
    }

    public static String wrapper(String string, String startToken, String endToken) {
        StringBuilder sb = new StringBuilder();
        sb.append(startToken);
        sb.append(string);
        sb.append(endToken);
        return sb.toString();
    }

    public static boolean isFileExist(String file) {
        return new File(file).exists() && new File(file).isFile();
    }

    public static boolean isFileAbsolute(String file) {
        return StringUtils.isFileExist(file) && new File(file).isAbsolute();
    }

    public static URL getURL(String spec) throws MalformedURLException {
        try {
            return new URL(spec);
        }
        catch (MalformedURLException e) {
            return new File(spec).toURI().toURL();
        }
    }

    public static boolean isEmpty(String str) {
        if (str != null) {
            int len = str.length();
            for (int x = 0; x < len; ++x) {
                if (str.charAt(x) <= ' ') continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isEmpty(List<String> list) {
        if (list == null || list.size() == 0) {
            return true;
        }
        return list.size() == 1 && StringUtils.isEmpty(list.get(0));
    }

    public static boolean isEqualUri(String uri1, String uri2) {
        if (uri1.substring(uri1.length() - 1).equals("/") && !uri2.substring(uri2.length() - 1).equals("/")) {
            return uri1.substring(0, uri1.length() - 1).equals(uri2);
        }
        if (uri2.substring(uri2.length() - 1).equals("/") && !uri1.substring(uri1.length() - 1).equals("/")) {
            return uri2.substring(0, uri2.length() - 1).equals(uri1);
        }
        return uri1.equals(uri2);
    }

    public static String diff(String str1, String str2) {
        int index = str1.lastIndexOf(str2);
        if (index > -1) {
            return str1.substring(str2.length());
        }
        return str1;
    }

    public static List<String> getParts(String str, String separator) {
        ArrayList<String> ret = new ArrayList<String>();
        List<String> parts = Arrays.asList(StringUtils.split(str, separator));
        for (String part : parts) {
            if (StringUtils.isEmpty(part)) continue;
            ret.add(part);
        }
        return ret;
    }

    public static String getFirstNotEmpty(String str, String separator) {
        List<String> parts = Arrays.asList(StringUtils.split(str, separator));
        for (String part : parts) {
            if (StringUtils.isEmpty(part)) continue;
            return part;
        }
        return str;
    }

    public static String getFirstNotEmpty(List<String> list) {
        if (StringUtils.isEmpty(list)) {
            return null;
        }
        for (String item : list) {
            if (StringUtils.isEmpty(item)) continue;
            return item;
        }
        return null;
    }

    public static List<String> getFound(String contents, String regex) {
        if (StringUtils.isEmpty(regex) || StringUtils.isEmpty(contents)) {
            return null;
        }
        ArrayList<String> results = new ArrayList<String>();
        Pattern pattern = Pattern.compile(regex, 64);
        Matcher matcher = pattern.matcher(contents);
        while (matcher.find()) {
            if (matcher.groupCount() > 0) {
                results.add(matcher.group(1));
                continue;
            }
            results.add(matcher.group());
        }
        return results;
    }

    public static String getFirstFound(String contents, String regex) {
        List<String> founds = StringUtils.getFound(contents, regex);
        if (StringUtils.isEmpty(founds)) {
            return null;
        }
        return founds.get(0);
    }

    public static String formatVersionNumber(String target) {
        List<String> found = StringUtils.getFound(target, "\\d+\\.\\d+\\.?\\d*");
        if (StringUtils.isEmpty(found)) {
            return target;
        }
        return StringUtils.getFirstNotEmpty(found);
    }

    public static String addDefaultPortIfMissing(String urlString) {
        return StringUtils.addDefaultPortIfMissing(urlString, "80");
    }

    public static String addDefaultPortIfMissing(String urlString, String defaultPort) {
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            return urlString;
        }
        if (url.getPort() != -1) {
            return urlString;
        }
        String regex = "http://([^/]+)";
        String found = StringUtils.getFirstFound(urlString, regex);
        String replacer = "http://" + found + ":" + defaultPort;
        if (!StringUtils.isEmpty(found)) {
            urlString = urlString.replaceFirst(regex, replacer);
        }
        return urlString;
    }

    public static String capitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static String uncapitalize(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        return new StringBuilder(str.length()).append(Character.toLowerCase(str.charAt(0))).append(str.substring(1)).toString();
    }

    static {
        String[] patterns;
        PATTERN_MAP = new HashMap<String, Pattern>();
        for (String p : patterns = new String[]{"/", " ", ":", ",", ";", "="}) {
            PATTERN_MAP.put(p, Pattern.compile(p));
        }
    }
}

