/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.activation.DataHandler;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Response;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.annotations.UseAsyncMethod;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.continuations.Continuation;
import org.apache.cxf.continuations.ContinuationProvider;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.FaultMode;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.invoker.Factory;
import org.apache.cxf.service.invoker.FactoryInvoker;
import org.apache.cxf.service.invoker.SingletonFactory;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJAXWSMethodInvoker
extends FactoryInvoker {
    private static final String ASYNC_METHOD = "org.apache.cxf.jaxws.async.method";

    public AbstractJAXWSMethodInvoker(Object bean) {
        super(new SingletonFactory(bean));
    }

    public AbstractJAXWSMethodInvoker(Factory factory) {
        super(factory);
    }

    protected SOAPFaultException findSoapFaultException(Throwable ex) {
        if (ex instanceof SOAPFaultException) {
            return (SOAPFaultException)ex;
        }
        if (ex.getCause() != null) {
            return this.findSoapFaultException(ex.getCause());
        }
        return null;
    }

    @Override
    protected Method adjustMethodAndParams(Method m, Exchange ex, List<Object> params) {
        UseAsyncMethod uam = m.getAnnotation(UseAsyncMethod.class);
        if (uam != null) {
            BindingOperationInfo bop = ex.getBindingOperationInfo();
            Method ret = bop.getProperty(ASYNC_METHOD, Method.class);
            if (ret == null) {
                Class[] ptypes = new Class[m.getParameterTypes().length + 1];
                System.arraycopy(m.getParameterTypes(), 0, ptypes, 0, m.getParameterTypes().length);
                ptypes[m.getParameterTypes().length] = AsyncHandler.class;
                try {
                    ret = m.getDeclaringClass().getMethod(m.getName() + "Async", ptypes);
                    bop.setProperty(ASYNC_METHOD, ret);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (ret != null) {
                JaxwsServerHandler h = ex.get(JaxwsServerHandler.class);
                if (h != null) {
                    return ret;
                }
                ContinuationProvider cp = ex.getInMessage().get(ContinuationProvider.class);
                if (cp == null && uam.always()) {
                    JaxwsServerHandler handler = new JaxwsServerHandler(null);
                    ex.put(JaxwsServerHandler.class, handler);
                    params.add(handler);
                    return ret;
                }
                if (cp != null && cp.getContinuation() != null) {
                    Continuation c = cp.getContinuation();
                    c.suspend(0L);
                    JaxwsServerHandler handler = new JaxwsServerHandler(c);
                    ex.put(JaxwsServerHandler.class, handler);
                    params.add(handler);
                    return ret;
                }
            }
        }
        return m;
    }

    @Override
    protected Object invoke(Exchange exchange, Object serviceObject, Method m, List<Object> params) {
        JaxwsServerHandler h = exchange.get(JaxwsServerHandler.class);
        if (h != null && h.isDone()) {
            BindingOperationInfo bop = exchange.getBindingOperationInfo();
            if (bop.isUnwrapped()) {
                exchange.put(BindingOperationInfo.class, bop.getWrappedOperation());
            }
            try {
                return new MessageContentsList(h.getObject());
            }
            catch (ExecutionException ex) {
                exchange.getInMessage().put(FaultMode.class, FaultMode.CHECKED_APPLICATION_FAULT);
                throw this.createFault(ex.getCause(), m, params, true);
            }
            catch (Exception ex) {
                throw this.createFault(ex.getCause(), m, params, false);
            }
        }
        Object o = super.invoke(exchange, serviceObject, m, params);
        if (h != null && !h.hasContinuation()) {
            h.waitForDone();
            BindingOperationInfo bop = exchange.getBindingOperationInfo();
            if (bop.isUnwrapped()) {
                exchange.put(BindingOperationInfo.class, bop.getWrappedOperation());
            }
            try {
                return new MessageContentsList(h.getObject());
            }
            catch (ExecutionException ex) {
                exchange.getInMessage().put(FaultMode.class, FaultMode.CHECKED_APPLICATION_FAULT);
                throw this.createFault(ex.getCause(), m, params, true);
            }
            catch (Exception ex) {
                throw this.createFault(ex.getCause(), m, params, false);
            }
        }
        return o;
    }

    @Override
    protected Fault createFault(Throwable ex, Method m, List<Object> params, boolean checked) {
        SOAPFaultException sfe = this.findSoapFaultException(ex);
        if (sfe != null) {
            SoapFault fault = new SoapFault(sfe.getFault().getFaultString(), ex, sfe.getFault().getFaultCodeAsQName());
            fault.setRole(sfe.getFault().getFaultActor());
            if (sfe.getFault().hasDetail()) {
                fault.setDetail((Element)sfe.getFault().getDetail());
            }
            return fault;
        }
        return super.createFault(ex, m, params, checked);
    }

    protected Map<String, Object> removeHandlerProperties(WrappedMessageContext ctx) {
        Map scopes = CastUtils.cast((Map)ctx.get(WrappedMessageContext.SCOPES));
        HashMap<String, Object> handlerScopedStuff = new HashMap<String, Object>();
        if (scopes != null) {
            for (Map.Entry scope : scopes.entrySet()) {
                if (scope.getValue() != MessageContext.Scope.HANDLER) continue;
                handlerScopedStuff.put((String)scope.getKey(), ctx.get(scope.getKey()));
            }
            for (String key : handlerScopedStuff.keySet()) {
                ctx.remove(key);
            }
        }
        return handlerScopedStuff;
    }

    protected void addHandlerProperties(WrappedMessageContext ctx, Map<String, Object> handlerScopedStuff) {
        for (Map.Entry<String, Object> key : handlerScopedStuff.entrySet()) {
            ctx.put(key.getKey(), key.getValue(), MessageContext.Scope.HANDLER);
        }
    }

    private Message createResponseMessage(Exchange exchange) {
        if (exchange == null) {
            return null;
        }
        Message m = exchange.getOutMessage();
        if (m == null && !exchange.isOneWay()) {
            Endpoint ep = exchange.get(Endpoint.class);
            m = new MessageImpl();
            m.setExchange(exchange);
            m = ep.getBinding().createMessage(m);
            exchange.setOutMessage(m);
        }
        return m;
    }

    protected void updateWebServiceContext(Exchange exchange, MessageContext ctx) {
        SoapMessage sm;
        List list;
        if (ctx.containsKey((Object)Header.HEADER_LIST) && ctx.get((Object)Header.HEADER_LIST) instanceof List && (list = (List)ctx.get((Object)Header.HEADER_LIST)) != null && !list.isEmpty() && (sm = (SoapMessage)this.createResponseMessage(exchange)) != null) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                sm.getHeaders().add((Header)iter.next());
            }
        }
        if (exchange.getOutMessage() != null) {
            Map dataHandlers;
            Map heads;
            Message out = exchange.getOutMessage();
            if (out.containsKey(Message.PROTOCOL_HEADERS) && (heads = CastUtils.cast((Map)exchange.getOutMessage().get(Message.PROTOCOL_HEADERS))).containsKey("Content-Type")) {
                List ct = (List)heads.get("Content-Type");
                exchange.getOutMessage().put("Content-Type", ct.get(0));
                heads.remove("Content-Type");
            }
            if ((dataHandlers = CastUtils.cast((Map)out.get("javax.xml.ws.binding.attachments.outbound"))) != null && !dataHandlers.isEmpty()) {
                Collection<Attachment> attachments = out.getAttachments();
                if (attachments == null) {
                    attachments = new ArrayList<Attachment>();
                    out.setAttachments(attachments);
                }
                for (Map.Entry entry : dataHandlers.entrySet()) {
                    AttachmentImpl att = new AttachmentImpl((String)entry.getKey(), (DataHandler)entry.getValue());
                    attachments.add(att);
                }
            }
            out.remove("javax.xml.ws.binding.attachments.outbound");
        }
    }

    protected void updateHeader(Exchange exchange, MessageContext ctx) {
        SoapMessage sm;
        List list;
        if (ctx.containsKey((Object)Header.HEADER_LIST) && ctx.get((Object)Header.HEADER_LIST) instanceof List && (list = (List)ctx.get((Object)Header.HEADER_LIST)) != null && !list.isEmpty() && (sm = (SoapMessage)this.createResponseMessage(exchange)) != null) {
            for (Header header : list) {
                if (header.getDirection() == Header.Direction.DIRECTION_IN || header.getName().getNamespaceURI().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd") || header.getName().getNamespaceURI().equals("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd")) continue;
                sm.getHeaders().add(header);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class JaxwsServerHandler
    implements AsyncHandler<Object> {
        Response<Object> r;
        Continuation continuation;
        boolean done;

        public JaxwsServerHandler(Continuation c) {
            this.continuation = c;
        }

        public synchronized void handleResponse(Response<Object> res) {
            this.r = res;
            this.done = true;
            if (this.continuation != null) {
                this.continuation.resume();
            }
            this.notifyAll();
        }

        public boolean hasContinuation() {
            return this.continuation != null;
        }

        public synchronized void waitForDone() {
            while (!this.done) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public boolean isDone() {
            return this.done;
        }

        public Object getObject() throws Exception {
            return this.r.get();
        }
    }
}

