/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.coloc;

import javax.xml.namespace.QName;
import javax.xml.ws.WebFault;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.UnwrappedOperationInfo;

public class WebFaultInInterceptor
extends AbstractPhaseInterceptor<Message> {
    public WebFaultInInterceptor() {
        super("pre-logical");
    }

    @Override
    public void handleMessage(Message message) throws Fault {
        Exception ex = message.getContent(Exception.class);
        if (ex != null) {
            message.put(Message.RESPONSE_CODE, 500);
        }
        if (ex instanceof Fault) {
            Fault f = (Fault)ex;
            ex = (Exception)f.getCause();
        }
        if (ex == null) {
            return;
        }
        QName faultName = this.getFaultName(ex);
        if (faultName == null) {
            return;
        }
        BindingOperationInfo boi = message.getExchange().get(BindingOperationInfo.class);
        MessagePartInfo part = this.getFaultMessagePart(faultName, boi.getOperationInfo());
        if (part != null) {
            message.setContent(Exception.class, ex);
        }
    }

    private QName getFaultName(Exception webFault) {
        QName faultName = null;
        WebFault wf = webFault.getClass().getAnnotation(WebFault.class);
        if (wf != null) {
            faultName = new QName(wf.targetNamespace(), wf.name());
        }
        return faultName;
    }

    private MessagePartInfo getFaultMessagePart(QName qname, OperationInfo op) {
        if (op.isUnwrapped()) {
            op = ((UnwrappedOperationInfo)op).getWrappedOperation();
        }
        for (FaultInfo faultInfo : op.getFaults()) {
            for (MessagePartInfo mpi : faultInfo.getMessageParts()) {
                String ns = null;
                ns = mpi.isElement() ? mpi.getElementQName().getNamespaceURI() : mpi.getTypeQName().getNamespaceURI();
                if (!qname.getLocalPart().equals(mpi.getConcreteName().getLocalPart()) || !qname.getNamespaceURI().equals(ns)) continue;
                return mpi;
            }
        }
        return null;
    }
}

