/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyvalidators;

import java.util.Collection;
import java.util.List;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.security.transport.TLSSessionInfo;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.Layout;
import org.apache.cxf.ws.security.policy.model.TransportBinding;
import org.apache.cxf.ws.security.wss4j.policyvalidators.AbstractBindingPolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.AlgorithmSuitePolicyValidator;
import org.apache.ws.security.WSSecurityEngineResult;
import org.w3c.dom.Element;

public class TransportBindingPolicyValidator
extends AbstractBindingPolicyValidator {
    @Override
    public boolean validatePolicy(AssertionInfoMap aim, Message message, Element soapBody, List<WSSecurityEngineResult> results, List<WSSecurityEngineResult> signedResults, List<WSSecurityEngineResult> encryptedResults) {
        Collection ais = (Collection)aim.get(SP12Constants.TRANSPORT_BINDING);
        if (ais == null || ais.isEmpty()) {
            return true;
        }
        for (AssertionInfo ai : ais) {
            boolean timestampLast;
            AlgorithmSuitePolicyValidator algorithmValidator;
            TransportBinding binding = (TransportBinding)ai.getAssertion();
            ai.setAsserted(true);
            boolean initiator = MessageUtils.isRequestor(message);
            TLSSessionInfo tlsInfo = message.get(TLSSessionInfo.class);
            if (!initiator && tlsInfo == null) {
                ai.setNotAsserted("TLS is not enabled");
                return false;
            }
            if (binding.getTransportToken() != null) {
                this.assertPolicy(aim, binding.getTransportToken());
                this.assertPolicy(aim, binding.getTransportToken().getToken());
            }
            if (!(algorithmValidator = new AlgorithmSuitePolicyValidator(results)).validatePolicy(ai, binding.getAlgorithmSuite())) {
                return false;
            }
            if (!this.validateTimestamp(binding.isIncludeTimestamp(), true, results, signedResults, message)) {
                String error = "Received Timestamp does not match the requirements";
                this.notAssertPolicy(aim, SP12Constants.INCLUDE_TIMESTAMP, error);
                ai.setNotAsserted(error);
                return false;
            }
            this.assertPolicy(aim, SP12Constants.INCLUDE_TIMESTAMP);
            Layout layout = binding.getLayout();
            boolean timestampFirst = layout.getValue() == SPConstants.Layout.LaxTimestampFirst;
            boolean bl = timestampLast = layout.getValue() == SPConstants.Layout.LaxTimestampLast;
            if (!this.validateLayout(timestampFirst, timestampLast, results)) {
                String error = "Layout does not match the requirements";
                this.notAssertPolicy(aim, SP12Constants.LAYOUT, error);
                ai.setNotAsserted(error);
                return false;
            }
            this.assertPolicy(aim, SP12Constants.LAYOUT);
        }
        this.assertPolicy(aim, SP12Constants.ENCRYPTED_PARTS);
        this.assertPolicy(aim, SP12Constants.SIGNED_PARTS);
        return true;
    }
}

