/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyvalidators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.model.UsernameToken;
import org.apache.cxf.ws.security.wss4j.policyvalidators.AbstractTokenPolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.TokenPolicyValidator;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Element;

public class UsernameTokenPolicyValidator
extends AbstractTokenPolicyValidator
implements TokenPolicyValidator {
    @Override
    public boolean validatePolicy(AssertionInfoMap aim, Message message, Element soapBody, List<WSSecurityEngineResult> results, List<WSSecurityEngineResult> signedResults) {
        Collection ais = (Collection)aim.get(SP12Constants.USERNAME_TOKEN);
        if (ais == null || ais.isEmpty()) {
            return true;
        }
        ArrayList<WSSecurityEngineResult> utResults = new ArrayList<WSSecurityEngineResult>();
        WSSecurityUtil.fetchAllActionResults(results, (int)1, utResults);
        WSSecurityUtil.fetchAllActionResults(results, (int)8192, utResults);
        for (AssertionInfo ai : ais) {
            UsernameToken usernameTokenPolicy = (UsernameToken)ai.getAssertion();
            ai.setAsserted(true);
            if (!this.isTokenRequired(usernameTokenPolicy, message)) continue;
            if (utResults.isEmpty()) {
                ai.setNotAsserted("The received token does not match the token inclusion requirement");
                return false;
            }
            if (this.checkTokens(usernameTokenPolicy, ai, utResults)) continue;
            return false;
        }
        return true;
    }

    public boolean checkTokens(UsernameToken usernameTokenPolicy, AssertionInfo ai, List<WSSecurityEngineResult> utResults) {
        for (WSSecurityEngineResult result : utResults) {
            org.apache.ws.security.message.token.UsernameToken usernameToken = (org.apache.ws.security.message.token.UsernameToken)result.get((Object)"username-token");
            if (usernameTokenPolicy.isHashPassword() != usernameToken.isHashed()) {
                ai.setNotAsserted("Password hashing policy not enforced");
                return false;
            }
            if (usernameTokenPolicy.isNoPassword() && usernameToken.getPassword() != null) {
                ai.setNotAsserted("Username Token NoPassword policy not enforced");
                return false;
            }
            if (usernameTokenPolicy.isRequireCreated() && (usernameToken.getCreated() == null || usernameToken.isHashed())) {
                ai.setNotAsserted("Username Token Created policy not enforced");
                return false;
            }
            if (!usernameTokenPolicy.isRequireNonce() || usernameToken.getNonce() != null && !usernameToken.isHashed()) continue;
            ai.setNotAsserted("Username Token Nonce policy not enforced");
            return false;
        }
        return true;
    }
}

