/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type.xml;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.aegis.Context;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.type.AegisType;
import org.apache.cxf.aegis.xml.MessageReader;
import org.apache.cxf.aegis.xml.MessageWriter;
import org.apache.cxf.aegis.xml.stax.ElementReader;
import org.apache.cxf.aegis.xml.stax.ElementWriter;
import org.apache.cxf.staxutils.FragmentStreamReader;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DocumentType
extends AegisType {
    public DocumentType() {
        this.setWriteOuter(false);
    }

    @Override
    public Object readObject(MessageReader mreader, Context context) throws DatabindingException {
        try {
            XMLStreamReader reader = ((ElementReader)mreader).getXMLStreamReader();
            reader.nextTag();
            Document tree = StaxUtils.read(null, new FragmentStreamReader(reader), true);
            reader.nextTag();
            return tree;
        }
        catch (XMLStreamException e) {
            throw new DatabindingException("Could not parse xml.", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void writeObject(Object object, MessageWriter writer, Context context) throws DatabindingException {
        Document doc = (Document)object;
        try {
            Element docElement = doc.getDocumentElement();
            if (docElement == null) {
                if (!this.isNillable()) throw new DatabindingException("Could not write xml: null document element.");
                writer.writeXsiNil();
                return;
            } else {
                StaxUtils.writeElement(docElement, ((ElementWriter)writer).getXMLStreamWriter(), false);
            }
            return;
        }
        catch (XMLStreamException e) {
            throw new DatabindingException("Could not write xml.", (Throwable)e);
        }
    }
}

