/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.cxf.ws.rm.DestinationSequence;
import org.apache.cxf.ws.rm.SourceSequence;
import org.apache.cxf.ws.rm.v200702.AckRequestedType;
import org.apache.cxf.ws.rm.v200702.CloseSequenceType;
import org.apache.cxf.ws.rm.v200702.SequenceAcknowledgement;
import org.apache.cxf.ws.rm.v200702.SequenceType;

public class RMProperties {
    private SequenceType sequence;
    private Collection<SequenceAcknowledgement> acks;
    private Collection<AckRequestedType> acksRequested;
    private CloseSequenceType closeSequence;
    private String namespaceURI;
    private boolean lastMessage;

    public Collection<SequenceAcknowledgement> getAcks() {
        return this.acks;
    }

    public Collection<AckRequestedType> getAcksRequested() {
        return this.acksRequested;
    }

    public CloseSequenceType getCloseSequence() {
        return this.closeSequence;
    }

    public SequenceType getSequence() {
        return this.sequence;
    }

    public boolean isLastMessage() {
        return this.lastMessage;
    }

    public void setAcks(Collection<SequenceAcknowledgement> a) {
        this.acks = new CopyOnWriteArrayList<SequenceAcknowledgement>(a);
    }

    public void setAcksRequested(Collection<AckRequestedType> ar) {
        this.acksRequested = new CopyOnWriteArrayList<AckRequestedType>(ar);
    }

    public void setCloseSequence(CloseSequenceType cs) {
        this.closeSequence = cs;
    }

    public void setSequence(SequenceType s) {
        this.sequence = s;
    }

    public void setSequence(SourceSequence seq) {
        SequenceType s = new SequenceType();
        s.setIdentifier(seq.getIdentifier());
        s.setMessageNumber(seq.getCurrentMessageNr());
        this.setSequence(s);
        this.lastMessage = seq.isLastMessage();
    }

    public void addAck(DestinationSequence seq) {
        if (null == this.acks) {
            this.acks = new ArrayList<SequenceAcknowledgement>();
        }
        SequenceAcknowledgement ack = seq.getAcknowledgment();
        this.acks.add(ack);
        seq.acknowledgmentSent();
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public void exposeAs(String uri) {
        this.namespaceURI = uri;
    }
}

