/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.asyncclient;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509KeyManager;
import org.apache.cxf.Bus;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.jsse.SSLUtils;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CacheAndWriteOutputStream;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.io.CopyingOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.Headers;
import org.apache.cxf.transport.http.URLConnectionHTTPConduit;
import org.apache.cxf.transport.http.asyncclient.AsyncHTTPConduitFactory;
import org.apache.cxf.transport.http.asyncclient.CXFHttpAsyncRequestProducer;
import org.apache.cxf.transport.http.asyncclient.CXFHttpAsyncResponseConsumer;
import org.apache.cxf.transport.http.asyncclient.CXFHttpRequest;
import org.apache.cxf.transport.http.asyncclient.CXFResponseCallback;
import org.apache.cxf.transport.http.asyncclient.SharedInputBuffer;
import org.apache.cxf.transport.http.asyncclient.SharedOutputBuffer;
import org.apache.cxf.transport.https.AliasedX509ExtendedKeyManager;
import org.apache.cxf.transport.https.CertificateHostnameVerifier;
import org.apache.cxf.transport.https.HttpsURLConnectionInfo;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.version.Version;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.concurrent.BasicFuture;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.conn.params.ConnRouteParams;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.impl.nio.client.DefaultHttpAsyncClient;
import org.apache.http.nio.conn.scheme.AsyncScheme;
import org.apache.http.nio.conn.scheme.AsyncSchemeRegistry;
import org.apache.http.nio.conn.scheme.LayeringStrategy;
import org.apache.http.nio.conn.ssl.SSLLayeringStrategy;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class AsyncHTTPConduit
extends URLConnectionHTTPConduit {
    public static final String USE_ASYNC = "use.async.http.conduit";
    final AsyncHTTPConduitFactory factory;
    volatile int lastTlsHash = -1;
    volatile Object sslState;
    volatile SSLContext sslContext;
    volatile DefaultHttpAsyncClient client;

    public AsyncHTTPConduit(Bus b, EndpointInfo ei, EndpointReferenceType t, AsyncHTTPConduitFactory factory) throws IOException {
        super(b, ei, t);
        this.factory = factory;
    }

    public synchronized DefaultHttpAsyncClient getHttpAsyncClient() throws IOException {
        if (this.client == null) {
            this.client = this.factory.createClient(this);
        }
        return this.client;
    }

    public AsyncHTTPConduitFactory getAsyncHTTPConduitFactory() {
        return this.factory;
    }

    @Override
    protected void setupConnection(Message message, URI uri, HTTPClientPolicy csPolicy) throws IOException {
        if (this.factory.isShutdown()) {
            message.put(USE_ASYNC, Boolean.FALSE);
            super.setupConnection(message, uri, csPolicy);
            return;
        }
        String s = uri.getScheme();
        if (!"http".equals(s) && !"https".equals(s)) {
            throw new MalformedURLException("unknown protocol: " + s);
        }
        Object o = message.getContextualProperty(USE_ASYNC);
        if (o == null) {
            o = this.factory.getUseAsyncPolicy();
        }
        if (o instanceof AsyncHTTPConduitFactory.UseAsyncPolicy) {
            switch ((AsyncHTTPConduitFactory.UseAsyncPolicy)((Object)o)) {
                case ALWAYS: {
                    o = true;
                    break;
                }
                case NEVER: {
                    o = false;
                    break;
                }
                default: {
                    o = !message.getExchange().isSynchronous();
                }
            }
        }
        if (uri.getScheme().equals("https") && this.tlsClientParameters != null && this.tlsClientParameters.getSSLSocketFactory() != null) {
            o = false;
        }
        if (!MessageUtils.isTrue(o)) {
            message.put(USE_ASYNC, Boolean.FALSE);
            super.setupConnection(message, uri, csPolicy);
            return;
        }
        if (StringUtils.isEmpty(uri.getPath())) {
            uri = uri.resolve("/");
        }
        message.put(USE_ASYNC, Boolean.TRUE);
        message.put("http.scheme", uri.getScheme());
        String httpRequestMethod = (String)message.get("org.apache.cxf.request.method");
        if (httpRequestMethod == null) {
            httpRequestMethod = "POST";
            message.put("org.apache.cxf.request.method", httpRequestMethod);
        }
        final CXFHttpRequest e = new CXFHttpRequest(httpRequestMethod);
        BasicHttpEntity entity = new BasicHttpEntity(){

            public boolean isRepeatable() {
                return e.getOutputStream().retransmitable();
            }
        };
        entity.setChunked(true);
        entity.setContentType((String)message.get("Content-Type"));
        e.setURI(uri);
        e.setEntity((HttpEntity)entity);
        e.getParams().setParameter("http.socket.timeout", (Object)((int)csPolicy.getReceiveTimeout()));
        Proxy p = this.proxyFactory.createProxy(csPolicy, uri);
        if (p != null) {
            InetSocketAddress isa = (InetSocketAddress)p.address();
            HttpHost proxy = new HttpHost(isa.getHostName(), isa.getPort());
            ConnRouteParams.setDefaultProxy((HttpParams)e.getParams(), (HttpHost)proxy);
        }
        message.put(CXFHttpRequest.class, e);
    }

    @Override
    protected OutputStream createOutputStream(Message message, boolean needToCacheRequest, boolean isChunking, int chunkThreshold) throws IOException {
        if (Boolean.TRUE.equals(message.get(USE_ASYNC))) {
            CXFHttpRequest entity = message.get(CXFHttpRequest.class);
            AsyncWrappedOutputStream out = new AsyncWrappedOutputStream(message, needToCacheRequest, isChunking, chunkThreshold, this.getConduitName(), entity.getURI());
            entity.setOutputStream(out);
            return out;
        }
        return super.createOutputStream(message, needToCacheRequest, isChunking, chunkThreshold);
    }

    public synchronized SSLContext getSSLContext() throws GeneralSecurityException {
        int hash;
        TLSClientParameters tlsClientParameters = this.getTlsClientParameters();
        if (tlsClientParameters == null) {
            tlsClientParameters = new TLSClientParameters();
        }
        if ((hash = tlsClientParameters.hashCode()) == this.lastTlsHash) {
            return this.sslContext;
        }
        String provider = tlsClientParameters.getJsseProvider();
        String protocol = tlsClientParameters.getSecureSocketProtocol() != null ? tlsClientParameters.getSecureSocketProtocol() : "TLS";
        SSLContext ctx = provider == null ? SSLContext.getInstance(protocol) : SSLContext.getInstance(protocol, provider);
        ctx.getClientSessionContext().setSessionTimeout(tlsClientParameters.getSslCacheTimeout());
        KeyManager[] keyManagers = tlsClientParameters.getKeyManagers();
        if (tlsClientParameters.getCertAlias() != null) {
            keyManagers = AsyncHTTPConduit.getKeyManagersWithCertAlias(tlsClientParameters, keyManagers);
        }
        ctx.init(keyManagers, tlsClientParameters.getTrustManagers(), tlsClientParameters.getSecureRandom());
        this.sslContext = ctx;
        this.lastTlsHash = hash;
        this.sslState = null;
        return ctx;
    }

    public void initializeSSLEngine(SSLContext sslcontext, SSLEngine sslengine) {
        TLSClientParameters tlsClientParameters = this.getTlsClientParameters();
        if (tlsClientParameters == null) {
            tlsClientParameters = new TLSClientParameters();
        }
        String[] cipherSuites = SSLUtils.getCiphersuites(tlsClientParameters.getCipherSuites(), SSLUtils.getSupportedCipherSuites(sslcontext), tlsClientParameters.getCipherSuitesFilter(), LOG, false);
        sslengine.setEnabledCipherSuites(cipherSuites);
    }

    protected static KeyManager[] getKeyManagersWithCertAlias(TLSClientParameters tlsClientParameters, KeyManager[] keyManagers) throws GeneralSecurityException {
        if (tlsClientParameters.getCertAlias() != null) {
            KeyManager[] ret = new KeyManager[keyManagers.length];
            for (int idx = 0; idx < keyManagers.length; ++idx) {
                if (keyManagers[idx] instanceof X509KeyManager) {
                    try {
                        ret[idx] = new AliasedX509ExtendedKeyManager(tlsClientParameters.getCertAlias(), (X509KeyManager)keyManagers[idx]);
                        continue;
                    }
                    catch (Exception e) {
                        throw new GeneralSecurityException(e);
                    }
                }
                ret[idx] = keyManagers[idx];
            }
            return ret;
        }
        return keyManagers;
    }

    public class AsyncWrappedOutputStream
    extends HTTPConduit.WrappedOutputStream
    implements CopyingOutputStream,
    WritableByteChannel {
        final HTTPClientPolicy csPolicy;
        CXFHttpRequest entity;
        BasicHttpEntity basicEntity;
        boolean isAsync;
        SharedInputBuffer inbuf;
        SharedOutputBuffer outbuf;
        volatile HttpResponse httpResponse;
        volatile Exception exception;
        volatile SSLSession session;
        private Future<Boolean> connectionFuture;
        private Object sessionLock;

        public AsyncWrappedOutputStream(Message message, boolean needToCacheRequest, boolean isChunking, int chunkThreshold, String conduitName, URI uri) {
            super(message, needToCacheRequest, isChunking, chunkThreshold, conduitName, uri);
            this.sessionLock = new Object();
            this.csPolicy = AsyncHTTPConduit.this.getClient(message);
            this.entity = message.get(CXFHttpRequest.class);
            this.basicEntity = (BasicHttpEntity)this.entity.getEntity();
            this.basicEntity.setChunked(isChunking);
            HeapByteBufferAllocator allocator = new HeapByteBufferAllocator();
            int bufSize = this.csPolicy.getChunkLength() > 0 ? this.csPolicy.getChunkLength() : 16320;
            this.inbuf = new SharedInputBuffer(bufSize, (ByteBufferAllocator)allocator);
            this.outbuf = new SharedOutputBuffer(bufSize, (ByteBufferAllocator)allocator);
        }

        public boolean retransmitable() {
            return this.cachedStream != null;
        }

        public CachedOutputStream getCachedStream() {
            return this.cachedStream;
        }

        @Override
        protected void setProtocolHeaders() throws IOException {
            Headers h = new Headers(this.outMessage);
            this.basicEntity.setContentType(h.determineContentType());
            boolean addHeaders = MessageUtils.isTrue(this.outMessage.getContextualProperty("org.apache.cxf.http.add-headers"));
            for (Map.Entry<String, List<String>> header : h.headerMap().entrySet()) {
                if ("Content-Type".equalsIgnoreCase(header.getKey())) continue;
                if (addHeaders || "Cookie".equalsIgnoreCase(header.getKey())) {
                    for (String s : header.getValue()) {
                        this.entity.addHeader("Cookie", s);
                    }
                } else if (!"Content-Length".equalsIgnoreCase(header.getKey())) {
                    StringBuilder b = new StringBuilder();
                    for (int i = 0; i < header.getValue().size(); ++i) {
                        b.append(header.getValue().get(i));
                        if (i + 1 >= header.getValue().size()) continue;
                        b.append(',');
                    }
                    this.entity.setHeader(header.getKey(), b.toString());
                }
                if (this.entity.containsHeader("User-Agent")) continue;
                this.entity.setHeader("User-Agent", Version.getCompleteVersionString());
            }
        }

        @Override
        protected void setFixedLengthStreamingMode(int i) {
            this.basicEntity.setChunked(false);
            this.basicEntity.setContentLength((long)i);
        }

        @Override
        public void thresholdReached() throws IOException {
            this.basicEntity.setChunked(this.chunking);
        }

        @Override
        protected void handleNoOutput() throws IOException {
            this.connect(false);
            this.outbuf.writeCompleted();
        }

        @Override
        public boolean isOpen() {
            return true;
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            int total = 0;
            if (this.buffer != null) {
                int pos = this.buffer.size();
                int len = this.threshold - pos;
                if (len > src.remaining()) {
                    len = src.remaining();
                }
                src.get(this.buffer.getRawBytes(), pos, len);
                this.buffer.setSize(this.buffer.size() + len);
                total += len;
                if (this.buffer.size() >= this.threshold) {
                    this.thresholdReached();
                    this.unBuffer();
                }
            }
            if (this.cachingForRetransmission) {
                this.wrappedStream.write(src.array(), src.position(), src.remaining());
                return src.remaining() + total;
            }
            return this.outbuf.write(src) + total;
        }

        @Override
        public int copyFrom(InputStream in) throws IOException {
            int count = 0;
            while (this.buffer != null) {
                int pos = this.buffer.size();
                int i = in.read(this.buffer.getRawBytes(), pos, this.threshold - pos);
                if (i > 0) {
                    this.buffer.setSize(pos + i);
                    if (this.buffer.size() >= this.threshold) {
                        this.thresholdReached();
                        this.unBuffer();
                    }
                    count += i;
                    continue;
                }
                return count;
            }
            count = this.cachingForRetransmission ? (count += IOUtils.copy(in, this.wrappedStream)) : (count += this.outbuf.copy(in));
            return count;
        }

        @Override
        public void close() throws IOException {
            if (!this.chunking && this.wrappedStream != null) {
                CachedOutputStream out = (CachedOutputStream)this.wrappedStream;
                this.basicEntity.setContentLength(out.size());
                this.wrappedStream = null;
                this.handleHeadersTrustCaching();
                out.writeCacheTo(this.wrappedStream);
            }
            super.close();
        }

        @Override
        protected void onFirstWrite() throws IOException {
            if (this.chunking) {
                super.onFirstWrite();
            } else {
                this.wrappedStream = new CachedOutputStream();
            }
        }

        @Override
        protected void setupWrappedStream() throws IOException {
            this.connect(true);
            this.wrappedStream = new OutputStream(){

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    AsyncWrappedOutputStream.this.outbuf.write(b, off, len);
                }

                @Override
                public void write(int b) throws IOException {
                    AsyncWrappedOutputStream.this.outbuf.write(b);
                }

                @Override
                public void close() throws IOException {
                    AsyncWrappedOutputStream.this.outbuf.writeCompleted();
                }
            };
            if (this.cachingForRetransmission) {
                this.cachedStream = new CacheAndWriteOutputStream(this.wrappedStream);
                this.wrappedStream = this.cachedStream;
            }
        }

        protected void connect(boolean output) throws IOException {
            if (this.connectionFuture != null) {
                return;
            }
            CXFResponseCallback responseCallback = new CXFResponseCallback(){

                @Override
                public void responseReceived(HttpResponse response) {
                    AsyncWrappedOutputStream.this.setHttpResponse(response);
                }
            };
            FutureCallback<Boolean> callback = new FutureCallback<Boolean>(){

                public void completed(Boolean result) {
                }

                public void failed(Exception ex) {
                    AsyncWrappedOutputStream.this.setException(ex);
                    AsyncWrappedOutputStream.this.inbuf.shutdown();
                    AsyncWrappedOutputStream.this.outbuf.shutdown();
                }

                public void cancelled() {
                    AsyncWrappedOutputStream.this.inbuf.shutdown();
                    AsyncWrappedOutputStream.this.outbuf.shutdown();
                }
            };
            if (!output) {
                this.entity.removeHeaders("Transfer-Encoding");
                this.entity.removeHeaders("Content-Type");
                this.entity.setEntity(null);
            }
            if (this.url.getScheme().equals("https") && AsyncHTTPConduit.this.tlsClientParameters == null) {
                AsyncHTTPConduit.this.tlsClientParameters = new TLSClientParameters();
            }
            BasicHttpContext ctx = new BasicHttpContext();
            if (AsyncHTTPConduit.this.proxyAuthorizationPolicy != null && AsyncHTTPConduit.this.proxyAuthorizationPolicy.getUserName() != null) {
                ctx.setAttribute("http.auth.credentials-provider", (Object)new CredentialsProvider(){

                    public void setCredentials(AuthScope authscope, Credentials credentials) {
                    }

                    public Credentials getCredentials(AuthScope authscope) {
                        return new UsernamePasswordCredentials(AsyncHTTPConduit.this.proxyAuthorizationPolicy.getUserName(), AsyncHTTPConduit.this.proxyAuthorizationPolicy.getPassword());
                    }

                    public void clear() {
                    }
                });
            }
            if (AsyncHTTPConduit.this.tlsClientParameters != null && AsyncHTTPConduit.this.tlsClientParameters.hashCode() == AsyncHTTPConduit.this.lastTlsHash && AsyncHTTPConduit.this.sslState != null) {
                ctx.setAttribute("http.user-token", AsyncHTTPConduit.this.sslState);
            }
            AsyncSchemeRegistry reg = new AsyncSchemeRegistry();
            reg.register(new AsyncScheme("http", 80, null));
            if ("https".equals(this.url.getScheme())) {
                try {
                    final SSLContext sslcontext = AsyncHTTPConduit.this.getSSLContext();
                    reg.register(new AsyncScheme("https", 443, (LayeringStrategy)new SSLLayeringStrategy(sslcontext){

                        protected void initializeEngine(SSLEngine engine) {
                            AsyncHTTPConduit.this.initializeSSLEngine(sslcontext, engine);
                        }

                        protected void verifySession(IOSession iosession, SSLSession sslsession) throws SSLException {
                            super.verifySession(iosession, sslsession);
                            iosession.setAttribute("cxf.handshake.done", (Object)Boolean.TRUE);
                            CXFHttpRequest req = (CXFHttpRequest)((Object)iosession.removeAttribute(CXFHttpRequest.class.getName()));
                            if (req != null) {
                                req.getOutputStream().setSSLSession(sslsession);
                            }
                        }
                    }));
                }
                catch (GeneralSecurityException e) {
                    e.printStackTrace();
                }
            }
            ctx.setAttribute("http.scheme-registry", (Object)reg);
            this.connectionFuture = new BasicFuture((FutureCallback)callback);
            DefaultHttpAsyncClient c = AsyncHTTPConduit.this.getHttpAsyncClient();
            CredentialsProvider credProvider = c.getCredentialsProvider();
            Credentials creds = (Credentials)this.outMessage.getContextualProperty(Credentials.class.getName());
            if (creds != null && credProvider != null) {
                credProvider.setCredentials(AuthScope.ANY, creds);
            }
            if (credProvider != null && credProvider.getCredentials(AuthScope.ANY) != null) {
                ctx.setAttribute("http.user-token", (Object)credProvider.getCredentials(AuthScope.ANY).getUserPrincipal());
            }
            c.execute((HttpAsyncRequestProducer)new CXFHttpAsyncRequestProducer(this.entity, this.outbuf), (HttpAsyncResponseConsumer)new CXFHttpAsyncResponseConsumer(this, this.inbuf, responseCallback), (HttpContext)ctx, (FutureCallback)callback);
        }

        protected void retrySetHttpResponse(HttpResponse r) {
            if (this.httpResponse == null && this.isAsync) {
                this.setHttpResponse(r);
            }
        }

        protected synchronized void setHttpResponse(HttpResponse r) {
            this.httpResponse = r;
            if (this.isAsync) {
                try {
                    this.handleResponseOnWorkqueue(false, true);
                    this.isAsync = false;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.notifyAll();
        }

        protected synchronized void setException(Exception ex) {
            this.exception = ex;
            if (this.isAsync) {
                try {
                    this.handleResponseOnWorkqueue(false, true);
                    this.isAsync = false;
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            this.notifyAll();
        }

        protected synchronized HttpResponse getHttpResponse() throws IOException {
            while (this.httpResponse == null) {
                if (this.exception == null) {
                    try {
                        this.wait(this.csPolicy.getReceiveTimeout());
                    }
                    catch (InterruptedException e) {
                        throw new IOException(e);
                    }
                }
                if (this.httpResponse != null) continue;
                this.outbuf.shutdown();
                this.inbuf.shutdown();
                if (this.exception != null) {
                    if (this.exception instanceof IOException) {
                        throw (IOException)this.exception;
                    }
                    if (this.exception instanceof RuntimeException) {
                        throw (RuntimeException)this.exception;
                    }
                    throw new IOException(this.exception);
                }
                throw new SocketTimeoutException("Read Timeout");
            }
            return this.httpResponse;
        }

        @Override
        protected void handleResponseAsync() throws IOException {
            this.isAsync = true;
        }

        @Override
        protected void closeInputStream() throws IOException {
            byte[] bytes = new byte[1024];
            while (this.inbuf.read(bytes) > 0) {
            }
            this.inbuf.close();
            this.inbuf.shutdown();
        }

        @Override
        protected synchronized InputStream getInputStream() throws IOException {
            return new InputStream(){

                @Override
                public int read() throws IOException {
                    return AsyncWrappedOutputStream.this.inbuf.read();
                }

                @Override
                public int read(byte[] b) throws IOException {
                    return AsyncWrappedOutputStream.this.inbuf.read(b);
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    return AsyncWrappedOutputStream.this.inbuf.read(b, off, len);
                }

                @Override
                public int available() throws IOException {
                    return AsyncWrappedOutputStream.this.inbuf.available();
                }

                @Override
                public void close() throws IOException {
                    AsyncWrappedOutputStream.this.inbuf.close();
                }
            };
        }

        @Override
        protected boolean usingProxy() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected HttpsURLConnectionInfo getHttpsURLConnectionInfo() throws IOException {
            if ("http".equals(this.outMessage.get("http.scheme"))) {
                return null;
            }
            this.connect(true);
            Object object = this.sessionLock;
            synchronized (object) {
                if (this.session == null) {
                    try {
                        this.sessionLock.wait(this.csPolicy.getConnectionTimeout());
                    }
                    catch (InterruptedException e) {
                        throw new IOException(e);
                    }
                }
                if (this.session == null) {
                    throw new IOException("No SSLSession detected");
                }
            }
            HostnameVerifier verifier = AsyncHTTPConduit.this.tlsClientParameters.isUseHttpsURLConnectionDefaultHostnameVerifier() ? HttpsURLConnection.getDefaultHostnameVerifier() : (AsyncHTTPConduit.this.tlsClientParameters.isDisableCNCheck() ? CertificateHostnameVerifier.ALLOW_ALL : CertificateHostnameVerifier.DEFAULT);
            if (!verifier.verify(this.url.getHost(), this.session)) {
                throw new IOException("Could not verify host " + this.url.getHost());
            }
            String method = (String)this.outMessage.get("org.apache.cxf.request.method");
            String cipherSuite = null;
            Certificate[] localCerts = null;
            Principal principal = null;
            Certificate[] serverCerts = null;
            Principal peer = null;
            if (this.session != null) {
                cipherSuite = this.session.getCipherSuite();
                localCerts = this.session.getLocalCertificates();
                principal = this.session.getLocalPrincipal();
                serverCerts = this.session.getPeerCertificates();
                peer = this.session.getPeerPrincipal();
            }
            return new HttpsURLConnectionInfo(this.url, method, cipherSuite, localCerts, principal, serverCerts, peer);
        }

        @Override
        protected int getResponseCode() throws IOException {
            return this.getHttpResponse().getStatusLine().getStatusCode();
        }

        @Override
        protected String getResponseMessage() throws IOException {
            return this.getHttpResponse().getStatusLine().getReasonPhrase();
        }

        private String readHeaders(Headers h) throws IOException {
            Header[] headers = this.getHttpResponse().getAllHeaders();
            h.headerMap().clear();
            String ct = null;
            for (Header header : headers) {
                List<String> s = h.headerMap().get(header.getName());
                if (s == null) {
                    s = new ArrayList<String>(1);
                    h.headerMap().put(header.getName(), s);
                }
                s.add(header.getValue());
                if (!"Content-Type".equalsIgnoreCase(header.getName())) continue;
                ct = header.getValue();
            }
            return ct;
        }

        @Override
        protected void updateResponseHeaders(Message inMessage) throws IOException {
            Headers h = new Headers(inMessage);
            inMessage.put("Content-Type", this.readHeaders(h));
            AsyncHTTPConduit.this.cookies.readFromHeaders(h);
        }

        @Override
        protected InputStream getPartialResponse() throws IOException {
            InputStream in = null;
            int responseCode = this.getResponseCode();
            if (responseCode == 202 || responseCode == 200) {
                boolean isEofTerminated;
                Header head = this.httpResponse.getFirstHeader("Content-Length");
                int cli = 0;
                if (head != null) {
                    cli = Integer.parseInt(head.getValue());
                }
                boolean isChunked = (head = this.httpResponse.getFirstHeader("Transfer-Encoding")) != null && "chunked".equalsIgnoreCase(head.getValue());
                head = this.httpResponse.getFirstHeader("Connection");
                boolean bl = isEofTerminated = head != null && "close".equalsIgnoreCase(head.getValue());
                if (cli > 0) {
                    in = this.getInputStream();
                } else if (isChunked || isEofTerminated) {
                    try {
                        PushbackInputStream pin = new PushbackInputStream(this.getInputStream());
                        int c = pin.read();
                        if (c != -1) {
                            pin.unread((byte)c);
                            in = pin;
                        }
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
            }
            return in;
        }

        @Override
        protected void updateCookiesBeforeRetransmit() throws IOException {
            Headers h = new Headers();
            this.readHeaders(h);
            AsyncHTTPConduit.this.cookies.readFromHeaders(h);
        }

        @Override
        protected boolean authorizationRetransmit() throws IOException {
            boolean b = super.authorizationRetransmit();
            if (!b) {
                try {
                    this.closeInputStream();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                AsyncHTTPConduit.this.cookies.writeToMessageHeaders(this.outMessage);
                this.retransmit(this.url.toString());
                return true;
            }
            return b;
        }

        @Override
        protected void retransmitStream() throws IOException {
            this.cachingForRetransmission = false;
            this.setupWrappedStream();
            this.cachedStream.writeCacheTo(this.wrappedStream);
            this.wrappedStream.flush();
            this.wrappedStream.close();
        }

        @Override
        protected void setupNewConnection(String newURL) throws IOException {
            this.httpResponse = null;
            this.isAsync = false;
            this.exception = null;
            this.connectionFuture = null;
            this.session = null;
            HeapByteBufferAllocator allocator = new HeapByteBufferAllocator();
            int bufSize = this.csPolicy.getChunkLength() > 0 ? this.csPolicy.getChunkLength() : 16320;
            this.inbuf = new SharedInputBuffer(bufSize, (ByteBufferAllocator)allocator);
            this.outbuf = new SharedOutputBuffer(bufSize, (ByteBufferAllocator)allocator);
            try {
                this.url = new URI(newURL);
                AsyncHTTPConduit.this.setupConnection(this.outMessage, this.url, this.csPolicy);
                this.entity = this.outMessage.get(CXFHttpRequest.class);
                this.basicEntity = (BasicHttpEntity)this.entity.getEntity();
                this.entity.setOutputStream(this);
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSSLSession(SSLSession sslsession) {
            this.session = sslsession;
            Object object = this.sessionLock;
            synchronized (object) {
                AsyncHTTPConduit.this.sslState = sslsession.getLocalPrincipal();
                this.sessionLock.notifyAll();
            }
        }
    }
}

