/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.counters;

import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.FaultMode;

public class MessageHandlingTimeRecorder {
    private Exchange exchange;
    private long beginTime;
    private long endTime;
    private FaultMode faultMode;
    private boolean oneWay;

    public MessageHandlingTimeRecorder(Exchange ex) {
        this.exchange = ex;
        this.exchange.put(MessageHandlingTimeRecorder.class, this);
    }

    public boolean isOneWay() {
        return this.oneWay;
    }

    public void setOneWay(boolean ow) {
        this.oneWay = ow;
    }

    public Exchange getHandleExchange() {
        return this.exchange;
    }

    public void beginHandling() {
        this.beginTime = System.nanoTime() / 1000L;
    }

    public void endHandling() {
        this.endTime = System.nanoTime() / 1000L;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getHandlingTime() {
        return this.endTime - this.beginTime;
    }

    public FaultMode getFaultMode() {
        return this.faultMode;
    }

    public void setFaultMode(FaultMode faultMode) {
        this.faultMode = faultMode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MessageHandlingTimeRecorder@").append(Integer.toHexString(this.hashCode())).append("[");
        sb.append("beginTime: ").append(this.beginTime).append(", ");
        sb.append("endTime: ").append(this.endTime).append(", ");
        sb.append("faultMode: ").append((Object)this.faultMode).append("]");
        return sb.toString();
    }
}

