/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.interceptors;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.security.transport.TLSSessionInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.MessageTrustDecider;
import org.apache.cxf.transport.http.URLConnectionInfo;
import org.apache.cxf.transport.http.UntrustedURLConnectionIOException;
import org.apache.cxf.transport.https.HttpsURLConnectionInfo;
import org.apache.cxf.ws.policy.AbstractPolicyInterceptorProvider;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.policy.PolicyException;
import org.apache.cxf.ws.security.policy.interceptors.NegotiationUtils;
import org.apache.neethi.Assertion;
import org.apache.wss4j.policy.SP11Constants;
import org.apache.wss4j.policy.SP12Constants;
import org.apache.wss4j.policy.model.HttpsToken;
import org.apache.wss4j.stax.impl.securityToken.HttpsSecurityTokenImpl;
import org.apache.wss4j.stax.securityEvent.HttpsTokenSecurityEvent;
import org.apache.wss4j.stax.securityToken.WSSecurityTokenConstants;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.stax.securityEvent.SecurityEvent;
import org.apache.xml.security.stax.securityToken.SecurityToken;

public class HttpsTokenInterceptorProvider
extends AbstractPolicyInterceptorProvider {
    private static final Logger LOG = LogUtils.getL7dLogger(HttpsTokenInterceptorProvider.class);
    private static final long serialVersionUID = -13951002554477036L;

    public HttpsTokenInterceptorProvider() {
        super(Arrays.asList(SP11Constants.TRANSPORT_TOKEN, SP12Constants.TRANSPORT_TOKEN, SP11Constants.ISSUED_TOKEN, SP12Constants.ISSUED_TOKEN, SP11Constants.HTTPS_TOKEN, SP12Constants.HTTPS_TOKEN));
        this.getOutInterceptors().add(new HttpsTokenOutInterceptor());
        this.getOutFaultInterceptors().add(new HttpsTokenOutInterceptor());
        this.getInInterceptors().add(new HttpsTokenInInterceptor());
        this.getInFaultInterceptors().add(new HttpsTokenInInterceptor());
    }

    private static Map<String, List<String>> getSetProtocolHeaders(Message message) {
        Map<String, List<String>> headers = CastUtils.cast((Map)message.get(Message.PROTOCOL_HEADERS));
        if (null == headers) {
            headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            message.put(Message.PROTOCOL_HEADERS, headers);
        }
        return headers;
    }

    @Override
    public boolean configurationPresent(Message msg, Assertion assertion) {
        if (msg == null || !MessageUtils.isRequestor(msg) || !SP11Constants.HTTPS_TOKEN.equals(assertion.getName())) {
            return true;
        }
        HttpsToken token = (HttpsToken)assertion;
        if (token.getAuthenticationType() == HttpsToken.AuthenticationType.HttpBasicAuthentication || token.getAuthenticationType() == HttpsToken.AuthenticationType.HttpDigestAuthentication) {
            try {
                return this.tryAuth(msg);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return true;
    }

    private boolean tryAuth(Message msg) {
        Conduit conduit = msg.getExchange().getConduit(msg);
        AuthorizationPolicy p = ((HTTPConduit)conduit).getEffectiveAuthPolicy(msg);
        return !StringUtils.isEmpty(p.getUserName());
    }

    static class HttpsTokenInInterceptor
    extends AbstractPhaseInterceptor<Message> {
        public HttpsTokenInInterceptor() {
            super("pre-stream");
        }

        @Override
        public void handleMessage(Message message) throws Fault {
            AssertionInfoMap aim = message.get(AssertionInfoMap.class);
            if (aim != null) {
                Collection<AssertionInfo> ais = NegotiationUtils.getAllAssertionsByLocalname(aim, "HttpsToken");
                boolean requestor = this.isRequestor(message);
                if (ais.isEmpty()) {
                    if (!requestor) {
                        try {
                            this.assertNonHttpsTransportToken(message);
                        }
                        catch (XMLSecurityException e) {
                            LOG.fine(e.getMessage());
                        }
                    }
                    return;
                }
                if (!requestor) {
                    TLSSessionInfo tlsInfo;
                    try {
                        this.assertHttps(aim, ais, message);
                    }
                    catch (XMLSecurityException e) {
                        LOG.fine(e.getMessage());
                    }
                    SecurityContext sc = message.get(SecurityContext.class);
                    if ((sc == null || sc.getUserPrincipal() == null) && (tlsInfo = message.get(TLSSessionInfo.class)) != null && tlsInfo.getPeerCertificates() != null && tlsInfo.getPeerCertificates().length > 0 && tlsInfo.getPeerCertificates()[0] instanceof X509Certificate) {
                        X509Certificate cert = (X509Certificate)tlsInfo.getPeerCertificates()[0];
                        message.put(SecurityContext.class, this.createSecurityContext(cert.getSubjectX500Principal()));
                    }
                } else {
                    for (AssertionInfo ai : ais) {
                        ai.setAsserted(true);
                    }
                    NegotiationUtils.assertPolicy(aim, "HttpDigestAuthentication");
                    NegotiationUtils.assertPolicy(aim, "HttpBasicAuthentication");
                    NegotiationUtils.assertPolicy(aim, "RequireClientCertificate");
                }
            }
        }

        private void assertHttps(AssertionInfoMap aim, Collection<AssertionInfo> ais, Message message) throws XMLSecurityException {
            List<SecurityEvent> securityEvents = this.getSecurityEventList(message);
            AuthorizationPolicy policy = message.get(AuthorizationPolicy.class);
            for (AssertionInfo ai : ais) {
                TLSSessionInfo tlsInfo;
                HttpsSecurityTokenImpl httpsSecurityToken;
                List auth;
                boolean asserted = true;
                HttpsToken token = (HttpsToken)ai.getAssertion();
                HttpsTokenSecurityEvent httpsTokenSecurityEvent = new HttpsTokenSecurityEvent();
                Map headers = HttpsTokenInterceptorProvider.getSetProtocolHeaders(message);
                if (token.getAuthenticationType() == HttpsToken.AuthenticationType.HttpBasicAuthentication) {
                    auth = (List)headers.get("Authorization");
                    if (auth == null || auth.size() == 0 || !((String)auth.get(0)).startsWith("Basic")) {
                        asserted = false;
                    } else {
                        httpsTokenSecurityEvent.setAuthenticationType(HttpsTokenSecurityEvent.AuthenticationType.HttpBasicAuthentication);
                        httpsSecurityToken = new HttpsSecurityTokenImpl(true, policy.getUserName());
                        httpsSecurityToken.addTokenUsage(WSSecurityTokenConstants.TokenUsage_MainSignature);
                        httpsTokenSecurityEvent.setSecurityToken((SecurityToken)httpsSecurityToken);
                        NegotiationUtils.assertPolicy(aim, "HttpBasicAuthentication");
                    }
                }
                if (token.getAuthenticationType() == HttpsToken.AuthenticationType.HttpDigestAuthentication) {
                    auth = (List)headers.get("Authorization");
                    if (auth == null || auth.size() == 0 || !((String)auth.get(0)).startsWith("Digest")) {
                        asserted = false;
                    } else {
                        httpsTokenSecurityEvent.setAuthenticationType(HttpsTokenSecurityEvent.AuthenticationType.HttpDigestAuthentication);
                        httpsSecurityToken = new HttpsSecurityTokenImpl(false, policy.getUserName());
                        httpsSecurityToken.addTokenUsage(WSSecurityTokenConstants.TokenUsage_MainSignature);
                        httpsTokenSecurityEvent.setSecurityToken((SecurityToken)httpsSecurityToken);
                        NegotiationUtils.assertPolicy(aim, "HttpDigestAuthentication");
                    }
                }
                if ((tlsInfo = message.get(TLSSessionInfo.class)) != null) {
                    if (token.getAuthenticationType() == HttpsToken.AuthenticationType.RequireClientCertificate) {
                        if (tlsInfo.getPeerCertificates() == null || tlsInfo.getPeerCertificates().length == 0) {
                            asserted = false;
                        } else {
                            NegotiationUtils.assertPolicy(aim, "RequireClientCertificate");
                        }
                    }
                    if (tlsInfo.getPeerCertificates() != null && tlsInfo.getPeerCertificates().length > 0) {
                        httpsTokenSecurityEvent.setAuthenticationType(HttpsTokenSecurityEvent.AuthenticationType.HttpsClientCertificateAuthentication);
                        httpsSecurityToken = new HttpsSecurityTokenImpl((X509Certificate)tlsInfo.getPeerCertificates()[0]);
                        httpsSecurityToken.addTokenUsage(WSSecurityTokenConstants.TokenUsage_MainSignature);
                        httpsTokenSecurityEvent.setSecurityToken((SecurityToken)httpsSecurityToken);
                    } else if (httpsTokenSecurityEvent.getAuthenticationType() == null) {
                        httpsTokenSecurityEvent.setAuthenticationType(HttpsTokenSecurityEvent.AuthenticationType.HttpsNoAuthentication);
                        httpsSecurityToken = new HttpsSecurityTokenImpl();
                        httpsSecurityToken.addTokenUsage(WSSecurityTokenConstants.TokenUsage_MainSignature);
                        httpsTokenSecurityEvent.setSecurityToken((SecurityToken)httpsSecurityToken);
                    }
                } else {
                    asserted = false;
                }
                ai.setAsserted(asserted);
                if (!asserted) continue;
                securityEvents.add((SecurityEvent)httpsTokenSecurityEvent);
            }
        }

        private void assertNonHttpsTransportToken(Message message) throws XMLSecurityException {
            TLSSessionInfo tlsInfo = message.get(TLSSessionInfo.class);
            if (tlsInfo != null) {
                HttpsSecurityTokenImpl httpsSecurityToken;
                HttpsTokenSecurityEvent httpsTokenSecurityEvent = new HttpsTokenSecurityEvent();
                if (tlsInfo.getPeerCertificates() != null && tlsInfo.getPeerCertificates().length > 0) {
                    httpsTokenSecurityEvent.setAuthenticationType(HttpsTokenSecurityEvent.AuthenticationType.HttpsClientCertificateAuthentication);
                    httpsSecurityToken = new HttpsSecurityTokenImpl((X509Certificate)tlsInfo.getPeerCertificates()[0]);
                    httpsSecurityToken.addTokenUsage(WSSecurityTokenConstants.TokenUsage_MainSignature);
                    httpsTokenSecurityEvent.setSecurityToken((SecurityToken)httpsSecurityToken);
                } else if (httpsTokenSecurityEvent.getAuthenticationType() == null) {
                    httpsTokenSecurityEvent.setAuthenticationType(HttpsTokenSecurityEvent.AuthenticationType.HttpsNoAuthentication);
                    httpsSecurityToken = new HttpsSecurityTokenImpl();
                    httpsSecurityToken.addTokenUsage(WSSecurityTokenConstants.TokenUsage_MainSignature);
                    httpsTokenSecurityEvent.setSecurityToken((SecurityToken)httpsSecurityToken);
                }
                List<SecurityEvent> securityEvents = this.getSecurityEventList(message);
                securityEvents.add((SecurityEvent)httpsTokenSecurityEvent);
            }
        }

        private List<SecurityEvent> getSecurityEventList(Message message) {
            ArrayList securityEvents = (ArrayList)message.getExchange().get(SecurityEvent.class.getName() + ".out");
            if (securityEvents == null) {
                securityEvents = new ArrayList();
                message.getExchange().put(SecurityEvent.class.getName() + ".out", securityEvents);
            }
            return securityEvents;
        }

        private SecurityContext createSecurityContext(final Principal p) {
            return new SecurityContext(){

                @Override
                public Principal getUserPrincipal() {
                    return p;
                }

                @Override
                public boolean isUserInRole(String role) {
                    return false;
                }
            };
        }
    }

    static class HttpsTokenOutInterceptor
    extends AbstractPhaseInterceptor<Message> {
        public HttpsTokenOutInterceptor() {
            super("pre-stream");
        }

        @Override
        public void handleMessage(Message message) throws Fault {
            AssertionInfoMap aim = message.get(AssertionInfoMap.class);
            if (aim != null) {
                Collection<AssertionInfo> ais = NegotiationUtils.getAllAssertionsByLocalname(aim, "HttpsToken");
                if (ais.isEmpty()) {
                    return;
                }
                if (this.isRequestor(message)) {
                    this.assertHttps(aim, ais, message);
                } else {
                    for (AssertionInfo ai : ais) {
                        ai.setAsserted(true);
                    }
                }
            }
        }

        private void assertHttps(AssertionInfoMap aim, Collection<AssertionInfo> ais, Message message) {
            for (AssertionInfo ai : ais) {
                HttpsToken token = (HttpsToken)ai.getAssertion();
                String scheme = (String)message.get("http.scheme");
                ai.setAsserted(true);
                Map headers = HttpsTokenInterceptorProvider.getSetProtocolHeaders(message);
                if ("https".equals(scheme)) {
                    List auth;
                    if (token.getAuthenticationType() == HttpsToken.AuthenticationType.RequireClientCertificate) {
                        final MessageTrustDecider orig = message.get(MessageTrustDecider.class);
                        MessageTrustDecider trust = new MessageTrustDecider(){

                            @Override
                            public void establishTrust(String conduitName, URLConnectionInfo connectionInfo, Message message) throws UntrustedURLConnectionIOException {
                                HttpsURLConnectionInfo info;
                                if (orig != null) {
                                    orig.establishTrust(conduitName, connectionInfo, message);
                                }
                                if ((info = (HttpsURLConnectionInfo)connectionInfo).getLocalCertificates() == null || info.getLocalCertificates().length == 0) {
                                    throw new UntrustedURLConnectionIOException("RequireClientCertificate is set, but no local certificates were negotiated.  Is the server set to ask for client authorization?");
                                }
                            }
                        };
                        message.put(MessageTrustDecider.class, trust);
                        NegotiationUtils.assertPolicy(aim, "RequireClientCertificate");
                    }
                    if (token.getAuthenticationType() == HttpsToken.AuthenticationType.HttpBasicAuthentication) {
                        auth = (List)headers.get("Authorization");
                        if (auth == null || auth.size() == 0 || !((String)auth.get(0)).startsWith("Basic")) {
                            ai.setNotAsserted("HttpBasicAuthentication is set, but not being used");
                        } else {
                            NegotiationUtils.assertPolicy(aim, "HttpBasicAuthentication");
                        }
                    }
                    if (token.getAuthenticationType() == HttpsToken.AuthenticationType.HttpDigestAuthentication) {
                        auth = (List)headers.get("Authorization");
                        if (auth == null || auth.size() == 0 || !((String)auth.get(0)).startsWith("Digest")) {
                            ai.setNotAsserted("HttpDigestAuthentication is set, but not being used");
                        } else {
                            NegotiationUtils.assertPolicy(aim, "HttpDigestAuthentication");
                        }
                    }
                } else {
                    ai.setNotAsserted("Not an HTTPs connection");
                }
                if (ai.isAsserted()) continue;
                throw new PolicyException(ai);
            }
        }
    }
}

