/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.SoapInterceptor;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.PhaseInterceptor;
import org.apache.cxf.resource.ResourceManager;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.crypto.PasswordEncryptor;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandler;

public abstract class AbstractWSS4JInterceptor
extends WSHandler
implements SoapInterceptor,
PhaseInterceptor<SoapMessage> {
    private static final Set<QName> HEADERS = new HashSet<QName>();
    private Map<String, Object> properties = new ConcurrentHashMap<String, Object>();
    private Set<String> before = new HashSet<String>();
    private Set<String> after = new HashSet<String>();
    private String phase;
    private String id = this.getClass().getName();

    @Override
    public Set<URI> getRoles() {
        return null;
    }

    @Override
    public void handleFault(SoapMessage message) {
    }

    public void postHandleMessage(SoapMessage message) throws Fault {
    }

    @Override
    public Collection<PhaseInterceptor<? extends Message>> getAdditionalInterceptors() {
        return null;
    }

    @Override
    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public Object getOption(String key) {
        return this.properties.get(key);
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public String getPassword(Object msgContext) {
        return (String)((Message)msgContext).getContextualProperty("password");
    }

    public Object getProperty(Object msgContext, String key) {
        Object obj = ((Message)msgContext).getContextualProperty(key);
        if (obj == null) {
            obj = this.getOption(key);
        }
        return obj;
    }

    public void setPassword(Object msgContext, String password) {
        ((Message)msgContext).put("password", password);
    }

    public void setProperty(Object msgContext, String key, Object value) {
        ((Message)msgContext).put(key, value);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public Set<QName> getUnderstoodHeaders() {
        return HEADERS;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    @Override
    public Set<String> getAfter() {
        return this.after;
    }

    public void setAfter(Set<String> after) {
        this.after = after;
    }

    @Override
    public Set<String> getBefore() {
        return this.before;
    }

    public void setBefore(Set<String> before) {
        this.before = before;
    }

    protected boolean isRequestor(SoapMessage message) {
        return MessageUtils.isRequestor(message);
    }

    protected void translateProperties(SoapMessage msg) {
        String certConstraints;
        String utTTL;
        String utFutureTTL;
        String ttl;
        String futureTTL;
        String bspCompliant = (String)msg.getContextualProperty("ws-security.is-bsp-compliant");
        if (bspCompliant != null) {
            msg.setContextualProperty("isBSPCompliant", bspCompliant);
        }
        if ((futureTTL = (String)msg.getContextualProperty("ws-security.timestamp.futureTimeToLive")) != null) {
            msg.setContextualProperty("futureTimeToLive", futureTTL);
        }
        if ((ttl = (String)msg.getContextualProperty("ws-security.timestamp.timeToLive")) != null) {
            msg.setContextualProperty("timeToLive", ttl);
        }
        if ((utFutureTTL = (String)msg.getContextualProperty("ws-security.usernametoken.futureTimeToLive")) != null) {
            msg.setContextualProperty("utFutureTimeToLive", utFutureTTL);
        }
        if ((utTTL = (String)msg.getContextualProperty("ws-security.usernametoken.timeToLive")) != null) {
            msg.setContextualProperty("utTimeToLive", utTTL);
        }
        if ((certConstraints = (String)msg.getContextualProperty("ws-security.subject.cert.constraints")) != null) {
            msg.setContextualProperty("sigSubjectCertConstraints", certConstraints);
        }
        boolean validateSAMLSubjectConf = MessageUtils.getContextualBoolean(msg, "ws-security.validate.saml.subject.conf", true);
        msg.setContextualProperty("validateSamlSubjectConfirmation", Boolean.toString(validateSAMLSubjectConf));
        PasswordEncryptor passwordEncryptor = (PasswordEncryptor)msg.getContextualProperty("ws-security.password.encryptor.instance");
        if (passwordEncryptor != null) {
            msg.setContextualProperty("passwordEncyptorInstance", passwordEncryptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Crypto loadCryptoFromPropertiesFile(String propFilename, RequestData reqData) throws WSSecurityException {
        ClassLoaderUtils.ClassLoaderHolder orig = null;
        try {
            URL url = ClassLoaderUtils.getResource(propFilename, this.getClass());
            if (url == null) {
                ResourceManager manager = ((Message)reqData.getMsgContext()).getExchange().getBus().getExtension(ResourceManager.class);
                ClassLoader loader = manager.resolveResource("", ClassLoader.class);
                if (loader != null) {
                    orig = ClassLoaderUtils.setThreadContextClassloader(loader);
                }
                url = manager.resolveResource(propFilename, URL.class);
            }
            if (url == null) return CryptoFactory.getInstance((String)propFilename, (ClassLoader)this.getClassLoader(reqData.getMsgContext()));
            Properties props = new Properties();
            InputStream in = url.openStream();
            props.load(in);
            in.close();
            Crypto crypto = CryptoFactory.getInstance((Properties)props, (ClassLoader)this.getClassLoader(reqData.getMsgContext()), (PasswordEncryptor)this.getPasswordEncryptor(reqData));
            if (orig == null) return crypto;
            orig.reset();
            return crypto;
        }
        catch (Exception e) {
            // empty catch block
            return CryptoFactory.getInstance((String)propFilename, (ClassLoader)this.getClassLoader(reqData.getMsgContext()));
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    static {
        HEADERS.add(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security"));
        HEADERS.add(new QName("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "Security"));
        HEADERS.add(new QName("http://www.w3.org/2001/04/xmlenc#", "EncryptedData"));
    }
}

