/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.tcp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.binding.soap.tcp.DataCodingUtils;
import org.apache.cxf.binding.soap.tcp.frames.SoapTcpFrame;
import org.apache.cxf.binding.soap.tcp.frames.SoapTcpFrameContentDescription;
import org.apache.cxf.binding.soap.tcp.frames.SoapTcpFrameHeader;
import org.apache.cxf.binding.soap.tcp.frames.SoapTcpMessage;
import org.apache.cxf.staxutils.StaxUtils;

public final class SoapTcpUtils {
    private SoapTcpUtils() {
    }

    public static void writeSoapTcpMessage(OutputStream out, SoapTcpMessage msg) throws IOException {
        for (SoapTcpFrame frame : msg.getFrames()) {
            SoapTcpUtils.writeMessageFrame(out, frame);
        }
    }

    public static void writeMessageFrame(OutputStream out, SoapTcpFrame frame) throws IOException {
        if (frame != null) {
            SoapTcpFrameHeader header = frame.getHeader();
            byte[] payload = frame.getPayload();
            if (header != null && payload != null) {
                header.write(out);
                DataCodingUtils.writeInt8(out, payload.length);
                out.write(payload);
                out.flush();
            }
        }
    }

    public static SoapTcpFrame readMessageFrame(InputStream inputStream) throws IOException {
        SoapTcpFrame frame = new SoapTcpFrame();
        SoapTcpFrameHeader header = new SoapTcpFrameHeader();
        frame.setHeader(header);
        int[] response = new int[2];
        DataCodingUtils.readInts4(inputStream, response, 2);
        frame.setChannelId(response[0]);
        header.setChannelId(response[0]);
        header.setFrameType(response[1]);
        switch (response[1]) {
            case 0: {
                header.setContentDescription(SoapTcpUtils.readContentDescription(inputStream));
                break;
            }
            case 1: {
                header.setContentDescription(SoapTcpUtils.readContentDescription(inputStream));
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
        }
        int payloadLength = DataCodingUtils.readInt8(inputStream);
        byte[] payload = new byte[payloadLength];
        if (inputStream.read(payload, 0, payload.length) != payloadLength) {
            throw new IOException();
        }
        frame.setPayload(payload);
        return frame;
    }

    private static SoapTcpFrameContentDescription readContentDescription(InputStream inputStream) throws IOException {
        int[] response = new int[2];
        DataCodingUtils.readInts4(inputStream, response, 2);
        SoapTcpFrameContentDescription contentDesc = new SoapTcpFrameContentDescription();
        contentDesc.setContentId(response[0]);
        int numOfParams = response[1];
        Hashtable<Integer, String> parameters = new Hashtable<Integer, String>();
        for (int i = 0; i < numOfParams; ++i) {
            byte[] buffer;
            DataCodingUtils.readInts4(inputStream, response, 2);
            if (response[1] <= 0 || inputStream.read(buffer = new byte[response[1]]) <= 0) continue;
            String value = new String(buffer, "UTF-8");
            parameters.put(response[0], value);
        }
        contentDesc.setParameters(parameters);
        return contentDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkSingleFrameResponse(SoapTcpFrame responseFrame, String elementName) {
        if (responseFrame != null && responseFrame.getHeader().getFrameType() == 0) {
            ByteArrayInputStream bais = new ByteArrayInputStream(responseFrame.getPayload());
            XMLStreamReader xmlReader = StaxUtils.createXMLStreamReader(bais);
            try {
                while (xmlReader.hasNext()) {
                    xmlReader.next();
                    if (xmlReader.getEventType() != 1 || !xmlReader.getLocalName().equals(elementName)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    StaxUtils.close(xmlReader);
                }
                catch (XMLStreamException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    public static void printSoapTcpFrame(OutputStream out, SoapTcpFrame frame) {
        if (frame != null) {
            byte[] payload;
            PrintStream writer = (PrintStream)out;
            writer.println("channel-id: " + frame.getChannelId());
            SoapTcpFrameHeader header = frame.getHeader();
            if (header != null) {
                writer.println("frameType: " + header.getFrameType());
                SoapTcpFrameContentDescription contentDesc = header.getContentDescription();
                if (contentDesc != null) {
                    writer.println("content-id: " + contentDesc.getContentId());
                    Map<Integer, String> parameters = contentDesc.getParameters();
                    if (parameters != null) {
                        Iterator<Integer> keys = parameters.keySet().iterator();
                        writer.println("parameters");
                        while (keys.hasNext()) {
                            Integer key = keys.next();
                            String value = parameters.get(key);
                            writer.println(key + " : " + value);
                        }
                    }
                }
            }
            if ((payload = frame.getPayload()) != null) {
                try {
                    String messageContent = new String(payload, "UTF-8");
                    writer.println("messageContent:");
                    writer.println(messageContent);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

