/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.grants.code;

import java.io.StringWriter;
import org.apache.cxf.common.util.Base64Exception;
import org.apache.cxf.rs.security.oauth2.grants.code.CodeVerifierTransformer;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.utils.Base64UrlUtility;
import org.apache.cxf.rs.security.oauth2.utils.MessageDigestGenerator;

public class DigestCodeVerifier
implements CodeVerifierTransformer {
    @Override
    public String transformCodeVerifier(String codeVerifier) {
        MessageDigestGenerator mdg = new MessageDigestGenerator();
        byte[] digest = mdg.createDigest(codeVerifier, "SHA-256");
        int length = digest.length > 16 ? 16 : digest.length;
        StringWriter stringWriter = new StringWriter();
        try {
            Base64UrlUtility.encode(digest, 0, length, stringWriter);
        }
        catch (Base64Exception e) {
            throw new OAuthServiceException("server_error", (Throwable)e);
        }
        return stringWriter.toString();
    }
}

