/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.MessageListener;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.OneWayProcessorInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractMultiplexDestination;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.jms.BackChannelConduit;
import org.apache.cxf.transport.jms.JMSConfiguration;
import org.apache.cxf.transport.jms.JMSFactory;
import org.apache.cxf.transport.jms.ThrottlingCounter;
import org.apache.cxf.transport.jms.util.JMSListenerContainer;

public class JMSDestination
extends AbstractMultiplexDestination
implements MessageListener {
    private static final Logger LOG = LogUtils.getL7dLogger(JMSDestination.class);
    private JMSConfiguration jmsConfig;
    private Bus bus;
    private EndpointInfo ei;
    private JMSListenerContainer jmsListener;
    private ThrottlingCounter suspendedContinuations;
    private ClassLoader loader;

    public JMSDestination(Bus b, EndpointInfo info, JMSConfiguration jmsConfig) {
        super(b, JMSDestination.getTargetReference(info, b), info);
        this.bus = b;
        this.ei = info;
        this.jmsConfig = jmsConfig;
        info.setProperty(OneWayProcessorInterceptor.USE_ORIGINAL_THREAD, Boolean.TRUE);
        this.loader = this.bus.getExtension(ClassLoader.class);
    }

    @Override
    protected Conduit getInbuiltBackChannel(Message inMessage) {
        return new BackChannelConduit(inMessage, this.jmsConfig);
    }

    @Override
    public void activate() {
        this.getLogger().log(Level.FINE, "JMSDestination activate().... ");
        this.jmsConfig.ensureProperlyConfigured();
        this.jmsListener = JMSFactory.createTargetDestinationListener(this.ei, this.jmsConfig, this);
        int restartLimit = this.jmsConfig.getMaxSuspendedContinuations() * this.jmsConfig.getReconnectPercentOfMax() / 100;
        this.suspendedContinuations = new ThrottlingCounter(this.jmsListener, restartLimit, this.jmsConfig.getMaxSuspendedContinuations());
    }

    @Override
    public void deactivate() {
        if (this.jmsListener != null) {
            this.jmsListener.shutdown();
        }
    }

    @Override
    public void shutdown() {
        this.getLogger().log(Level.FINE, "JMSDestination shutdown()");
        this.deactivate();
    }

    /*
     * Exception decompiling
     */
    public void onMessage(javax.jms.Message message) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    public JMSConfiguration getJmsConfig() {
        return this.jmsConfig;
    }

    public void setJmsConfig(JMSConfiguration jmsConfig) {
        this.jmsConfig = jmsConfig;
    }
}

