/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms.util;

import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.cxf.transport.jms.util.ResourceCloser;

public final class JMSUtil {
    private static final char[] CORRELATTION_ID_PADDING = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'};

    private JMSUtil() {
    }

    public static Message receive(Session session, Destination replyToDestination, String correlationId, long receiveTimeout, boolean pubSubNoLocal) {
        ResourceCloser closer = new ResourceCloser();
        try {
            String messageSelector = correlationId == null ? null : "JMSCorrelationID = '" + correlationId + "'";
            MessageConsumer consumer = closer.register(session.createConsumer(replyToDestination, messageSelector, pubSubNoLocal));
            Message replyMessage = consumer.receive(receiveTimeout);
            if (replyMessage == null) {
                throw new RuntimeException("Timeout receiving message with correlationId " + correlationId);
            }
            Message message = replyMessage;
            return message;
        }
        catch (JMSException e) {
            throw JMSUtil.convertJmsException(e);
        }
        finally {
            closer.close();
        }
    }

    public static RuntimeException convertJmsException(JMSException e) {
        return new RuntimeException(e.getMessage(), e);
    }

    public static String createCorrelationId(String prefix, long sequenceNUm) {
        String index = Long.toHexString(sequenceNUm);
        StringBuilder id = new StringBuilder(prefix);
        id.append(CORRELATTION_ID_PADDING, 0, 16 - index.length());
        id.append(index);
        return id.toString();
    }

    public static Message createAndSetPayload(Object payload, Session session, String messageType) throws JMSException {
        TextMessage message = null;
        if ("text".equals(messageType)) {
            message = session.createTextMessage((String)payload);
        } else if ("byte".equals(messageType)) {
            message = session.createBytesMessage();
            ((BytesMessage)message).writeBytes((byte[])payload);
        } else {
            message = session.createObjectMessage();
            ((ObjectMessage)message).setObject((Serializable)((byte[])payload));
        }
        return message;
    }
}

