/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven_plugin;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.maven_plugin.Option;
import org.apache.cxf.maven_plugin.WsdlArtifact;
import org.apache.cxf.tools.util.URIParserUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlOption
extends Option {
    String wsdl;
    WsdlArtifact wsdlArtifact;

    public String getWsdl() {
        return this.wsdl;
    }

    public void setWsdl(String w) {
        this.wsdl = w;
    }

    public WsdlArtifact getWsdlArtifact() {
        return this.wsdlArtifact;
    }

    public void setWsdlArtifact(WsdlArtifact wsdlArtifact) {
        this.wsdlArtifact = wsdlArtifact;
    }

    public File getWsdlFile(File baseDir) {
        if (this.wsdl == null) {
            return null;
        }
        File file = null;
        try {
            URI uri = new URI(this.wsdl);
            if (uri.isAbsolute()) {
                file = new File(uri);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (file == null || !file.exists()) {
            file = new File(this.wsdl);
        }
        if (!file.exists()) {
            file = new File(baseDir, this.wsdl);
        }
        return file;
    }

    public URI getWsdlURI(URI baseURI) {
        String wsdlLocation = this.getWsdl();
        File wsdlFile = new File(wsdlLocation);
        return wsdlFile.exists() ? wsdlFile.toURI() : baseURI.resolve(URIParserUtil.escapeChars((String)wsdlLocation));
    }

    public boolean isDefServiceName() {
        if (this.extraargs == null) {
            return false;
        }
        for (int i = 0; i < this.extraargs.size(); ++i) {
            if (!"-sn".equalsIgnoreCase((String)this.extraargs.get(i))) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this.wsdl != null) {
            return this.wsdl.hashCode();
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WsdlOption)) {
            return false;
        }
        WsdlOption t = (WsdlOption)obj;
        return t.getWsdl().equals(this.getWsdl());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("WSDL: ").append(this.wsdl).append('\n');
        builder.append("OutputDir: ").append(this.outputDir).append('\n');
        builder.append("Extraargs: ").append(this.extraargs).append('\n');
        builder.append("XJCargs: ").append(this.xjcargs).append('\n');
        builder.append("Packagenames: ").append(this.packagenames).append('\n');
        builder.append('\n');
        return builder.toString();
    }

    public List<String> generateCommandLine(File outputDirFile, URI basedir, URI wsdlURI, boolean debug) {
        ArrayList<String> list = new ArrayList<String>();
        WsdlOption.addList(list, "-p", true, this.getPackagenames());
        WsdlOption.addList(list, "-nexclude", true, this.getNamespaceExcludes());
        WsdlOption.addIfNotNull(list, outputDirFile, "-d");
        for (String binding : this.getBindingFiles()) {
            File bindingFile = new File(binding);
            URI bindingURI = bindingFile.exists() ? bindingFile.toURI() : basedir.resolve(binding);
            list.add("-b");
            list.add(bindingURI.toString());
        }
        WsdlOption.addIfNotNull(list, this.getFrontEnd(), "-fe");
        WsdlOption.addIfNotNull(list, this.getDataBinding(), "-db");
        WsdlOption.addIfNotNull(list, this.getWsdlVersion(), "-wv");
        WsdlOption.addIfNotNull(list, this.getCatalog(), "-catalog");
        if (this.isExtendedSoapHeaders()) {
            list.add("-exsh");
            list.add("true");
        }
        WsdlOption.addIfTrue(list, this.isAllowElementRefs(), "-allowElementRefs");
        WsdlOption.addIfTrue(list, this.isValidateWsdl(), "-validate");
        WsdlOption.addIfNotNull(list, this.getDefaultExcludesNamespace(), "-dex");
        WsdlOption.addIfNotNull(list, this.getDefaultNamespacePackageMapping(), "-dns");
        WsdlOption.addIfNotNull(list, this.getServiceName(), "-sn");
        WsdlOption.addIfTrue(list, this.isAutoNameResolution(), "-autoNameResolution");
        WsdlOption.addIfTrue(list, this.isNoAddressBinding(), "-noAddressBinding");
        WsdlOption.addList(list, "-xjc", false, this.getXJCargs());
        WsdlOption.addList(list, "", false, this.getExtraargs());
        if (this.isSetWsdlLocation()) {
            list.add("-wsdlLocation");
            list.add(this.getWsdlLocation() == null ? "" : this.getWsdlLocation());
        }
        WsdlOption.addIfTrue(list, this.isWsdlList(), "-wsdlList");
        WsdlOption.addIfTrue(list, debug && !list.contains("-verbose"), "-verbose");
        list.add(wsdlURI.toString());
        return list;
    }

    private static void addIfTrue(List<String> list, boolean expression, String key) {
        if (expression) {
            list.add(key);
        }
    }

    private static void addIfNotNull(List<String> list, Object value, String key) {
        if (value != null) {
            list.add(key);
            list.add(value.toString());
        }
    }

    private static void addList(List<String> destList, String key, boolean keyAsOwnElement, List<String> sourceList) {
        if (sourceList == null) {
            return;
        }
        for (String value : sourceList) {
            if (keyAsOwnElement) {
                destList.add(key);
                destList.add(value);
                continue;
            }
            destList.add(key + (value == null ? "" : value));
        }
    }
}

