/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven_plugin;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.SystemUtils;
import org.apache.cxf.Bus;
import org.apache.cxf.common.util.SystemPropertyAction;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.FileUtils;
import org.apache.cxf.maven_plugin.ClassLoaderSwitcher;
import org.apache.cxf.maven_plugin.GenericWsdlOption;
import org.apache.cxf.maven_plugin.WsdlArtifact;
import org.apache.cxf.tools.util.URIParserUtil;
import org.apache.maven.ProjectDependenciesResolver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Repository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectUtils;
import org.apache.maven.settings.Proxy;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCodegenMoho
extends AbstractMojo {
    private static final String HTTP_PROXY_HOST = "http.proxyHost";
    private static final String HTTP_PROXY_PORT = "http.proxyPort";
    private static final String HTTP_NON_PROXY_HOSTS = "http.nonProxyHosts";
    private static final String HTTP_PROXY_USER = "http.proxyUser";
    private static final String HTTP_PROXY_PASSWORD = "http.proxyPassword";
    protected String classesDirectory;
    protected boolean disableDependencyScan;
    protected boolean disableDirectoryScan;
    protected String fork;
    protected String[] includes;
    protected File markerDirectory;
    protected List<Artifact> pluginArtifacts;
    protected MavenProject project;
    protected boolean useCompileClasspath;
    protected String[] excludes;
    protected File testWsdlRoot;
    protected File wsdlRoot;
    private String additionalJvmArgs;
    private ArtifactRepository localRepository;
    private ArtifactFactory artifactFactory;
    private String javaExecutable;
    private List<Repository> repositories;
    private ArtifactRepositoryFactory artifactRepositoryFactory;
    private MavenSession mavenSession;
    private ProjectDependenciesResolver projectDependencyResolver;
    private ArtifactResolver artifactResolver;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        File classesDir = new File(this.classesDirectory);
        classesDir.mkdirs();
        if (this.includes == null) {
            this.includes = new String[]{"*.wsdl"};
        }
        this.markerDirectory.mkdirs();
        String originalProxyHost = SystemPropertyAction.getProperty((String)HTTP_PROXY_HOST);
        String originalProxyPort = SystemPropertyAction.getProperty((String)HTTP_PROXY_PORT);
        String originalNonProxyHosts = SystemPropertyAction.getProperty((String)HTTP_NON_PROXY_HOSTS);
        String originalProxyUser = SystemPropertyAction.getProperty((String)HTTP_PROXY_USER);
        String originalProxyPassword = SystemPropertyAction.getProperty((String)HTTP_PROXY_PASSWORD);
        this.configureProxyServerSettings();
        List<GenericWsdlOption> effectiveWsdlOptions = this.createWsdlOptionsFromScansAndExplicitWsdlOptions();
        if (effectiveWsdlOptions.size() == 0) {
            this.getLog().info((CharSequence)"Nothing to generate");
            return;
        }
        ClassLoaderSwitcher classLoaderSwitcher = new ClassLoaderSwitcher(this.getLog());
        boolean result = true;
        Bus bus = null;
        try {
            Set<URI> cp = classLoaderSwitcher.switchClassLoader(this.project, this.useCompileClasspath, classesDir);
            if ("once".equals(this.fork) || "true".equals(this.fork)) {
                this.forkOnce(cp, effectiveWsdlOptions);
            } else {
                for (GenericWsdlOption o : effectiveWsdlOptions) {
                    bus = this.generate(o, bus, cp);
                    File[] dirs = o.getDeleteDirs();
                    if (dirs == null) continue;
                    for (int idx = 0; idx < dirs.length; ++idx) {
                        result = result && this.deleteDir(dirs[idx]);
                    }
                }
            }
        }
        finally {
            if (bus != null) {
                bus.shutdown(true);
            }
            classLoaderSwitcher.restoreClassLoader();
            this.restoreProxySetting(originalProxyHost, originalProxyPort, originalNonProxyHosts, originalProxyUser, originalProxyPassword);
        }
        if (this.project != null && this.getGeneratedSourceRoot() != null && this.getGeneratedSourceRoot().exists()) {
            this.project.addCompileSourceRoot(this.getGeneratedSourceRoot().getAbsolutePath());
        }
        if (this.project != null && this.getGeneratedTestRoot() != null && this.getGeneratedTestRoot().exists()) {
            this.project.addTestCompileSourceRoot(this.getGeneratedTestRoot().getAbsolutePath());
        }
        System.gc();
    }

    private void restoreProxySetting(String originalProxyHost, String originalProxyPort, String originalNonProxyHosts, String originalProxyUser, String originalProxyPassword) {
        if (originalProxyHost != null) {
            System.setProperty(HTTP_PROXY_HOST, originalProxyHost);
        } else {
            System.getProperties().remove(HTTP_PROXY_HOST);
        }
        if (originalProxyPort != null) {
            System.setProperty(HTTP_PROXY_PORT, originalProxyPort);
        } else {
            System.getProperties().remove(HTTP_PROXY_PORT);
        }
        if (originalNonProxyHosts != null) {
            System.setProperty(HTTP_NON_PROXY_HOSTS, originalNonProxyHosts);
        } else {
            System.getProperties().remove(HTTP_NON_PROXY_HOSTS);
        }
        if (originalProxyUser != null) {
            System.setProperty(HTTP_PROXY_USER, originalProxyUser);
        } else {
            System.getProperties().remove(HTTP_PROXY_USER);
        }
        if (originalProxyPassword != null) {
            System.setProperty(HTTP_PROXY_PASSWORD, originalProxyPassword);
        } else {
            System.getProperties().remove(HTTP_PROXY_PASSWORD);
        }
        Proxy proxy = this.mavenSession.getSettings().getActiveProxy();
        if (proxy != null && !StringUtils.isEmpty((String)proxy.getUsername()) && !StringUtils.isEmpty((String)proxy.getPassword())) {
            Authenticator.setDefault(null);
        }
    }

    protected abstract Bus generate(GenericWsdlOption var1, Bus var2, Set<URI> var3) throws MojoExecutionException;

    protected void addPluginArtifact(Set<URI> artifactsPath) {
        URL url = ((Object)((Object)this)).getClass().getResource(((Object)((Object)this)).getClass().getSimpleName() + ".class");
        try {
            File file;
            URI uri;
            String s;
            if ("jar".equals(url.getProtocol()) && (s = url.getPath()).contains("!")) {
                s = s.substring(0, s.indexOf(33));
                url = new URL(s);
            }
            if ((uri = new URI(url.getProtocol(), null, url.getPath(), null, null)).getSchemeSpecificPart().endsWith(".class")) {
                String s2 = uri.toString();
                s2 = s2.substring(0, s2.length() - 6 - ((Object)((Object)this)).getClass().getName().length());
                uri = new URI(s2);
            }
            if ((file = new File(uri)).exists()) {
                artifactsPath.add(file.toURI());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void configureProxyServerSettings() throws MojoExecutionException {
        Proxy proxy = this.mavenSession.getSettings().getActiveProxy();
        if (proxy != null) {
            this.getLog().info((CharSequence)"Using proxy server configured in maven.");
            if (proxy.getHost() == null) {
                throw new MojoExecutionException("Proxy in settings.xml has no host");
            }
            if (proxy.getHost() != null) {
                System.setProperty(HTTP_PROXY_HOST, proxy.getHost());
            }
            if (String.valueOf(proxy.getPort()) != null) {
                System.setProperty(HTTP_PROXY_PORT, String.valueOf(proxy.getPort()));
            }
            if (proxy.getNonProxyHosts() != null) {
                System.setProperty(HTTP_NON_PROXY_HOSTS, proxy.getNonProxyHosts());
            }
            if (!StringUtils.isEmpty((String)proxy.getUsername()) && !StringUtils.isEmpty((String)proxy.getPassword())) {
                final String authUser = proxy.getUsername();
                final String authPassword = proxy.getPassword();
                Authenticator.setDefault(new Authenticator(){

                    public PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(authUser, authPassword.toCharArray());
                    }
                });
                System.setProperty(HTTP_PROXY_USER, authUser);
                System.setProperty(HTTP_PROXY_PORT, authPassword);
            }
        }
    }

    protected abstract List<GenericWsdlOption> createWsdlOptionsFromScansAndExplicitWsdlOptions() throws MojoExecutionException;

    protected boolean deleteDir(File f) {
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            for (int idx = 0; idx < files.length; ++idx) {
                this.deleteDir(files[idx]);
            }
        }
        if (f.exists()) {
            return f.delete();
        }
        return true;
    }

    protected abstract String getMarkerSuffix();

    protected List<String> generateCommandLine(GenericWsdlOption wsdlOption) throws MojoExecutionException {
        File outputDirFile = wsdlOption.getOutputDir();
        outputDirFile.mkdirs();
        URI basedir = this.project.getBasedir().toURI();
        URI wsdlURI = this.getWsdlURI(wsdlOption, basedir);
        return wsdlOption.generateCommandLine(outputDirFile, basedir, wsdlURI, this.getLog().isDebugEnabled());
    }

    protected void forkOnce(Set<URI> classPath, List<GenericWsdlOption> effectiveWsdlOptions) throws MojoExecutionException {
        LinkedList<GenericWsdlOption> toDo = new LinkedList<GenericWsdlOption>();
        LinkedList<List<String>> wargs = new LinkedList<List<String>>();
        for (GenericWsdlOption wsdlOption : effectiveWsdlOptions) {
            File outputDirFile = wsdlOption.getOutputDir();
            outputDirFile.mkdirs();
            URI basedir = this.project.getBasedir().toURI();
            URI wsdlURI = this.getWsdlURI(wsdlOption, basedir);
            File doneFile = this.getDoneFile(basedir, wsdlURI, this.getMarkerSuffix());
            if (!this.shouldRun(wsdlOption, doneFile, wsdlURI)) continue;
            doneFile.delete();
            toDo.add(wsdlOption);
            wargs.add(this.generateCommandLine(wsdlOption));
        }
        if (wargs.isEmpty()) {
            return;
        }
        LinkedHashSet<URI> artifactsPath = new LinkedHashSet<URI>();
        for (Artifact a : this.pluginArtifacts) {
            File file = a.getFile();
            if (file == null) {
                throw new MojoExecutionException("Unable to find " + file + " for artifact " + a.getGroupId() + ":" + a.getArtifactId() + ":" + a.getVersion());
            }
            artifactsPath.add(file.toURI());
        }
        this.addPluginArtifact(artifactsPath);
        artifactsPath.addAll(classPath);
        String[] args = this.createForkOnceArgs(wargs);
        this.runForked(artifactsPath, this.getForkClass().getName(), args);
        for (GenericWsdlOption wsdlOption : toDo) {
            File[] dirs = wsdlOption.getDeleteDirs();
            if (dirs != null) {
                for (int idx = 0; idx < dirs.length; ++idx) {
                    this.deleteDir(dirs[idx]);
                }
            }
            URI basedir = this.project.getBasedir().toURI();
            URI wsdlURI = this.getWsdlURI(wsdlOption, basedir);
            File doneFile = this.getDoneFile(basedir, wsdlURI, this.getMarkerSuffix());
            try {
                doneFile.createNewFile();
            }
            catch (Throwable e) {
                this.getLog().warn((CharSequence)("Could not create marker file " + doneFile.getAbsolutePath()));
                this.getLog().debug(e);
            }
        }
    }

    protected abstract Class<?> getForkClass();

    protected File getDoneFile(URI basedir, URI wsdlURI, String mojo) {
        String doneFileName = wsdlURI.toString();
        if (doneFileName.startsWith(basedir.toString())) {
            doneFileName = doneFileName.substring(basedir.toString().length());
        }
        doneFileName = doneFileName.replace('?', '_').replace('&', '_').replace('/', '_').replace('\\', '_').replace(':', '_');
        return new File(this.markerDirectory, "." + doneFileName + "." + mojo + ".DONE");
    }

    protected abstract File getGeneratedSourceRoot();

    protected abstract File getGeneratedTestRoot();

    protected void runForked(Set<URI> classPath, String mainClassName, String[] args) throws MojoExecutionException {
        StringBuffer msg;
        int exitCode;
        this.getLog().info((CharSequence)"Running code generation in fork mode...");
        this.getLog().debug((CharSequence)("Running code generation in fork mode with args " + Arrays.asList(args)));
        Commandline cmd = new Commandline();
        cmd.getShell().setQuotedArgumentsEnabled(true);
        cmd.setWorkingDirectory(this.project.getBuild().getDirectory());
        try {
            cmd.setExecutable(this.getJavaExecutable().getAbsolutePath());
        }
        catch (IOException e) {
            this.getLog().debug((Throwable)e);
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        cmd.createArg().setLine(this.additionalJvmArgs);
        File file = null;
        try {
            file = FileUtils.createTempFile((String)"cxf-codegen", (String)".jar");
            JarArchiver jar = new JarArchiver();
            jar.setDestFile(file.getAbsoluteFile());
            Manifest manifest = new Manifest();
            Manifest.Attribute attr = new Manifest.Attribute();
            attr.setName("Class-Path");
            StringBuilder b = new StringBuilder(8000);
            for (URI cp : classPath) {
                b.append(cp.toURL().toExternalForm()).append(' ');
            }
            attr.setValue(b.toString());
            manifest.getMainSection().addConfiguredAttribute(attr);
            attr = new Manifest.Attribute();
            attr.setName("Main-Class");
            attr.setValue(mainClassName);
            manifest.getMainSection().addConfiguredAttribute(attr);
            jar.addConfiguredManifest(manifest);
            jar.createArchive();
            cmd.createArg().setValue("-jar");
            String tmpFilePath = file.getAbsolutePath();
            if (tmpFilePath.contains(" ")) {
                tmpFilePath = "\"" + tmpFilePath + "\"";
            }
            cmd.createArg().setValue(tmpFilePath);
        }
        catch (Exception e1) {
            throw new MojoExecutionException("Could not create runtime jar", e1);
        }
        cmd.addArguments(args);
        StreamConsumer out = new StreamConsumer(){

            public void consumeLine(String line) {
                AbstractCodegenMoho.this.getLog().info((CharSequence)line);
            }
        };
        final StringBuilder b = new StringBuilder();
        StreamConsumer err = new StreamConsumer(){

            public void consumeLine(String line) {
                b.append(line);
                b.append("\n");
                AbstractCodegenMoho.this.getLog().warn((CharSequence)line);
            }
        };
        try {
            exitCode = CommandLineUtils.executeCommandLine((Commandline)cmd, (StreamConsumer)out, (StreamConsumer)err);
        }
        catch (CommandLineException e) {
            this.getLog().debug((Throwable)e);
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        String cmdLine = CommandLineUtils.toString((String[])cmd.getCommandline());
        if (exitCode != 0) {
            msg = new StringBuffer("\nExit code: ");
            msg.append(exitCode);
            msg.append('\n');
            msg.append("Command line was: ").append(cmdLine).append('\n').append('\n');
            throw new MojoExecutionException(msg.toString());
        }
        if (file != null) {
            file.delete();
        }
        if (b.toString().contains("WSDL2Java Error")) {
            msg = new StringBuffer();
            msg.append(b.toString());
            msg.append('\n');
            msg.append("Command line was: ").append(cmdLine).append('\n').append('\n');
            throw new MojoExecutionException(msg.toString());
        }
    }

    protected abstract boolean shouldRun(GenericWsdlOption var1, File var2, URI var3);

    private String[] createForkOnceArgs(List<List<String>> wargs) throws MojoExecutionException {
        try {
            File f = FileUtils.createTempFile((String)"cxf-w2j", (String)"args");
            PrintWriter fw = new PrintWriter(new FileWriter(f));
            for (List<String> args : wargs) {
                fw.println(Integer.toString(args.size()));
                for (String s : args) {
                    fw.println(s);
                }
            }
            fw.println("-1");
            fw.close();
            return new String[]{f.getAbsolutePath()};
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Could not create argument file", (Exception)ex);
        }
    }

    public File getWsdlFile(GenericWsdlOption option, File baseDir) {
        if (option.getUri() == null) {
            return null;
        }
        File file = null;
        try {
            URI uri = new URI(option.getUri());
            if (uri.isAbsolute()) {
                file = new File(uri);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (file == null || !file.exists()) {
            file = new File(option.getUri());
        }
        if (!file.exists()) {
            file = new File(baseDir, option.getUri());
        }
        return file;
    }

    public URI getWsdlURI(GenericWsdlOption option, URI baseURI) throws MojoExecutionException {
        String wsdlLocation = option.getUri();
        if (wsdlLocation == null) {
            throw new MojoExecutionException("No wsdl available for base URI " + baseURI);
        }
        File wsdlFile = new File(wsdlLocation);
        return wsdlFile.exists() ? wsdlFile.toURI() : baseURI.resolve(URIParserUtil.escapeChars((String)wsdlLocation));
    }

    protected void downloadRemoteWsdls(List<GenericWsdlOption> effectiveWsdlOptions) throws MojoExecutionException {
        for (GenericWsdlOption wsdlOption : effectiveWsdlOptions) {
            WsdlArtifact wsdlA = wsdlOption.getArtifact();
            if (wsdlA == null) continue;
            Artifact wsdlArtifact = this.artifactFactory.createArtifactWithClassifier(wsdlA.getGroupId(), wsdlA.getArtifactId(), wsdlA.getVersion(), wsdlA.getType(), wsdlA.getClassifier());
            if ((wsdlArtifact = this.resolveRemoteWsdlArtifact(wsdlArtifact)) == null) continue;
            File supposedFile = wsdlArtifact.getFile();
            if (!supposedFile.exists() || !supposedFile.isFile()) {
                this.getLog().info((CharSequence)("Apparent Maven bug: wsdl artifact 'resolved' to " + supposedFile.getAbsolutePath() + " for " + wsdlArtifact.toString()));
                continue;
            }
            String path = supposedFile.getAbsolutePath();
            this.getLog().info((CharSequence)("Resolved WSDL artifact to file " + path));
            wsdlOption.setUri(path);
        }
    }

    private File getJavaExecutable() throws IOException {
        String exe = SystemUtils.IS_OS_WINDOWS && !this.javaExecutable.endsWith(".exe") ? ".exe" : "";
        File javaExe = new File(this.javaExecutable + exe);
        if (!javaExe.isFile()) {
            throw new IOException("The java executable '" + javaExe + "' doesn't exist or is not a file." + "Verify the <javaExecutable/> parameter.");
        }
        return javaExe;
    }

    private Artifact resolveRemoteWsdlArtifact(Artifact artifact) throws MojoExecutionException {
        Artifact remoteWsdl = this.resolveDependentWsdl(artifact);
        if (remoteWsdl == null) {
            remoteWsdl = this.resolveAttachedWsdl(artifact);
        }
        if (remoteWsdl == null) {
            remoteWsdl = this.resolveArbitraryWsdl(artifact);
        }
        if (remoteWsdl != null && remoteWsdl.isResolved()) {
            return remoteWsdl;
        }
        throw new MojoExecutionException(String.format("Failed to resolve WSDL artifact %s", artifact.toString()));
    }

    private Artifact resolveDependentWsdl(Artifact artifact) {
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add("runtime");
        Set artifactSet = null;
        try {
            artifactSet = this.projectDependencyResolver.resolve(this.project, scopes, this.mavenSession);
        }
        catch (AbstractArtifactResolutionException e) {
            this.getLog().info((CharSequence)"Error resolving dependent wsdl artifact.", (Throwable)e);
        }
        return this.findWsdlArtifact(artifact, artifactSet);
    }

    private Artifact resolveAttachedWsdl(Artifact artifact) {
        List rProjects = this.mavenSession.getSortedProjects();
        ArrayList<Artifact> artifactList = new ArrayList<Artifact>();
        for (MavenProject rProject : rProjects) {
            List list = CastUtils.cast((List)rProject.getAttachedArtifacts());
            if (list == null) continue;
            artifactList.addAll(list);
        }
        return this.findWsdlArtifact(artifact, artifactList);
    }

    private Artifact resolveArbitraryWsdl(Artifact artifact) {
        try {
            List remoteRepos = ProjectUtils.buildArtifactRepositories(this.repositories, (ArtifactRepositoryFactory)this.artifactRepositoryFactory, (PlexusContainer)this.mavenSession.getContainer());
            this.artifactResolver.resolve(artifact, remoteRepos, this.localRepository);
        }
        catch (InvalidRepositoryException e) {
            this.getLog().info((CharSequence)"Error build repositories for remote wsdls.", (Throwable)e);
        }
        catch (AbstractArtifactResolutionException e) {
            this.getLog().info((CharSequence)"Error resolving arbitrary wsdl artifact.", (Throwable)e);
        }
        return artifact;
    }

    private Artifact findWsdlArtifact(Artifact targetArtifact, Collection<Artifact> artifactSet) {
        if (artifactSet != null && !artifactSet.isEmpty()) {
            for (Artifact pArtifact : artifactSet) {
                if (!targetArtifact.getGroupId().equals(pArtifact.getGroupId()) || !targetArtifact.getArtifactId().equals(pArtifact.getArtifactId()) || !targetArtifact.getVersion().equals(pArtifact.getVersion()) || !"wsdl".equals(pArtifact.getType())) continue;
                this.getLog().info((CharSequence)String.format("%s resolved to %s", pArtifact.toString(), pArtifact.getFile().getAbsolutePath()));
                return pArtifact;
            }
        }
        return null;
    }
}

