/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven_plugin;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cxf.helpers.CastUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderSwitcher {
    private Log log;
    private String origClassPath;
    private Map<Object, Object> origProps;
    private ClassLoader origContextClassloader;

    public ClassLoaderSwitcher(Log log) {
        this.log = log;
    }

    public Set<URI> switchClassLoader(MavenProject project, boolean useCompileClasspath, File classesDir) {
        ArrayList<URL> urlList = new ArrayList<URL>();
        StringBuilder buf = new StringBuilder();
        LinkedHashSet<URI> ret = new LinkedHashSet<URI>();
        try {
            urlList.add(classesDir.toURI().toURL());
            if (!useCompileClasspath) {
                urlList.add(new File(project.getBuild().getOutputDirectory()).toURI().toURL());
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        buf.append(classesDir.getAbsolutePath());
        ret.add(classesDir.toURI());
        buf.append(File.pathSeparatorChar);
        if (!useCompileClasspath) {
            buf.append(project.getBuild().getOutputDirectory());
            ret.add(new File(project.getBuild().getOutputDirectory()).toURI());
            buf.append(File.pathSeparatorChar);
        }
        List artifacts = useCompileClasspath ? project.getCompileArtifacts() : project.getTestArtifacts();
        for (Artifact a : CastUtils.cast((List)artifacts, Artifact.class)) {
            try {
                if (a.getFile() == null || !a.getFile().exists()) continue;
                urlList.add(a.getFile().toURI().toURL());
                buf.append(a.getFile().getAbsolutePath());
                ret.add(a.getFile().toURI());
                buf.append(File.pathSeparatorChar);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        this.origContextClassloader = Thread.currentThread().getContextClassLoader();
        URLClassLoader loader = new URLClassLoader(urlList.toArray(new URL[urlList.size()]), this.origContextClassloader);
        String newCp = buf.toString();
        this.log.debug((CharSequence)("Classpath: " + ((Object)urlList).toString()));
        this.origProps = new HashMap<Object, Object>(System.getProperties());
        this.origClassPath = System.getProperty("java.class.path");
        Thread.currentThread().setContextClassLoader(loader);
        System.setProperty("java.class.path", newCp);
        return ret;
    }

    public void restoreClassLoader() {
        if (this.origContextClassloader != null) {
            Thread.currentThread().setContextClassLoader(this.origContextClassloader);
            this.origContextClassloader = null;
        }
        if (this.origClassPath != null) {
            System.setProperty("java.class.path", this.origClassPath);
        }
        if (this.origProps != null) {
            HashMap<Object, Object> newProps = new HashMap<Object, Object>(System.getProperties());
            for (Object o : newProps.keySet()) {
                if (this.origProps.containsKey(o)) continue;
                System.clearProperty(o.toString());
            }
            System.getProperties().putAll(this.origProps);
        }
    }
}

