/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven_plugin.wsdl2java;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.maven_plugin.AbstractCodegenMoho;
import org.apache.cxf.maven_plugin.GenericWsdlOption;
import org.apache.cxf.maven_plugin.wsdl2java.ForkOnceWSDL2Java;
import org.apache.cxf.maven_plugin.wsdl2java.Option;
import org.apache.cxf.maven_plugin.wsdl2java.WsdlOption;
import org.apache.cxf.maven_plugin.wsdl2java.WsdlOptionLoader;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolErrorListener;
import org.apache.cxf.tools.util.OutputStreamCreator;
import org.apache.cxf.tools.wsdlto.WSDLToJava;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDL2JavaMojo
extends AbstractCodegenMoho {
    File testSourceRoot;
    File sourceRoot;
    WsdlOption[] wsdlOptions;
    Option defaultOptions = new Option();
    String encoding;

    protected void mergeOptions(List<GenericWsdlOption> effectiveWsdlOptions) {
        File outputDirFile = this.getGeneratedTestRoot() == null ? this.getGeneratedSourceRoot() : this.getGeneratedTestRoot();
        ArrayList<WsdlOption> newList = new ArrayList<WsdlOption>();
        for (GenericWsdlOption go : effectiveWsdlOptions) {
            File file;
            WsdlOption o = (WsdlOption)go;
            if (this.defaultOptions != null) {
                o.merge(this.defaultOptions);
            }
            if (o.getOutputDir() == null) {
                o.setOutputDir(outputDirFile);
            }
            if ((file = o.getWsdlFile(this.project.getBasedir())) != null && file.exists()) {
                file = file.getAbsoluteFile();
                boolean duplicate = false;
                for (GenericWsdlOption genericWsdlOption : newList) {
                    WsdlOption o2 = (WsdlOption)genericWsdlOption;
                    File file2 = o2.getWsdlFile(this.project.getBasedir());
                    if (file2 == null || !file2.exists() || !file2.getAbsoluteFile().equals(file)) continue;
                    o2.getExtraargs().addAll(0, o.getExtraargs());
                    duplicate = true;
                    break;
                }
                if (duplicate) continue;
                newList.add(o);
                continue;
            }
            newList.add(o);
        }
        effectiveWsdlOptions.clear();
        effectiveWsdlOptions.addAll(newList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean shouldRun(GenericWsdlOption genericWsdlOption, File doneFile, URI wsdlURI) {
        WsdlOption wsdlOption = (WsdlOption)genericWsdlOption;
        long timestamp = this.getTimestamp(wsdlURI);
        boolean doWork = false;
        if (!doneFile.exists()) {
            doWork = true;
        } else if (timestamp > doneFile.lastModified()) {
            doWork = true;
        } else if (wsdlOption.isDefServiceName()) {
            doWork = true;
        } else {
            URI[] dependencies = wsdlOption.getDependencyURIs(this.project.getBasedir().toURI());
            if (dependencies != null) {
                for (int z = 0; z < dependencies.length; ++z) {
                    long dependencyTimestamp = this.getTimestamp(dependencies[z]);
                    if (dependencyTimestamp <= doneFile.lastModified()) continue;
                    doWork = true;
                    break;
                }
            }
        }
        if (!doWork) {
            URI basedir = this.project.getBasedir().toURI();
            String options = wsdlOption.generateCommandLine(null, basedir, wsdlURI, false).toString();
            FilterInputStream reader = null;
            try {
                reader = new DataInputStream(new FileInputStream(doneFile));
                String s = ((DataInputStream)reader).readUTF();
                if (!options.equals(s)) {
                    doWork = true;
                }
            }
            catch (Exception ex) {
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return doWork;
    }

    @Override
    protected void createMarkerFile(GenericWsdlOption wsdlOption, File doneFile, URI wsdlURI) throws IOException {
        doneFile.createNewFile();
        URI basedir = this.project.getBasedir().toURI();
        String options = wsdlOption.generateCommandLine(null, basedir, wsdlURI, false).toString();
        DataOutputStream writer = new DataOutputStream(new FileOutputStream(doneFile));
        writer.writeUTF(options);
        writer.flush();
        writer.close();
    }

    protected long getTimestamp(URI uri) {
        long timestamp = 0L;
        URI baseURI = this.getBaseFileURI(uri);
        if ("file".equals(baseURI.getScheme())) {
            timestamp = new File(baseURI).lastModified();
        } else {
            try {
                timestamp = baseURI.toURL().openConnection().getDate();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return timestamp;
    }

    protected URI getBaseFileURI(URI uri) {
        String jarUrl;
        int embeddedUrlEndIndex;
        if ("classpath".equals(uri.getScheme())) {
            URL resource = ClassLoaderUtils.getResource((String)uri.toString().substring(10), ((Object)((Object)this)).getClass());
            if (resource != null) {
                try {
                    return this.getBaseFileURI(resource.toURI());
                }
                catch (URISyntaxException e) {}
            }
        } else if ("jar".equals(uri.getScheme()) && (embeddedUrlEndIndex = (jarUrl = uri.toString()).lastIndexOf("!/")) != -1) {
            String embeddedUrl = jarUrl.substring(4, embeddedUrlEndIndex);
            try {
                return this.getBaseFileURI(new URI(embeddedUrl));
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
        }
        return uri;
    }

    @Override
    protected List<String> generateCommandLine(GenericWsdlOption wsdlOption) throws MojoExecutionException {
        List<String> ret = super.generateCommandLine(wsdlOption);
        if (this.encoding != null) {
            ret.add(0, "-encoding");
            ret.add(1, this.encoding);
        }
        return ret;
    }

    @Override
    protected Bus generate(GenericWsdlOption genericWsdlOption, Bus bus, Set<URI> classPath) throws MojoExecutionException {
        WsdlOption wsdlOption = (WsdlOption)genericWsdlOption;
        File outputDirFile = wsdlOption.getOutputDir();
        outputDirFile.mkdirs();
        URI basedir = this.project.getBasedir().toURI();
        URI wsdlURI = wsdlOption.getWsdlURI(basedir);
        File doneFile = this.getDoneFile(basedir, wsdlURI, "java");
        if (!this.shouldRun(wsdlOption, doneFile, wsdlURI)) {
            return bus;
        }
        doneFile.delete();
        try {
            File file = new File(this.getBaseFileURI(wsdlURI));
            if (file.exists()) {
                this.buildContext.removeMessages(file);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (wsdlOption.getDependencies() != null) {
            for (URI dependency : wsdlOption.getDependencyURIs(this.project.getBasedir().toURI())) {
                URI baseDependency = this.getBaseFileURI(dependency);
                if (!"file".equals(baseDependency.getScheme())) continue;
                this.buildContext.removeMessages(new File(baseDependency));
            }
        }
        List<String> list = wsdlOption.generateCommandLine(outputDirFile, basedir, wsdlURI, this.getLog().isDebugEnabled());
        if (this.encoding != null) {
            list.add(0, "-encoding");
            list.add(1, this.encoding);
        }
        Object[] args = list.toArray(new String[list.size()]);
        this.getLog().debug((CharSequence)("Calling wsdl2java with args: " + Arrays.toString(args)));
        if (!"false".equals(this.fork)) {
            LinkedHashSet<URI> artifactsPath = new LinkedHashSet<URI>();
            for (Artifact a : this.pluginArtifacts) {
                File file = a.getFile();
                if (file == null) {
                    throw new MojoExecutionException("Unable to find " + file + " for artifact " + a.getGroupId() + ":" + a.getArtifactId() + ":" + a.getVersion());
                }
                artifactsPath.add(file.toURI());
            }
            this.addPluginArtifact(artifactsPath);
            artifactsPath.addAll(classPath);
            this.runForked(artifactsPath, WSDLToJava.class.getName(), (String[])args);
        } else {
            if (bus == null) {
                bus = BusFactory.newInstance().createBus();
                BusFactory.setThreadDefaultBus((Bus)bus);
            }
            try {
                ToolContext ctx = new ToolContext();
                final ArrayList files = new ArrayList();
                ArrayList<File> errorfiles = new ArrayList<File>();
                ctx.put(OutputStreamCreator.class, (Object)new OutputStreamCreator(){

                    public OutputStream createOutputStream(File file) throws IOException {
                        files.add(file);
                        return WSDL2JavaMojo.this.buildContext.newFileOutputStream(file);
                    }
                });
                ctx.setErrorListener((ToolErrorListener)new MavenToolErrorListener(errorfiles));
                new WSDLToJava((String[])args).run(ctx);
                List oldFiles = CastUtils.cast((List)((List)this.buildContext.getValue("cxf.file.list." + doneFile.getName())));
                if (oldFiles != null) {
                    for (File f : oldFiles) {
                        if (files.contains(f)) continue;
                        f.delete();
                        this.buildContext.refresh(f);
                    }
                }
                this.buildContext.setValue("cxf.file.list." + doneFile.getName(), files);
            }
            catch (Throwable e) {
                this.buildContext.setValue("cxf.file.list." + doneFile.getName(), null);
                this.getLog().debug(e);
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
        try {
            this.createMarkerFile(wsdlOption, doneFile, wsdlURI);
            this.buildContext.refresh(doneFile);
        }
        catch (Throwable e) {
            this.getLog().warn((CharSequence)("Could not create marker file " + doneFile.getAbsolutePath()));
            this.getLog().debug(e);
            throw new MojoExecutionException("Failed to create marker file " + doneFile.getAbsolutePath());
        }
        if (this.project != null && this.getGeneratedSourceRoot() != null && this.getGeneratedSourceRoot().exists()) {
            this.project.addCompileSourceRoot(this.getGeneratedSourceRoot().getAbsolutePath());
            this.buildContext.refresh(this.getGeneratedSourceRoot().getAbsoluteFile());
        }
        if (this.project != null && this.getGeneratedTestRoot() != null && this.getGeneratedTestRoot().exists()) {
            this.project.addTestCompileSourceRoot(this.getGeneratedTestRoot().getAbsolutePath());
            this.buildContext.refresh(this.getGeneratedTestRoot().getAbsoluteFile());
        }
        return bus;
    }

    @Override
    protected List<GenericWsdlOption> createWsdlOptionsFromScansAndExplicitWsdlOptions() throws MojoExecutionException {
        List<GenericWsdlOption> temp;
        ArrayList<GenericWsdlOption> effectiveWsdlOptions = new ArrayList<GenericWsdlOption>();
        if (this.wsdlOptions != null) {
            for (WsdlOption wo : this.wsdlOptions) {
                effectiveWsdlOptions.add(wo);
            }
        }
        if (this.wsdlRoot != null && this.wsdlRoot.exists() && !this.disableDirectoryScan) {
            temp = WsdlOptionLoader.loadWsdlOptionsFromFiles(this.wsdlRoot, this.includes, this.excludes, this.getGeneratedSourceRoot());
            effectiveWsdlOptions.addAll(temp);
        }
        if (this.testWsdlRoot != null && this.testWsdlRoot.exists() && !this.disableDirectoryScan) {
            temp = WsdlOptionLoader.loadWsdlOptionsFromFiles(this.testWsdlRoot, this.includes, this.excludes, this.getGeneratedTestRoot());
            effectiveWsdlOptions.addAll(temp);
        }
        if (!this.disableDependencyScan) {
            temp = WsdlOptionLoader.loadWsdlOptionsFromDependencies(this.project, this.getGeneratedSourceRoot());
            effectiveWsdlOptions.addAll(temp);
        }
        this.mergeOptions(effectiveWsdlOptions);
        this.downloadRemoteWsdls(effectiveWsdlOptions);
        return effectiveWsdlOptions;
    }

    @Override
    protected File getGeneratedSourceRoot() {
        return this.sourceRoot;
    }

    @Override
    protected File getGeneratedTestRoot() {
        return this.testSourceRoot;
    }

    @Override
    protected Class<?> getForkClass() {
        return ForkOnceWSDL2Java.class;
    }

    @Override
    public void execute() throws MojoExecutionException {
        this.defaultOptions.addDefaultBindingFileIfExists(this.project.getBasedir());
        super.execute();
    }

    @Override
    protected String getMarkerSuffix() {
        return "java";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class MavenToolErrorListener
    extends ToolErrorListener {
        private final List<File> errorfiles;

        MavenToolErrorListener(List<File> errorfiles) {
            this.errorfiles = errorfiles;
        }

        public void addError(final String file, int line, int column, String message, Throwable t) {
            super.addError(file, line, column, message, t);
            File f = this.mapFile(file);
            if (f != null && !this.errorfiles.contains(f)) {
                WSDL2JavaMojo.this.buildContext.removeMessages(f);
                this.errorfiles.add(f);
            }
            if (f == null) {
                f = file == null ? new File("null") : new File(file){
                    private static final long serialVersionUID = 1L;

                    public String getAbsolutePath() {
                        return file;
                    }
                };
            }
            WSDL2JavaMojo.this.buildContext.addMessage(f, line, column, message, 2, t);
        }

        public void addWarning(final String file, int line, int column, String message, Throwable t) {
            File f = this.mapFile(file);
            if (f != null && !this.errorfiles.contains(f)) {
                WSDL2JavaMojo.this.buildContext.removeMessages(f);
                this.errorfiles.add(f);
            }
            if (f == null) {
                f = new File(file){
                    private static final long serialVersionUID = 1L;

                    public String getAbsolutePath() {
                        return file;
                    }
                };
            }
            WSDL2JavaMojo.this.buildContext.addMessage(f, line, column, message, 1, t);
        }

        private File mapFile(String s) {
            File file = null;
            if (s != null && s.startsWith("file:")) {
                if (s.contains("#")) {
                    s = s.substring(0, s.indexOf(35));
                }
                try {
                    URI uri = new URI(s);
                    file = new File(uri);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            return file;
        }
    }
}

