/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven_plugin.wsdl2js;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.maven_plugin.AbstractCodegenMoho;
import org.apache.cxf.maven_plugin.GenericWsdlOption;
import org.apache.cxf.maven_plugin.WsdlUtilities;
import org.apache.cxf.maven_plugin.wsdl2js.ForkOnceWSDL2Javascript;
import org.apache.cxf.maven_plugin.wsdl2js.Option;
import org.apache.cxf.maven_plugin.wsdl2js.WsdlOption;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.wsdlto.javascript.WSDLToJavaScript;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="wsdl2js", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class WSDL2JavaScriptMojo
extends AbstractCodegenMoho {
    @Parameter(property="cxf.testJavascriptRoot")
    File testSourceRoot;
    @Parameter(required=true, defaultValue="${project.build.directory}/generated-sources/cxf-js", property="cxf.sourceJavascriptRoot")
    File sourceRoot;
    @Parameter
    Option defaultOptions = new Option();
    @Parameter
    WsdlOption[] wsdlOptions;

    @Override
    protected Bus generate(GenericWsdlOption genericWsdlOption, Bus bus, Set<URI> classPath) throws MojoExecutionException {
        URI wsdlURI;
        WsdlOption wsdlOption = (WsdlOption)genericWsdlOption;
        File outputDirFile = wsdlOption.getOutputDir();
        outputDirFile.mkdirs();
        URI basedir = this.project.getBasedir().toURI();
        try {
            wsdlURI = new URI(wsdlOption.getUri());
        }
        catch (URISyntaxException e) {
            throw new MojoExecutionException("Failed to get URI for wsdl " + wsdlOption.getUri(), (Exception)e);
        }
        File doneFile = this.getDoneFile(basedir, wsdlURI, "js");
        if (!this.shouldRun(wsdlOption, doneFile, wsdlURI)) {
            return bus;
        }
        doneFile.delete();
        List<String> list = wsdlOption.generateCommandLine(outputDirFile, basedir, wsdlURI, this.getLog().isDebugEnabled());
        Object[] args = list.toArray(new String[list.size()]);
        this.getLog().debug((CharSequence)("Calling wsdl2js with args: " + Arrays.toString(args)));
        if (!"false".equals(this.fork)) {
            LinkedHashSet<URI> artifactsPath = new LinkedHashSet<URI>();
            for (Artifact a : this.pluginArtifacts) {
                File file = a.getFile();
                if (file == null) {
                    throw new MojoExecutionException("Unable to find file for artifact " + a.getGroupId() + ":" + a.getArtifactId() + ":" + a.getVersion());
                }
                artifactsPath.add(file.toURI());
            }
            this.addPluginArtifact(artifactsPath);
            artifactsPath.addAll(classPath);
            this.runForked(artifactsPath, WSDLToJavaScript.class.getName(), (String[])args);
        } else {
            if (bus == null) {
                bus = BusFactory.newInstance().createBus();
                BusFactory.setThreadDefaultBus((Bus)bus);
            }
            try {
                new WSDLToJavaScript((String[])args).run(new ToolContext());
            }
            catch (Throwable e) {
                this.getLog().debug(e);
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
        try {
            this.createMarkerFile(wsdlOption, doneFile, wsdlURI);
        }
        catch (Throwable e) {
            this.getLog().warn((CharSequence)("Could not create marker file " + doneFile.getAbsolutePath()));
            this.getLog().debug(e);
            throw new MojoExecutionException("Failed to create marker file " + doneFile.getAbsolutePath());
        }
        if (this.project != null && this.getGeneratedSourceRoot() != null && this.getGeneratedSourceRoot().exists()) {
            this.project.addCompileSourceRoot(this.getGeneratedSourceRoot().getAbsolutePath());
        }
        if (this.project != null && this.getGeneratedTestRoot() != null && this.getGeneratedTestRoot().exists()) {
            this.project.addTestCompileSourceRoot(this.getGeneratedTestRoot().getAbsolutePath());
        }
        return bus;
    }

    @Override
    protected File getGeneratedSourceRoot() {
        return this.sourceRoot;
    }

    @Override
    protected File getGeneratedTestRoot() {
        return this.testSourceRoot;
    }

    @Override
    protected boolean shouldRun(GenericWsdlOption genericWsdlOption, File doneFile, URI wsdlURI) {
        WsdlOption wsdlOption = (WsdlOption)genericWsdlOption;
        long timestamp = 0L;
        if ("file".equals(wsdlURI.getScheme())) {
            timestamp = new File(wsdlURI).lastModified();
        } else {
            try {
                timestamp = wsdlURI.toURL().openConnection().getDate();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        boolean doWork = false;
        if (!doneFile.exists()) {
            doWork = true;
        } else if (timestamp > doneFile.lastModified()) {
            doWork = true;
        } else {
            File[] files = wsdlOption.getDependencies();
            if (files != null) {
                for (int z = 0; z < files.length; ++z) {
                    if (files[z].lastModified() <= doneFile.lastModified()) continue;
                    doWork = true;
                }
            }
        }
        return doWork;
    }

    protected void mergeOptions(List<GenericWsdlOption> effectiveWsdlOptions) {
        File outputDirFile = this.getGeneratedTestRoot() == null ? this.getGeneratedSourceRoot() : this.getGeneratedTestRoot();
        for (GenericWsdlOption wo : effectiveWsdlOptions) {
            WsdlOption option = (WsdlOption)wo;
            option.merge(this.defaultOptions);
            if (option.getOutput() != null) continue;
            option.setOutput(outputDirFile);
        }
    }

    @Override
    protected List<GenericWsdlOption> createWsdlOptionsFromScansAndExplicitWsdlOptions() throws MojoExecutionException {
        List<GenericWsdlOption> temp;
        ArrayList<GenericWsdlOption> effectiveWsdlOptions = new ArrayList<GenericWsdlOption>();
        if (this.wsdlOptions != null) {
            for (WsdlOption wo : this.wsdlOptions) {
                effectiveWsdlOptions.add(wo);
            }
        }
        if (this.wsdlRoot != null && this.wsdlRoot.exists() && !this.disableDirectoryScan) {
            temp = this.loadWsdlOptionsFromFiles(this.wsdlRoot, this.getGeneratedSourceRoot());
            effectiveWsdlOptions.addAll(temp);
        }
        if (this.testWsdlRoot != null && this.testWsdlRoot.exists() && !this.disableDirectoryScan) {
            temp = this.loadWsdlOptionsFromFiles(this.testWsdlRoot, this.getGeneratedTestRoot());
            effectiveWsdlOptions.addAll(temp);
        }
        if (!this.disableDependencyScan) {
            temp = WSDL2JavaScriptMojo.loadWsdlOptionsFromDependencies(this.project, this.defaultOptions, this.getGeneratedSourceRoot());
            effectiveWsdlOptions.addAll(temp);
        }
        this.mergeOptions(effectiveWsdlOptions);
        this.downloadRemoteWsdls(effectiveWsdlOptions);
        return effectiveWsdlOptions;
    }

    private List<GenericWsdlOption> loadWsdlOptionsFromFiles(File wsdlBasedir, File defaultOutputDir) throws MojoExecutionException {
        if (wsdlBasedir == null) {
            return Collections.emptyList();
        }
        if (!wsdlBasedir.exists()) {
            throw new MojoExecutionException(wsdlBasedir + " does not exist");
        }
        List<File> wsdlFiles = WsdlUtilities.getWsdlFiles(wsdlBasedir, this.includes, this.excludes);
        ArrayList<GenericWsdlOption> options = new ArrayList<GenericWsdlOption>();
        for (File wsdl : wsdlFiles) {
            WsdlOption wsdlOption = new WsdlOption();
            wsdlOption.setOutputDir(defaultOutputDir);
            wsdlOption.setUri(wsdl.toURI().toString());
            options.add(wsdlOption);
        }
        return options;
    }

    public static List<GenericWsdlOption> loadWsdlOptionsFromDependencies(MavenProject project, Option defaultOptions, File outputDir) {
        ArrayList<GenericWsdlOption> options = new ArrayList<GenericWsdlOption>();
        Set dependencies = CastUtils.cast((Set)project.getDependencyArtifacts());
        Iterator i$ = dependencies.iterator();
        while (i$.hasNext()) {
            WsdlOption option = new WsdlOption();
            Artifact artifact = (Artifact)i$.next();
            if (!WsdlUtilities.fillWsdlOptionFromArtifact(option, artifact, outputDir)) continue;
            if (defaultOptions != null) {
                option.merge(defaultOptions);
            }
            options.add(option);
        }
        return options;
    }

    @Override
    protected Class<?> getForkClass() {
        return ForkOnceWSDL2Javascript.class;
    }

    @Override
    protected String getMarkerSuffix() {
        return "js";
    }
}

