/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven_plugin;

import com.sun.tools.xjc.Driver;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.cxf.maven_plugin.XsdOption;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.ExitException;
import org.apache.tools.ant.util.optional.NoExitSecurityManager;

public class XSDToJavaMojo
extends AbstractMojo {
    String testSourceRoot;
    String sourceRoot;
    MavenProject project;
    XsdOption[] xsdOptions;
    File markerDirectory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        String outputDir = this.testSourceRoot == null ? this.sourceRoot : this.testSourceRoot;
        File outputDirFile = new File(outputDir);
        outputDirFile.mkdirs();
        this.markerDirectory.mkdirs();
        boolean result = true;
        if (this.xsdOptions == null) {
            throw new MojoExecutionException("Must specify xsdOptions");
        }
        for (int x = 0; x < this.xsdOptions.length; ++x) {
            block29: {
                String[] args = this.getArguments(this.xsdOptions[x], outputDir);
                String xsdLocation = this.xsdOptions[x].getXsd();
                File xsdFile = new File(xsdLocation);
                URI basedir = this.project.getBasedir().toURI();
                URI xsdURI = xsdFile.exists() ? xsdFile.toURI() : basedir.resolve(xsdLocation);
                String doneFileName = xsdURI.toString();
                if (doneFileName.startsWith(basedir.toString())) {
                    doneFileName = doneFileName.substring(basedir.toString().length());
                }
                doneFileName = doneFileName.replace('?', '_').replace('&', '_').replace('/', '_').replace('\\', '_');
                File doneFile = new File(this.markerDirectory, "." + doneFileName + ".DONE");
                long srctimestamp = 0L;
                if ("file".equals(xsdURI.getScheme())) {
                    srctimestamp = new File(xsdURI).lastModified();
                } else {
                    try {
                        srctimestamp = xsdURI.toURL().openConnection().getDate();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                boolean doWork = false;
                if (!doneFile.exists()) {
                    doWork = true;
                } else if (srctimestamp > doneFile.lastModified()) {
                    doWork = true;
                } else {
                    File[] files = this.xsdOptions[x].getDependencies();
                    if (files != null) {
                        for (int z = 0; z < files.length; ++z) {
                            if (files[z].lastModified() <= doneFile.lastModified()) continue;
                            doWork = true;
                        }
                    }
                }
                if (doWork) {
                    SecurityManager oldSm = System.getSecurityManager();
                    try {
                        int idx;
                        File[] dirs;
                        try {
                            System.setSecurityManager((SecurityManager)new NoExitSecurityManager());
                            Driver.main((String[])args);
                        }
                        catch (ExitException e) {
                            try {
                                if (e.getStatus() != 0) {
                                    throw e;
                                }
                                doneFile.delete();
                                doneFile.createNewFile();
                            }
                            catch (Throwable throwable) {
                                System.setSecurityManager(oldSm);
                                File[] dirs2 = this.xsdOptions[x].getDeleteDirs();
                                if (dirs2 != null) {
                                    for (int idx2 = 0; idx2 < dirs2.length; ++idx2) {
                                        result = result && this.deleteDir(dirs2[idx2]);
                                    }
                                }
                                throw throwable;
                            }
                            System.setSecurityManager(oldSm);
                            dirs = this.xsdOptions[x].getDeleteDirs();
                            if (dirs != null) {
                                for (idx = 0; idx < dirs.length; ++idx) {
                                    result = result && this.deleteDir(dirs[idx]);
                                }
                            }
                            break block29;
                        }
                        System.setSecurityManager(oldSm);
                        dirs = this.xsdOptions[x].getDeleteDirs();
                        if (dirs != null) {
                            for (idx = 0; idx < dirs.length; ++idx) {
                                result = result && this.deleteDir(dirs[idx]);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new MojoExecutionException(e.getMessage(), e);
                    }
                }
            }
            if (result) continue;
            throw new MojoExecutionException("Could not delete redundant dirs");
        }
        if (this.project != null && this.sourceRoot != null) {
            this.project.addCompileSourceRoot(this.sourceRoot);
        }
        if (this.project != null && this.testSourceRoot != null) {
            this.project.addTestCompileSourceRoot(this.testSourceRoot);
        }
    }

    private String[] getArguments(XsdOption option, String outputDir) {
        ArrayList<String> list = new ArrayList<String>();
        if (option.getPackagename() != null) {
            list.add("-p");
            list.add(option.getPackagename());
        }
        if (option.getBindingFile() != null) {
            list.add("-b");
            list.add(option.getBindingFile());
        }
        if (option.getCatalog() != null) {
            list.add("-catalog");
            list.add(option.getCatalog());
        }
        if (option.isExtension()) {
            list.add("-extension");
        }
        if (option.getExtensionArgs() != null) {
            Iterator it = option.getExtensionArgs().iterator();
            while (it.hasNext()) {
                list.add(it.next().toString());
            }
        }
        if (this.getLog().isDebugEnabled()) {
            list.add("-verbose");
        } else {
            list.add("-quiet");
        }
        list.add("-d");
        list.add(outputDir);
        list.add(option.getXsd());
        return list.toArray(new String[list.size()]);
    }

    private boolean deleteDir(File f) {
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            for (int idx = 0; idx < files.length; ++idx) {
                this.deleteDir(files[idx]);
            }
        }
        if (f.exists()) {
            return f.delete();
        }
        return true;
    }
}

