/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.cdi;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessProducerField;
import javax.enterprise.inject.spi.ProcessProducerMethod;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Feature;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.extension.ExtensionManagerBus;
import org.apache.cxf.cdi.CdiBusBean;
import org.apache.cxf.cdi.CdiResourceProvider;
import org.apache.cxf.cdi.DefaultApplicationBean;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.utils.ResourceUtils;

public class JAXRSCdiResourceExtension
implements Extension {
    private boolean hasBus;
    private Bus bus;
    private final Set<Bean<?>> applicationBeans = new LinkedHashSet();
    private final List<Bean<?>> serviceBeans = new ArrayList();
    private final List<Bean<?>> providerBeans = new ArrayList();
    private final List<Bean<? extends org.apache.cxf.feature.Feature>> featureBeans = new ArrayList<Bean<? extends org.apache.cxf.feature.Feature>>();
    private final List<CreationalContext<?>> disposableCreationalContexts = new ArrayList();

    public <T> void collect(@Observes ProcessBean<T> event) {
        if (event.getAnnotated().isAnnotationPresent(ApplicationPath.class)) {
            this.applicationBeans.add(event.getBean());
        } else if (event.getAnnotated().isAnnotationPresent(Path.class)) {
            this.serviceBeans.add(event.getBean());
        } else if (event.getAnnotated().isAnnotationPresent(Provider.class)) {
            this.providerBeans.add(event.getBean());
        } else if (event.getBean().getTypes().contains(Feature.class)) {
            this.providerBeans.add(event.getBean());
        } else if (event.getBean().getTypes().contains(org.apache.cxf.feature.Feature.class)) {
            this.featureBeans.add((Bean<? extends org.apache.cxf.feature.Feature>)event.getBean());
        } else if ("cxf".equals(event.getBean().getName()) && Bus.class.isAssignableFrom(event.getBean().getBeanClass())) {
            this.hasBus = true;
        }
    }

    public <T, X> void collect(@Observes ProcessProducerField<T, X> event) {
        Type baseType = event.getAnnotatedProducerField().getBaseType();
        this.processProducer((ProcessBean<T>)event, baseType);
    }

    public <T, X> void collect(@Observes ProcessProducerMethod<T, X> event) {
        Type baseType = event.getAnnotatedProducerMethod().getBaseType();
        this.processProducer((ProcessBean<T>)event, baseType);
    }

    public void load(@Observes AfterDeploymentValidation event, BeanManager beanManager) {
        Bean busBean = beanManager.resolve(beanManager.getBeans("cxf"));
        this.bus = (Bus)beanManager.getReference(busBean, Bus.class, beanManager.createCreationalContext((Contextual)busBean));
        for (Bean<?> application : this.applicationBeans) {
            JAXRSServerFactoryBean factory;
            Application instance = (Application)beanManager.getReference(application, (Type)application.getBeanClass(), this.createCreationalContext(beanManager, application));
            if (instance.getSingletons().isEmpty() && instance.getClasses().isEmpty()) {
                factory = this.createFactoryInstance(instance, this.loadServices(beanManager, Collections.emptySet()), this.loadProviders(beanManager, Collections.emptySet()), this.loadFeatures(beanManager, Collections.emptySet()));
                factory.init();
                continue;
            }
            factory = this.createFactoryInstance(instance, beanManager);
            factory.init();
        }
    }

    public void injectBus(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        if (!this.hasBus) {
            AnnotatedType busAnnotatedType = beanManager.createAnnotatedType(ExtensionManagerBus.class);
            InjectionTarget busInjectionTarget = beanManager.createInjectionTarget(busAnnotatedType);
            event.addBean((Bean)new CdiBusBean((InjectionTarget<ExtensionManagerBus>)busInjectionTarget));
        }
        if (this.applicationBeans.isEmpty() && !this.serviceBeans.isEmpty()) {
            DefaultApplicationBean applicationBean = new DefaultApplicationBean();
            this.applicationBeans.add(applicationBean);
            event.addBean((Bean)applicationBean);
        }
    }

    public void release(@Observes BeforeShutdown event) {
        for (CreationalContext<?> disposableCreationalContext : this.disposableCreationalContexts) {
            disposableCreationalContext.release();
        }
    }

    private JAXRSServerFactoryBean createFactoryInstance(Application application, List<?> services, List<?> providers, List<? extends org.apache.cxf.feature.Feature> features) {
        JAXRSServerFactoryBean instance = ResourceUtils.createApplication((Application)application, (boolean)false, (boolean)false, (boolean)false, (Bus)this.bus);
        instance.setServiceBeans(new ArrayList(services));
        instance.setProviders(providers);
        instance.setProviders(this.loadExternalProviders());
        instance.setFeatures(features);
        return instance;
    }

    private JAXRSServerFactoryBean createFactoryInstance(Application application, BeanManager beanManager) {
        JAXRSServerFactoryBean instance = ResourceUtils.createApplication((Application)application, (boolean)false, (boolean)false, (boolean)false, (Bus)this.bus);
        ClassifiedClasses classified = this.classes2singletons(application, beanManager);
        instance.setProviders(classified.getProviders());
        instance.getFeatures().addAll(classified.getFeatures());
        for (CdiResourceProvider resourceProvider : classified.getResourceProviders()) {
            instance.setResourceProvider(resourceProvider.getResourceClass(), (ResourceProvider)resourceProvider);
        }
        return instance;
    }

    private ClassifiedClasses classes2singletons(Application application, BeanManager beanManager) {
        ClassifiedClasses classified = new ClassifiedClasses();
        Set classes = application.getClasses();
        if (!classes.isEmpty()) {
            classified.addProviders(this.loadProviders(beanManager, classes));
            classified.addFeatures(this.loadFeatures(beanManager, classes));
            for (Bean<?> bean : this.serviceBeans) {
                if (!classes.contains(bean.getBeanClass())) continue;
                classified.addResourceProvider(new CdiResourceProvider(beanManager, bean));
            }
        }
        return classified;
    }

    private List<Object> loadExternalProviders() {
        ArrayList<Object> providers = new ArrayList<Object>();
        ServiceLoader<MessageBodyWriter> writers = ServiceLoader.load(MessageBodyWriter.class);
        for (MessageBodyWriter writer : writers) {
            providers.add(writer);
        }
        ServiceLoader<MessageBodyReader> readers = ServiceLoader.load(MessageBodyReader.class);
        for (MessageBodyReader reader : readers) {
            providers.add(reader);
        }
        return providers;
    }

    private List<Object> loadProviders(BeanManager beanManager, Collection<Class<?>> limitedClasses) {
        return this.loadBeans(beanManager, limitedClasses, this.providerBeans);
    }

    private List<Object> loadServices(BeanManager beanManager, Collection<Class<?>> limitedClasses) {
        return this.loadBeans(beanManager, limitedClasses, this.serviceBeans);
    }

    private List<Object> loadBeans(BeanManager beanManager, Collection<Class<?>> limitedClasses, Collection<Bean<?>> beans) {
        ArrayList<Object> instances = new ArrayList<Object>();
        for (Bean<?> bean : beans) {
            if (!limitedClasses.isEmpty() && !limitedClasses.contains(bean.getBeanClass())) continue;
            instances.add(beanManager.getReference(bean, Object.class, this.createCreationalContext(beanManager, bean)));
        }
        return instances;
    }

    private List<org.apache.cxf.feature.Feature> loadFeatures(BeanManager beanManager, Collection<Class<?>> limitedClasses) {
        ArrayList<org.apache.cxf.feature.Feature> features = new ArrayList<org.apache.cxf.feature.Feature>();
        for (Bean<? extends org.apache.cxf.feature.Feature> bean : this.featureBeans) {
            if (!limitedClasses.isEmpty() && !limitedClasses.contains(bean.getBeanClass())) continue;
            features.add((org.apache.cxf.feature.Feature)beanManager.getReference(bean, org.apache.cxf.feature.Feature.class, this.createCreationalContext(beanManager, bean)));
        }
        return features;
    }

    private <T> CreationalContext<T> createCreationalContext(BeanManager beanManager, Bean<T> bean) {
        CreationalContext creationalContext = beanManager.createCreationalContext(bean);
        if (!(bean instanceof DefaultApplicationBean)) {
            this.disposableCreationalContexts.add(creationalContext);
        }
        return creationalContext;
    }

    private <T> void processProducer(ProcessBean<T> event, Type baseType) {
        if (baseType instanceof Class) {
            Class clazz = (Class)baseType;
            if (clazz.isAnnotationPresent(Path.class)) {
                this.serviceBeans.add(event.getBean());
            } else if (clazz.isAnnotationPresent(Provider.class)) {
                this.providerBeans.add(event.getBean());
            } else if (clazz.isAnnotationPresent(ApplicationPath.class)) {
                this.applicationBeans.add(event.getBean());
            }
        }
    }

    private static class ClassifiedClasses {
        private List<Object> providers = new ArrayList<Object>();
        private List<org.apache.cxf.feature.Feature> features = new ArrayList<org.apache.cxf.feature.Feature>();
        private List<CdiResourceProvider> resourceProviders = new ArrayList<CdiResourceProvider>();

        private ClassifiedClasses() {
        }

        public void addProviders(Collection<Object> others) {
            this.providers.addAll(others);
        }

        public void addFeatures(Collection<org.apache.cxf.feature.Feature> others) {
            this.features.addAll(others);
        }

        public void addResourceProvider(CdiResourceProvider other) {
            this.resourceProviders.add(other);
        }

        public List<Object> getProviders() {
            return this.providers;
        }

        public List<org.apache.cxf.feature.Feature> getFeatures() {
            return this.features;
        }

        public List<CdiResourceProvider> getResourceProviders() {
            return this.resourceProviders;
        }
    }
}

