/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.cdi;

import java.lang.reflect.Type;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.message.Message;

public class CdiResourceProvider
implements ResourceProvider {
    private Object instance;
    private CreationalContext<?> context;
    private final BeanManager beanManager;
    private final Bean<?> bean;

    CdiResourceProvider(BeanManager beanManager, Bean<?> bean) {
        this.beanManager = beanManager;
        this.bean = bean;
    }

    public Object getInstance(Message m) {
        if (this.instance == null) {
            this.context = this.beanManager.createCreationalContext(this.bean);
            this.instance = this.beanManager.getReference(this.bean, (Type)this.bean.getBeanClass(), this.context);
        }
        return this.instance;
    }

    public void releaseInstance(Message m, Object o) {
        if (this.context != null) {
            this.context.release();
            this.instance = null;
        }
    }

    public Class<?> getResourceClass() {
        return this.bean.getBeanClass();
    }

    public boolean isSingleton() {
        return !this.bean.getScope().isAssignableFrom(RequestScoped.class);
    }
}

