/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.PassivationCapable;
import org.apache.cxf.cdi.AbstractCXFBean;
import org.apache.cxf.cdi.ContextResolved;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;

public class ContextProducerBean
extends AbstractCXFBean<Object>
implements PassivationCapable {
    private final Type type;

    ContextProducerBean(Type type) {
        this.type = type;
    }

    @Override
    public Set<Annotation> getQualifiers() {
        HashSet<Annotation> qualifiers = new HashSet<Annotation>(2);
        qualifiers.add(ContextResolved.LITERAL);
        qualifiers.add((Annotation)DEFAULT);
        return qualifiers;
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return RequestScoped.class;
    }

    public Class<?> getBeanClass() {
        return (Class)this.type;
    }

    public Object create(CreationalContext<Object> creationalContext) {
        return this.createContextValue();
    }

    @Override
    public boolean isNullable() {
        return true;
    }

    @Override
    public Set<Type> getTypes() {
        Set<Type> types = super.getTypes();
        types.add(this.type);
        return types;
    }

    public String getName() {
        return "CxfContextProducer" + this.type;
    }

    private Object createContextValue() {
        Class contextType;
        Message currentMessage = PhaseInterceptorChain.getCurrentMessage();
        Type genericType = null;
        if (this.type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)this.type;
            genericType = parameterizedType.getActualTypeArguments()[0];
            contextType = (Class)parameterizedType.getRawType();
        } else {
            contextType = (Class)this.type;
        }
        return JAXRSUtils.createContextValue((Message)currentMessage, genericType, (Class)contextType);
    }

    public String getId() {
        return this.getName();
    }
}

