/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.brave.internal;

import brave.http.HttpServerAdapter;
import java.util.List;
import org.apache.cxf.tracing.brave.internal.HttpAdapterFactory;

public abstract class HttpServerAdapterFactory
extends HttpAdapterFactory {
    public static HttpServerAdapter<HttpAdapterFactory.Request, HttpAdapterFactory.Response> create(HttpAdapterFactory.Request request) {
        return new HttpServerAdapter<HttpAdapterFactory.Request, HttpAdapterFactory.Response>(){

            public String method(HttpAdapterFactory.Request request) {
                return request.method();
            }

            public String path(HttpAdapterFactory.Request request) {
                return request.uri().getPath();
            }

            public String url(HttpAdapterFactory.Request request) {
                return request.uri().toString();
            }

            public String requestHeader(HttpAdapterFactory.Request request, String name) {
                List<String> value = request.headers().get(name);
                if (value != null && !value.isEmpty()) {
                    return value.get(0);
                }
                return null;
            }

            public Integer statusCode(HttpAdapterFactory.Response response) {
                throw new UnsupportedOperationException("The operation is not supported for request adapter");
            }
        };
    }

    public static HttpServerAdapter<HttpAdapterFactory.Request, HttpAdapterFactory.Response> create(HttpAdapterFactory.Response response) {
        return new HttpServerAdapter<HttpAdapterFactory.Request, HttpAdapterFactory.Response>(){

            public String method(HttpAdapterFactory.Request request) {
                throw new UnsupportedOperationException("The operation is not supported for response adapter");
            }

            public String path(HttpAdapterFactory.Request request) {
                throw new UnsupportedOperationException("The operation is not supported for response adapter");
            }

            public String url(HttpAdapterFactory.Request request) {
                throw new UnsupportedOperationException("The operation is not supported for response adapter");
            }

            public String requestHeader(HttpAdapterFactory.Request request, String name) {
                throw new UnsupportedOperationException("The operation is not supported for response adapter");
            }

            public Integer statusCode(HttpAdapterFactory.Response response) {
                return response.status();
            }
        };
    }
}

