/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.brave;

import brave.Span;
import brave.Tracer;
import brave.http.HttpTracing;
import java.util.concurrent.Callable;
import org.apache.cxf.tracing.Traceable;
import org.apache.cxf.tracing.TracerContext;
import org.apache.cxf.tracing.brave.TraceScope;

public class BraveTracerContext
implements TracerContext {
    private final HttpTracing brave;
    private final Tracer tracer;
    private final Span continuationSpan;

    public BraveTracerContext(HttpTracing brave) {
        this(brave, null);
    }

    public BraveTracerContext(HttpTracing brave, Span continuationSpan) {
        this.brave = brave;
        this.tracer = brave.tracing().tracer();
        this.continuationSpan = continuationSpan;
    }

    public TraceScope startSpan(String description) {
        return new TraceScope(this.brave, this.tracer.nextSpan().name(description).start());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T continueSpan(Traceable<T> traceable) throws Exception {
        Tracer.SpanInScope scope = null;
        if (this.tracer.currentSpan() == null && this.continuationSpan != null) {
            scope = this.tracer.withSpanInScope(this.continuationSpan);
        }
        try {
            Object object = traceable.call((TracerContext)new BraveTracerContext(this.brave));
            return (T)object;
        }
        finally {
            if (this.continuationSpan != null && scope != null) {
                scope.close();
            }
        }
    }

    public <T> Callable<T> wrap(final String description, final Traceable<T> traceable) {
        final Callable callable = new Callable<T>(){

            @Override
            public T call() throws Exception {
                return traceable.call((TracerContext)new BraveTracerContext(BraveTracerContext.this.brave));
            }
        };
        final Span parent = this.tracer.currentSpan();
        return new Callable<T>(){

            @Override
            public T call() throws Exception {
                try (TraceScope span = BraveTracerContext.this.newOrChildSpan(description, parent);){
                    Object v = callable.call();
                    return v;
                }
            }
        };
    }

    public void annotate(String key, String value) {
        Span current = this.tracer.currentSpan();
        if (current != null) {
            current.tag(key, value);
        }
    }

    public void timeline(String message) {
        Span current = this.tracer.currentSpan();
        if (current != null) {
            current.annotate(message);
        }
    }

    private TraceScope newOrChildSpan(String description, Span parent) {
        if (parent == null) {
            return new TraceScope(this.brave, this.tracer.newTrace().name(description).start());
        }
        return new TraceScope(this.brave, this.tracer.newChild(parent.context()).name(description).start());
    }
}

