/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.brave;

import brave.Tracing;
import brave.http.HttpServerParser;
import brave.http.HttpTracing;
import java.util.UUID;
import org.apache.cxf.Bus;
import org.apache.cxf.annotations.Provider;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.tracing.brave.BraveStartInterceptor;
import org.apache.cxf.tracing.brave.BraveStopInterceptor;
import org.apache.cxf.tracing.brave.HttpServerSpanParser;

@NoJSR250Annotations
@Provider(value=Provider.Type.Feature, scope=Provider.Scope.Server)
public class BraveFeature
extends AbstractFeature {
    private BraveStartInterceptor in;
    private BraveStopInterceptor out;

    public BraveFeature() {
        this("cxf-svc-" + UUID.randomUUID().toString());
    }

    public BraveFeature(String name) {
        this(HttpTracing.newBuilder((Tracing)Tracing.newBuilder().localServiceName(name).build()).serverParser((HttpServerParser)new HttpServerSpanParser()).build());
    }

    public BraveFeature(Tracing tracing) {
        this(HttpTracing.newBuilder((Tracing)tracing).serverParser((HttpServerParser)new HttpServerSpanParser()).build());
    }

    public BraveFeature(HttpTracing brave) {
        this.in = new BraveStartInterceptor(brave);
        this.out = new BraveStopInterceptor(brave);
    }

    protected void initializeProvider(InterceptorProvider provider, Bus bus) {
        provider.getInInterceptors().add(this.in);
        provider.getInFaultInterceptors().add(this.in);
        provider.getOutInterceptors().add(this.out);
        provider.getOutFaultInterceptors().add(this.out);
    }
}

