/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.brave;

import brave.Span;
import brave.Tracer;
import brave.http.HttpServerAdapter;
import brave.http.HttpServerHandler;
import brave.http.HttpTracing;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.tracing.AbstractTracingProvider;
import org.apache.cxf.tracing.brave.TraceScope;
import org.apache.cxf.tracing.brave.internal.HttpAdapterFactory;
import org.apache.cxf.tracing.brave.internal.HttpServerAdapterFactory;

public abstract class AbstractBraveProvider
extends AbstractTracingProvider {
    protected static final Logger LOG = LogUtils.getL7dLogger(AbstractBraveProvider.class);
    protected static final String TRACE_SPAN = "org.apache.cxf.tracing.brave.span";
    protected final HttpTracing brave;

    protected AbstractBraveProvider(HttpTracing brave) {
        this.brave = brave;
    }

    protected AbstractTracingProvider.TraceScopeHolder<TraceScope> startTraceSpan(Map<String, List<String>> requestHeaders, URI uri, String method) {
        HttpAdapterFactory.Request request = HttpAdapterFactory.request(requestHeaders, uri, method);
        HttpServerAdapter<HttpAdapterFactory.Request, HttpAdapterFactory.Response> adapter = HttpServerAdapterFactory.create(request);
        HttpServerHandler handler = HttpServerHandler.create((HttpTracing)this.brave, adapter);
        Span span = handler.handleReceive(this.brave.tracing().propagation().extractor((arg_0, arg_1) -> adapter.requestHeader(arg_0, arg_1)), (Object)request);
        Tracer.SpanInScope scope = null;
        if (this.isAsyncResponse() && span != null) {
            this.propagateContinuationSpan(span);
        } else if (span != null) {
            scope = this.brave.tracing().tracer().withSpanInScope(span);
        }
        return new AbstractTracingProvider.TraceScopeHolder((Object)new TraceScope(span, scope), scope == null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopTraceSpan(Map<String, List<String>> requestHeaders, Map<String, List<Object>> responseHeaders, int responseStatus, AbstractTracingProvider.TraceScopeHolder<TraceScope> holder) {
        this.brave.tracing().propagation().keys().forEach(key -> this.transferRequestHeader(requestHeaders, responseHeaders, (String)key));
        if (holder == null) {
            return;
        }
        TraceScope scope = (TraceScope)holder.getScope();
        if (scope != null) {
            try {
                if (holder.isDetached()) {
                    this.brave.tracing().tracer().joinSpan(scope.getSpan().context());
                }
                HttpAdapterFactory.Response response = HttpAdapterFactory.response(responseStatus);
                HttpServerAdapter<HttpAdapterFactory.Request, HttpAdapterFactory.Response> adapter = HttpServerAdapterFactory.create(response);
                HttpServerHandler handler = HttpServerHandler.create((HttpTracing)this.brave, adapter);
                handler.handleSend((Object)response, null, scope.getSpan());
            }
            finally {
                scope.close();
            }
        }
    }

    protected boolean isAsyncResponse() {
        return !PhaseInterceptorChain.getCurrentMessage().getExchange().isSynchronous();
    }

    private void propagateContinuationSpan(Span continuationScope) {
        PhaseInterceptorChain.getCurrentMessage().put(Span.class, (Object)continuationScope);
    }

    private void transferRequestHeader(Map<String, List<String>> requestHeaders, Map<String, List<Object>> responseHeaders, String header) {
        if (requestHeaders.containsKey(header)) {
            responseHeaders.put(header, CastUtils.cast(requestHeaders.get(header)));
        }
    }
}

