/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.brave;

import brave.Tracing;
import brave.http.HttpClientParser;
import brave.http.HttpTracing;
import org.apache.cxf.Bus;
import org.apache.cxf.annotations.Provider;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.feature.AbstractPortableFeature;
import org.apache.cxf.feature.DelegatingFeature;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.tracing.brave.BraveClientStartInterceptor;
import org.apache.cxf.tracing.brave.BraveClientStopInterceptor;
import org.apache.cxf.tracing.brave.HttpClientSpanParser;

@NoJSR250Annotations
@Provider(value=Provider.Type.Feature, scope=Provider.Scope.Client)
public class BraveClientFeature
extends DelegatingFeature<Portable> {
    public BraveClientFeature(Tracing tracing) {
        super((AbstractPortableFeature)new Portable(tracing));
    }

    public BraveClientFeature(HttpTracing brave) {
        super((AbstractPortableFeature)new Portable(brave));
    }

    @Provider(value=Provider.Type.Feature, scope=Provider.Scope.Client)
    public static class Portable
    implements AbstractPortableFeature {
        private BraveClientStartInterceptor out;
        private BraveClientStopInterceptor in;

        public Portable(Tracing tracing) {
            this(HttpTracing.newBuilder((Tracing)tracing).clientParser((HttpClientParser)new HttpClientSpanParser()).build());
        }

        public Portable(HttpTracing brave) {
            this.out = new BraveClientStartInterceptor(brave);
            this.in = new BraveClientStopInterceptor(brave);
        }

        public void doInitializeProvider(InterceptorProvider provider, Bus bus) {
            provider.getInInterceptors().add(this.in);
            provider.getOutInterceptors().add(this.out);
        }
    }
}

