/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.brave.internal;

import brave.http.HttpServerRequest;
import brave.http.HttpServerResponse;
import java.util.List;
import org.apache.cxf.tracing.brave.internal.HttpAdapterFactory;

public interface HttpServerAdapterFactory
extends HttpAdapterFactory {
    public static HttpServerRequest create(final HttpAdapterFactory.Request request) {
        return new HttpServerRequest(){

            public String method() {
                return request.method();
            }

            public String path() {
                return request.uri().getPath();
            }

            public String route() {
                return this.path();
            }

            public String url() {
                return request.uri().toString();
            }

            public String header(String name) {
                List<String> value = request.headers().get(name);
                if (value != null && !value.isEmpty()) {
                    return value.get(0);
                }
                return null;
            }

            public HttpAdapterFactory.Request unwrap() {
                return request;
            }
        };
    }

    public static HttpServerResponse create(final HttpAdapterFactory.Response response) {
        return new HttpServerResponse(){

            public String method() {
                return response.method();
            }

            public String route() {
                return response.path();
            }

            public int statusCode() {
                return response.status();
            }

            public HttpAdapterFactory.Response unwrap() {
                return response;
            }
        };
    }
}

