/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.brave.jaxrs;

import brave.Tracing;
import brave.http.HttpRequestParser;
import brave.http.HttpResponseParser;
import brave.http.HttpTracing;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.client.ClientResponseFilter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.cxf.tracing.AbstractTracingProvider;
import org.apache.cxf.tracing.brave.AbstractBraveClientProvider;
import org.apache.cxf.tracing.brave.HttpClientRequestParser;
import org.apache.cxf.tracing.brave.HttpClientResponseParser;
import org.apache.cxf.tracing.brave.TraceScope;

@Provider
public class BraveClientProvider
extends AbstractBraveClientProvider
implements ClientRequestFilter,
ClientResponseFilter {
    public BraveClientProvider(Tracing brave) {
        this(HttpTracing.newBuilder((Tracing)brave).clientRequestParser((HttpRequestParser)new HttpClientRequestParser()).clientResponseParser((HttpResponseParser)new HttpClientResponseParser()).build());
    }

    public BraveClientProvider(HttpTracing brave) {
        super(brave);
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        AbstractTracingProvider.TraceScopeHolder<TraceScope> holder = super.startTraceSpan((Map<String, List<String>>)requestContext.getStringHeaders(), requestContext.getUri(), requestContext.getMethod());
        if (holder != null) {
            requestContext.setProperty("org.apache.cxf.tracing.client.brave.span", holder);
        }
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        AbstractTracingProvider.TraceScopeHolder holder = (AbstractTracingProvider.TraceScopeHolder)requestContext.getProperty("org.apache.cxf.tracing.client.brave.span");
        super.stopTraceSpan((AbstractTracingProvider.TraceScopeHolder<TraceScope>)holder, requestContext.getMethod(), requestContext.getUri(), responseContext.getStatus());
    }
}

