/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.htrace;

import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.tracing.AbstractTracingProvider;
import org.apache.htrace.Sampler;
import org.apache.htrace.Span;
import org.apache.htrace.Trace;
import org.apache.htrace.TraceScope;
import org.apache.htrace.Tracer;
import org.apache.htrace.impl.MilliSpan;

public abstract class AbstractHTraceProvider
extends AbstractTracingProvider {
    protected static final Logger LOG = LogUtils.getL7dLogger(AbstractHTraceProvider.class);
    protected static final String TRACE_SPAN = "org.apache.cxf.tracing.htrace.span";
    private final Sampler<?> sampler;

    public AbstractHTraceProvider(Sampler<?> sampler) {
        this.sampler = sampler;
    }

    protected TraceScope startTraceSpan(Map<String, List<String>> requestHeaders, String path) {
        long traceId = AbstractHTraceProvider.getFirstValueOrDefault(requestHeaders, AbstractHTraceProvider.getTraceIdHeader(), Tracer.DONT_TRACE.traceId);
        long spanId = AbstractHTraceProvider.getFirstValueOrDefault(requestHeaders, AbstractHTraceProvider.getSpanIdHeader(), Tracer.DONT_TRACE.spanId);
        if (traceId == Tracer.DONT_TRACE.traceId || spanId == Tracer.DONT_TRACE.spanId) {
            return Trace.startSpan((String)path, this.sampler);
        }
        return Trace.startSpan((String)path, (Span)new MilliSpan.Builder().spanId(spanId).traceId(traceId).build());
    }

    protected void stopTraceSpan(Map<String, List<String>> requestHeaders, Map<String, List<Object>> responseHeaders, TraceScope span) {
        String traceIdHeader = AbstractHTraceProvider.getTraceIdHeader();
        String spanIdHeader = AbstractHTraceProvider.getSpanIdHeader();
        if (requestHeaders.containsKey(traceIdHeader) && requestHeaders.containsKey(spanIdHeader)) {
            responseHeaders.put(traceIdHeader, CastUtils.cast(requestHeaders.get(traceIdHeader)));
            responseHeaders.put(spanIdHeader, CastUtils.cast(requestHeaders.get(spanIdHeader)));
        }
        if (span != null) {
            span.close();
        }
    }

    private static Long getFirstValueOrDefault(Map<String, List<String>> headers, String header, long defaultValue) {
        List<String> value = headers.get(header);
        if (value != null && !value.isEmpty()) {
            try {
                return Long.parseLong(value.get(0));
            }
            catch (NumberFormatException ex) {
                LOG.log(Level.FINE, String.format("Unable to parse '%s' header value to long number", header), ex);
            }
        }
        return defaultValue;
    }
}

