/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.htrace.jaxrs;

import java.io.IOException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.tracing.AbstractTracingProvider;
import org.apache.htrace.Sampler;
import org.apache.htrace.Span;
import org.apache.htrace.Trace;
import org.apache.htrace.TraceScope;
import org.apache.htrace.impl.NeverSampler;

@Provider
public class HTraceClientProvider
extends AbstractTracingProvider
implements ClientRequestFilter,
ClientResponseFilter {
    private static final String TRACE_SPAN = "org.apache.cxf.tracing.client.htrace.span";
    private final Sampler<?> sampler;

    public HTraceClientProvider() {
        this((Sampler<?>)NeverSampler.INSTANCE);
    }

    public HTraceClientProvider(Sampler<?> sampler) {
        this.sampler = sampler;
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        TraceScope scope;
        Span span = Trace.currentSpan();
        if (span == null && (span = (scope = Trace.startSpan((String)requestContext.getUri().toString(), this.sampler)).getSpan()) != null) {
            requestContext.setProperty(TRACE_SPAN, (Object)scope);
        }
        if (span != null) {
            MultivaluedMap requestHeaders = requestContext.getHeaders();
            String traceIdHeader = HTraceClientProvider.getTraceIdHeader();
            String spanIdHeader = HTraceClientProvider.getSpanIdHeader();
            requestHeaders.putSingle((Object)traceIdHeader, (Object)Long.toString(span.getTraceId()));
            requestHeaders.putSingle((Object)spanIdHeader, (Object)Long.toString(span.getSpanId()));
        }
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        TraceScope scope = (TraceScope)requestContext.getProperty(TRACE_SPAN);
        if (scope != null) {
            scope.close();
        }
    }
}

