/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.htrace;

import java.util.concurrent.Callable;
import org.apache.cxf.tracing.Traceable;
import org.apache.cxf.tracing.TracerContext;
import org.apache.htrace.core.Span;
import org.apache.htrace.core.TraceScope;
import org.apache.htrace.core.Tracer;

public class HTraceTracerContext
implements TracerContext {
    private final Tracer tracer;
    private final TraceScope continuationScope;

    public HTraceTracerContext(Tracer tracer) {
        this(tracer, null);
    }

    public HTraceTracerContext(Tracer tracer, TraceScope continuationScope) {
        this.tracer = tracer;
        this.continuationScope = continuationScope;
    }

    public TraceScope startSpan(String description) {
        return this.tracer.newScope(description);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T continueSpan(Traceable<T> traceable) throws Exception {
        boolean attached = false;
        if (!this.isTracing() && this.continuationScope != null) {
            this.continuationScope.reattach();
            attached = true;
        }
        try {
            Object object = traceable.call((TracerContext)new HTraceTracerContext(this.tracer));
            return (T)object;
        }
        finally {
            if (this.continuationScope != null && attached) {
                this.continuationScope.detach();
            }
        }
    }

    public <T> Callable<T> wrap(String description, final Traceable<T> traceable) {
        Callable callable = new Callable<T>(){

            @Override
            public T call() throws Exception {
                return traceable.call((TracerContext)new HTraceTracerContext(HTraceTracerContext.this.tracer));
            }
        };
        return this.tracer.wrap(callable, description);
    }

    public void annotate(String key, String value) {
        Span currentSpan = Tracer.getCurrentSpan();
        if (currentSpan != null) {
            currentSpan.addKVAnnotation(key, value);
        }
    }

    public void timeline(String message) {
        Span currentSpan = Tracer.getCurrentSpan();
        if (currentSpan != null) {
            currentSpan.addTimelineAnnotation(message);
        }
    }

    private boolean isTracing() {
        return Tracer.getCurrentSpan() != null;
    }
}

