/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.htrace.jaxrs;

import java.util.Arrays;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.tracing.htrace.jaxrs.HTraceContextProvider;
import org.apache.cxf.tracing.htrace.jaxrs.HTraceProvider;
import org.apache.htrace.core.HTraceConfiguration;
import org.apache.htrace.core.Tracer;

public class HTraceFeature
extends AbstractFeature {
    private HTraceConfiguration configuration;
    private String name;

    public HTraceFeature() {
        this(HTraceConfiguration.EMPTY, "");
    }

    public HTraceFeature(HTraceConfiguration configuration, String name) {
        this.configuration = configuration;
        this.name = name;
    }

    public void initialize(Server server, Bus bus) {
        ServerProviderFactory providerFactory = (ServerProviderFactory)server.getEndpoint().get((Object)ServerProviderFactory.class.getName());
        Tracer tracer = new Tracer.Builder(this.name).conf(this.configuration).build();
        if (providerFactory != null) {
            providerFactory.setUserProviders(Arrays.asList(new Object[]{new HTraceProvider(tracer), new HTraceContextProvider(tracer)}));
        }
    }

    public void setConfiguration(HTraceConfiguration configuration) {
        this.configuration = configuration;
    }

    public HTraceConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }
}

