/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.htrace;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.tracing.AbstractTracingProvider;
import org.apache.htrace.core.Span;
import org.apache.htrace.core.TraceScope;
import org.apache.htrace.core.Tracer;

public abstract class AbstractHTraceClientProvider
extends AbstractTracingProvider {
    protected static final Logger LOG = LogUtils.getL7dLogger(AbstractHTraceClientProvider.class);
    protected static final String TRACE_SPAN = "org.apache.cxf.tracing.client.htrace.span";
    private final Tracer tracer;

    public AbstractHTraceClientProvider(Tracer tracer) {
        this.tracer = tracer;
    }

    protected AbstractTracingProvider.TraceScopeHolder<TraceScope> startTraceSpan(Map<String, List<String>> requestHeaders, String path, String method) {
        Span span = Tracer.getCurrentSpan();
        TraceScope traceScope = null;
        if (span == null) {
            traceScope = this.tracer.newScope(this.buildSpanDescription(path, method));
            span = traceScope.getSpan();
        }
        if (span != null) {
            String spanIdHeader = AbstractHTraceClientProvider.getSpanIdHeader();
            requestHeaders.put(spanIdHeader, Collections.singletonList(span.getSpanId().toString()));
        }
        boolean detached = false;
        if (this.isAsyncInvocation() && traceScope != null) {
            traceScope.detach();
            detached = true;
        }
        return new AbstractTracingProvider.TraceScopeHolder((Object)traceScope, detached);
    }

    private boolean isAsyncInvocation() {
        return !JAXRSUtils.getCurrentMessage().getExchange().isSynchronous();
    }

    protected void stopTraceSpan(AbstractTracingProvider.TraceScopeHolder<TraceScope> holder) {
        if (holder == null) {
            return;
        }
        TraceScope scope = (TraceScope)holder.getScope();
        if (scope != null) {
            if (holder.isDetached()) {
                scope.reattach();
                scope.close();
            } else {
                scope.close();
            }
        }
    }
}

