/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.htrace.ext;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.htrace.core.HTraceConfiguration;
import org.apache.htrace.core.Span;
import org.apache.htrace.core.SpanReceiver;
import org.apache.htrace.core.TimelineAnnotation;

public class LoggingSpanReceiver
extends SpanReceiver {
    public static final String LOG_LEVEL_KEY = "cxf.log.level";
    public static final String LOG_LEVEL_ERROR = Level.SEVERE.getName();
    public static final String LOG_LEVEL_DEBUG = Level.FINE.getName();
    public static final String LOG_LEVEL_INFO = Level.INFO.getName();
    public static final String LOG_LEVEL_WARN = Level.WARNING.getName();
    private static final Logger LOG = LogUtils.getL7dLogger(LoggingSpanReceiver.class);
    private final Level level;
    private final Stringifier<TimelineAnnotation> timelineStringifier = new Stringifier<TimelineAnnotation>(){

        @Override
        public String toString(TimelineAnnotation annotation) {
            StringBuilder sb = new StringBuilder();
            LoggingSpanReceiver.this.append(sb, "time", annotation.getTime());
            LoggingSpanReceiver.this.append(sb, "message", annotation.getMessage(), true);
            return "[" + sb.toString() + "]";
        }
    };

    public LoggingSpanReceiver(HTraceConfiguration conf) {
        this.level = Level.parse(conf.get(LOG_LEVEL_KEY, LOG_LEVEL_DEBUG));
    }

    public void receiveSpan(Span span) {
        LOG.log(this.level, this.toString(span));
    }

    public void close() throws IOException {
    }

    private String toString(Span span) {
        String tracerId;
        StringBuilder sb = new StringBuilder();
        if (span.getSpanId().isValid()) {
            this.append(sb, "spanId", span.getSpanId().toString());
        }
        if (!StringUtils.isEmpty((String)(tracerId = span.getTracerId()))) {
            this.append(sb, "tracerId", tracerId, true);
        }
        if (span.getStartTimeMillis() != 0L) {
            this.append(sb, "start", span.getStartTimeMillis());
        }
        if (span.getStopTimeMillis() != 0L) {
            this.append(sb, "stop", span.getStopTimeMillis());
        }
        if (!StringUtils.isEmpty((String)span.getDescription())) {
            this.append(sb, "description", span.getDescription(), true);
        }
        this.append(sb, "parents", span.getParents());
        this.append(sb, "kvs", span.getKVAnnotations());
        this.append(sb, "timelines", span.getTimelineAnnotations(), this.timelineStringifier);
        return sb.toString();
    }

    private void append(StringBuilder sb, String key, Map<String, String> values) {
        StringBuilder inner = new StringBuilder();
        for (Map.Entry<String, String> entry : values.entrySet()) {
            this.append(inner, this.quote(entry.getKey()), entry.getValue(), true);
        }
        this.append(sb, key, inner.insert(0, "[").append("]").toString());
    }

    private <T> void append(StringBuilder sb, String key, Collection<T> values, Stringifier<T> stringifier) {
        this.append(sb, key, this.toString(values, stringifier));
    }

    private <T> void append(StringBuilder sb, String key, T[] values) {
        this.append(sb, key, this.toString(values));
    }

    private void append(StringBuilder sb, String key, long value) {
        this.append(sb, key, Long.toString(value));
    }

    private void append(StringBuilder sb, String key, String value) {
        this.append(sb, key, value, false);
    }

    private void append(StringBuilder sb, String key, String value, boolean quoted) {
        if (sb.length() > 0) {
            sb.append(" ");
        }
        sb.append(key).append("=");
        this.quote(sb, value, quoted);
    }

    private String quote(String value) {
        StringBuilder sb = new StringBuilder();
        this.quote(sb, value, true);
        return sb.toString();
    }

    private <T> String toString(Collection<T> values, Stringifier<T> stringifier) {
        ArrayList<String> converted = new ArrayList<String>();
        for (T value : values) {
            converted.add(stringifier.toString(value));
        }
        return Arrays.toString(converted.toArray());
    }

    private <T> String toString(T[] values) {
        ArrayList<String> converted = new ArrayList<String>();
        for (T value : values) {
            converted.add(value.toString());
        }
        return Arrays.toString(converted.toArray());
    }

    private void quote(StringBuilder sb, String value, boolean quoted) {
        if (quoted) {
            sb.append("\"");
        }
        sb.append(value);
        if (quoted) {
            sb.append("\"");
        }
    }

    private static interface Stringifier<T> {
        public String toString(T var1);
    }
}

