/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.opentracing;

import io.opentracing.ActiveSpan;
import io.opentracing.BaseSpan;
import io.opentracing.Tracer;
import java.util.concurrent.Callable;
import org.apache.cxf.tracing.Traceable;
import org.apache.cxf.tracing.TracerContext;

public class OpenTracingContext
implements TracerContext {
    private final Tracer tracer;
    private final ActiveSpan.Continuation continuation;

    public OpenTracingContext(Tracer tracer) {
        this(tracer, null);
    }

    public OpenTracingContext(Tracer tracer, ActiveSpan.Continuation continuation) {
        this.tracer = tracer;
        this.continuation = continuation;
    }

    public ActiveSpan startSpan(String description) {
        return this.newOrChildSpan(description, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T continueSpan(Traceable<T> traceable) throws Exception {
        ActiveSpan scope = null;
        if (this.tracer.activeSpan() == null && this.continuation != null) {
            scope = this.continuation.activate();
        }
        try {
            Object object = traceable.call((TracerContext)new OpenTracingContext(this.tracer));
            return (T)object;
        }
        finally {
            if (this.continuation != null && scope != null) {
                scope.deactivate();
            }
        }
    }

    public <T> Callable<T> wrap(String description, final Traceable<T> traceable) {
        Callable callable = new Callable<T>(){

            @Override
            public T call() throws Exception {
                return traceable.call((TracerContext)new OpenTracingContext(OpenTracingContext.this.tracer));
            }
        };
        ActiveSpan parent = this.tracer.activeSpan();
        return () -> {
            try (ActiveSpan span = this.newOrChildSpan(description, parent);){
                Object v = callable.call();
                return v;
            }
        };
    }

    public void annotate(String key, String value) {
        ActiveSpan current = this.tracer.activeSpan();
        if (current != null) {
            current.setTag(key, value);
        }
    }

    public void timeline(String message) {
        ActiveSpan current = this.tracer.activeSpan();
        if (current != null) {
            current.log(message);
        }
    }

    public <T> T unwrap(Class<T> clazz) {
        if (Tracer.class.equals(clazz)) {
            return (T)this.tracer;
        }
        throw new IllegalArgumentException("The class is '" + clazz + "'not supported and cannot be unwrapped");
    }

    private ActiveSpan newOrChildSpan(String description, ActiveSpan parent) {
        if (parent == null) {
            return this.tracer.buildSpan(description).startActive();
        }
        return this.tracer.buildSpan(description).asChildOf((BaseSpan)parent).startActive();
    }
}

