/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.opentracing;

import io.opentracing.ActiveSpan;
import io.opentracing.BaseSpan;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.tracing.AbstractTracingProvider;
import org.apache.cxf.tracing.opentracing.TraceScope;
import org.apache.cxf.tracing.opentracing.internal.TextMapInjectAdapter;

public abstract class AbstractOpenTracingClientProvider
extends AbstractTracingProvider {
    protected static final Logger LOG = LogUtils.getL7dLogger(AbstractOpenTracingClientProvider.class);
    protected static final String TRACE_SPAN = "org.apache.cxf.tracing.client.opentracing.span";
    private final Tracer tracer;

    public AbstractOpenTracingClientProvider(Tracer tracer) {
        this.tracer = tracer;
    }

    protected AbstractTracingProvider.TraceScopeHolder<TraceScope> startTraceSpan(Map<String, List<String>> requestHeaders, URI uri, String method) {
        ActiveSpan parent = this.tracer.activeSpan();
        ActiveSpan span = null;
        span = parent == null ? this.tracer.buildSpan(this.buildSpanDescription(uri.toString(), method)).startActive() : this.tracer.buildSpan(this.buildSpanDescription(uri.toString(), method)).asChildOf((BaseSpan)parent).startActive();
        span.setTag(Tags.HTTP_METHOD.getKey(), method);
        span.setTag(Tags.HTTP_URL.getKey(), uri.toString());
        this.tracer.inject(span.context(), Format.Builtin.HTTP_HEADERS, (Object)new TextMapInjectAdapter(requestHeaders));
        ActiveSpan.Continuation continuation = null;
        if (this.isAsyncInvocation()) {
            continuation = span.capture();
            span.deactivate();
        }
        return new AbstractTracingProvider.TraceScopeHolder((Object)new TraceScope(span, continuation), continuation != null);
    }

    private boolean isAsyncInvocation() {
        return !JAXRSUtils.getCurrentMessage().getExchange().isSynchronous();
    }

    protected void stopTraceSpan(AbstractTracingProvider.TraceScopeHolder<TraceScope> holder, int responseStatus) {
        if (holder == null) {
            return;
        }
        TraceScope scope = (TraceScope)holder.getScope();
        if (scope != null) {
            ActiveSpan span = scope.getSpan();
            if (holder.isDetached()) {
                span = scope.getContinuation().activate();
            }
            span.setTag(Tags.HTTP_STATUS.getKey(), (Number)responseStatus);
            span.close();
        }
    }
}

